/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.controller;

import com.google.gson.Gson;
import com.tydic.datakbase.file.service.FileManagerService;
import com.tydic.datakbase.file.utils.Utils;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class FileManagerController {
    private static Logger logger = LoggerFactory.getLogger(FileManagerController.class);
    private Gson gson = new Gson();
    @Autowired
    private FileManagerService fileManagerService;

    @PostMapping(value={"/file/checkMD5"})
    public String checkMD5(String md5) {
        String path = this.fileManagerService.checkMD5(md5);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flag", 1);
        result.put("data", path);
        return this.gson.toJson(result);
    }

    @GetMapping(value={"/file/image/{path}.{format}"})
    public void showImage(@PathVariable String path, @PathVariable String format, HttpServletResponse response) throws IOException {
        if (Utils.isNotBlank((CharSequence)path) && Utils.isNotBlank((CharSequence)format)) {
            this.fileManagerService.showImage(path + "." + format, response);
        }
    }

    @GetMapping(value={"/file/fileDownload/{path}.{format}"})
    public void download(@PathVariable String path, @PathVariable String format, HttpServletResponse response) throws IOException {
        if (Utils.isNotBlank((CharSequence)path) && Utils.isNotBlank((CharSequence)format)) {
            this.fileManagerService.downloadFile(path + "." + format, response);
        }
    }

    @PostMapping(value={"/file/upload"})
    public String uploadFile(MultipartFile file, String md5, @RequestParam(required=false) String userName, HttpServletRequest request) throws IOException {
        String path = this.fileManagerService.saveFile(file, md5, userName, request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flag", 1);
        result.put("data", path);
        return this.gson.toJson(result);
    }

    @PostMapping(value={"/file/uploadByBinary"})
    public String uploadByBinary(String content, String fileName, String md5, @RequestParam(required=false) String userName, HttpServletRequest request) throws Exception {
        String path = this.fileManagerService.saveFile(content, fileName, md5, userName, request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flag", 1);
        result.put("data", path);
        return this.gson.toJson(result);
    }

    @PostMapping(value={"/file/list"})
    public String list(Integer page, Integer pageSize) {
        Map<String, Object> fileModelList = this.fileManagerService.getAllFile(page, pageSize);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flag", 1);
        result.put("data", fileModelList);
        return this.gson.toJson(result);
    }

    @PostMapping(value={"/file/delete"})
    public String delete(Long id) {
        boolean flag = this.fileManagerService.deleteFile(id);
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.put("flag", Integer.valueOf(1));
        result.put("data", Boolean.valueOf(flag));
        return this.gson.toJson(result);
    }

    @PostMapping(value={"/file/setUseAble"})
    public String setUseAble(Long id, Boolean userAble) {
        boolean flag = this.fileManagerService.setUseAble(id, userAble);
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.put("flag", Integer.valueOf(1));
        result.put("data", Boolean.valueOf(flag));
        return this.gson.toJson(result);
    }

    @PostMapping(value={"/file/export"})
    public String exportFiles(@RequestParam(value="urlList[]") String[] urlList, String filePath, String dbPath) throws IOException {
        List<Long> idList = this.fileManagerService.exportFiles(Arrays.asList(urlList), filePath, dbPath);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flag", 1);
        result.put("data", idList);
        return this.gson.toJson(result);
    }
}

