/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.service.impl;

import com.tydic.datakbase.file.base.FileConfigurationProperties;
import com.tydic.datakbase.file.service.FileOperationService;
import com.tydic.datakbase.file.utils.Base64;
import com.tydic.datakbase.file.utils.FileUtil;
import com.tydic.datakbase.file.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DefaultFileOperationServiceImpl
implements FileOperationService {
    private Logger logger = LoggerFactory.getLogger(DefaultFileOperationServiceImpl.class);
    @Autowired
    private FileConfigurationProperties configuration;
    private Pattern packagePattern;

    @Override
    public String uploadFile(String content, String fileName, String fileMD5) throws IOException {
        if (Utils.isBlank((CharSequence)content)) {
            this.logger.error("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return "-1";
        }
        Base64 base64 = new Base64();
        byte[] fileContent = base64.decode(content.substring("data:image/octet-stream;base64,".length()));
        File file = new File(this.configuration.getUploadTmpDir() + fileName);
        FileUtils.writeByteArrayToFile((File)file, (byte[])fileContent);
        this.logger.debug("\u6587\u4ef6\u89e3\u7801\u6210\u529f...");
        return this.uploadFile(file, fileMD5);
    }

    @Override
    public String uploadFile(MultipartFile file, String fileMD5) throws IOException {
        String uploadPath = null;
        if (!file.isEmpty()) {
            String fileName = file.getOriginalFilename();
            this.logger.debug("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a\uff1a{}", (Object)fileName);
            String path = this.configuration.getUploadTmpDir() + fileName;
            File dest = new File(path);
            if (!dest.getParentFile().exists()) {
                this.logger.debug("\u4e34\u65f6\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u5c06\u521b\u5efa\u76ee\u5f55\uff1a{}", (Object)dest.getParentFile().getAbsolutePath());
                dest.getParentFile().mkdirs();
            }
            file.transferTo(dest);
            uploadPath = this.uploadFile(dest, fileMD5);
            this.logger.debug(uploadPath);
            dest.delete();
        } else {
            uploadPath = "-1";
        }
        return uploadPath;
    }

    @Override
    public String uploadFile(File file, String fileMD5) throws IOException {
        if (null == file) {
            this.logger.error("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return "-1";
        }
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            this.logger.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\uff1a{}", (Object)fileName);
            return "-2";
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        this.logger.debug("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a\uff1a{}", (Object)fileName);
        if (!this.getPackagePattern().matcher(suffix).matches()) {
            this.logger.error("\u7cfb\u7edf\u4e0d\u5141\u8bb8\u4e0a\u4f20\u8be5\u7c7b\u578b\u7684\u6587\u4ef6\uff0c\u6587\u4ef6\u7c7b\u578b\uff1a{}", (Object)suffix);
            return "-2";
        }
        String dir = this.configuration.getStorePath() + FileUtil.fileMD5ToDir(fileMD5);
        File saveFile = new File(dir, fileMD5 + "." + suffix);
        if (!saveFile.exists()) {
            this.logger.debug("\u6587\u4ef6\u91cd\u547d\u540d\u4e3a{}\uff0c\u5e76\u4fdd\u5b58", (Object)saveFile.getName());
            if (!saveFile.getParentFile().exists()) {
                this.logger.debug("\u4fdd\u5b58\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u5c06\u521b\u5efa\u76ee\u5f55\uff1a{}", (Object)saveFile.getParentFile().getAbsolutePath());
                saveFile.getParentFile().mkdirs();
            }
            FileUtils.copyFile((File)file, (File)saveFile);
            file.delete();
        }
        String path = FileUtil.MD5ToPath(fileMD5) + "." + suffix;
        this.logger.debug("\u8fd4\u56de\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)path);
        return path;
    }

    @Override
    public void downloadFile(String path, String fileName, HttpServletResponse response) throws IOException {
        if (Utils.isBlank((CharSequence)path)) {
            this.logger.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
            response.getWriter().write("-3");
        }
        if (!path.contains(".")) {
            this.logger.error("\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff01:{}", (Object)path);
            response.getWriter().write("-3");
        }
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment;filename=\"" + new String(fileName.getBytes("UTF-8"), "ISO8859-1") + "\"");
        String filePath = this.pathTransToFilePath(path);
        File file = new File(this.configuration.getStorePath() + filePath);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);
             ServletOutputStream servletOutputStream = response.getOutputStream();
             BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)servletOutputStream);){
            this.logger.debug("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6...");
            byte[] b = new byte[256];
            while (-1 != inputStream.read(b)) {
                outputStream.write(b);
            }
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u53d1\u751f\u5f02\u5e38\uff01,\u6587\u4ef6\u771f\u5b9e\u8def\u5f84\uff1a{}", (Object)filePath);
            throw e;
        }
    }

    @Override
    public void showImage(String path, HttpServletResponse response) throws IOException {
        if (Utils.isBlank((CharSequence)path)) {
            this.logger.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
            response.getWriter().write("-3");
        }
        if (!path.contains(".")) {
            this.logger.error("\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff01:{}", (Object)path);
            response.getWriter().write("-3");
        }
        String filePath = this.pathTransToFilePath(path);
        File file = new File(this.configuration.getStorePath() + filePath);
        response.setContentType("image/png");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);
             ServletOutputStream servletOutputStream = response.getOutputStream();
             BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)servletOutputStream);){
            byte[] b = new byte[256];
            while (-1 != inputStream.read(b)) {
                outputStream.write(b);
            }
        }
        catch (IOException e) {
            this.logger.error("\u8f93\u51fa\u56fe\u7247\u5931\u8d25\uff01\uff0c\u56fe\u7247\u771f\u5b9e\u8def\u5f84{}", (Object)filePath);
            throw e;
        }
    }

    @Override
    public File getFile(String path) {
        if (Utils.isBlank((CharSequence)path)) {
            this.logger.error("MD5\u4e3a\u7a7a\uff01");
            return null;
        }
        String filePath = this.pathTransToFilePath(path);
        return new File(this.configuration.getStorePath() + filePath);
    }

    @Override
    public Boolean deleteFile(String path) {
        if (Utils.isBlank((CharSequence)path)) {
            this.logger.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
            return false;
        }
        if (!path.contains(".")) {
            this.logger.error("\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff01:{}", (Object)path);
            return false;
        }
        String filePath = this.pathTransToFilePath(path);
        File file = new File(this.configuration.getStorePath() + filePath);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    @Override
    public boolean exportFiles(List<String> pathList, String destDirPath) throws IOException {
        File destDir = new File(destDirPath);
        if (!destDir.exists()) {
            this.logger.debug("\u5bfc\u51fa\u76ee\u6807\u76ee\u5f55{}\u4e0d\u5b58\u5728\uff0c\u5c1d\u8bd5\u521b\u5efa\u76ee\u6807\u76ee\u5f55", (Object)destDirPath);
            destDir.mkdirs();
        }
        ArrayList<String> failList = new ArrayList<String>();
        this.logger.debug("\u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6...");
        this.logger.debug("\u5bfc\u51fa\u6587\u4ef6\u8def\u5f84\u5217\u8868\uff1a{}", pathList);
        if (null != pathList && !pathList.isEmpty()) {
            for (String path : pathList) {
                if (Utils.isBlank((CharSequence)path)) {
                    this.logger.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
                    failList.add(path);
                    continue;
                }
                if (!path.contains(".")) {
                    this.logger.error("\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff01:{}", (Object)path);
                    failList.add(path);
                    continue;
                }
                String filePath = this.pathTransToFilePath(path);
                File file = new File(this.configuration.getStorePath() + filePath);
                if (!file.exists()) {
                    failList.add(path);
                    continue;
                }
                File saveFile = new File(destDir, filePath);
                FileUtils.copyFile((File)file, (File)saveFile);
            }
        }
        if (null != failList && !failList.isEmpty()) {
            this.logger.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\u5217\u8868\uff1a{}", failList);
        }
        return false;
    }

    @Override
    public boolean moveFile(File sourceFile, File destDir, boolean delete) throws IOException {
        if (!sourceFile.exists()) {
            this.logger.error("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728!:{}", (Object)sourceFile.getAbsolutePath());
            return false;
        }
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (!destDir.isDirectory()) {
            this.logger.error("\u79fb\u52a8\u76ee\u6807\u5fc5\u987b\u4e3a\u6587\u4ef6\u5939!:{}", (Object)destDir.getAbsolutePath());
            return false;
        }
        File destFile = new File(destDir, sourceFile.getName());
        if (sourceFile.isDirectory()) {
            File[] files;
            for (File file : files = sourceFile.listFiles()) {
                this.moveFile(file, destFile, delete);
            }
        } else {
            FileUtils.copyFile((File)sourceFile, (File)destFile);
        }
        if (delete) {
            sourceFile.delete();
        }
        return true;
    }

    private Pattern getPackagePattern() {
        if (null == this.packagePattern) {
            this.packagePattern = Pattern.compile(this.configuration.getSuffix());
        }
        return this.packagePattern;
    }

    private String pathTransToFilePath(String path) {
        String[] pathParam = path.split("\\.");
        String fileMd5 = FileUtil.pathToMD5(pathParam[0]);
        String filePath = FileUtil.fileMD5ToDir(fileMd5) + fileMd5 + "." + pathParam[1];
        return filePath;
    }
}

