/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.service.impl;

import com.google.gson.Gson;
import com.tydic.datakbase.file.model.FileModel;
import com.tydic.datakbase.file.service.FileManagerService;
import com.tydic.datakbase.file.service.FileModelService;
import com.tydic.datakbase.file.service.FileOperationService;
import com.tydic.datakbase.file.utils.Base64;
import com.tydic.datakbase.file.utils.FileUtil;
import com.tydic.datakbase.file.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileManagerServiceImpl
implements FileManagerService {
    private static final Logger log = LoggerFactory.getLogger(FileManagerServiceImpl.class);
    private static Logger logger = LoggerFactory.getLogger(FileManagerServiceImpl.class);
    @Autowired
    private FileOperationService fileOperationService;
    @Autowired
    private FileModelService fileModelService;

    @Override
    public String checkMD5(String fileMD5) {
        return this.fileModelService.checkMD5(fileMD5);
    }

    @Override
    public String saveFile(String content, String fileName, String fileMD5, String userName, HttpServletRequest request) throws Exception {
        FileModel fileModel = new FileModel();
        fileModel.setMD5(fileMD5);
        fileModel.setFileName(fileName);
        fileModel.setUserName(userName);
        fileModel.setUserIp(this.getIpAddress(request));
        fileModel.setCreateTime(new Date());
        fileModel.setUseAble(true);
        return this.saveFile(content, fileModel);
    }

    @Override
    public String saveFile(String content, FileModel fileModel) throws Exception {
        if (StringUtils.isBlank((CharSequence)content)) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        fileModel.setSize(Long.valueOf(new Base64().decode(content.substring("data:image/octet-stream;base64,".length())).length));
        String path = this.fileOperationService.uploadFile(content, fileModel.getFileName(), fileModel.getMD5());
        if (path.contains("-")) {
            return path;
        }
        fileModel.setPath(path);
        return this.fileModelService.saveFileModel(fileModel);
    }

    @Override
    public String saveFile(MultipartFile file, String fileMD5, String userName, HttpServletRequest request) throws IOException {
        FileModel fileModel = new FileModel();
        fileModel.setMD5(fileMD5);
        fileModel.setUserName(userName);
        fileModel.setUserIp(this.getIpAddress(request));
        fileModel.setCreateTime(new Date());
        fileModel.setUseAble(true);
        return this.saveFile(file, fileModel);
    }

    @Override
    public String saveFile(MultipartFile file, FileModel fileModel) throws IOException {
        String path = this.fileOperationService.uploadFile(file, fileModel.getMD5());
        if (path.contains("-")) {
            return path;
        }
        fileModel.setFileName(file.getOriginalFilename());
        fileModel.setSize(file.getSize());
        fileModel.setPath(path);
        return this.fileModelService.saveFileModel(fileModel);
    }

    @Override
    public void downloadFile(String path, HttpServletResponse response) throws IOException {
        if (Utils.isBlank((CharSequence)path)) {
            logger.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
            response.getWriter().write("-3");
            return;
        }
        if (!path.contains(".")) {
            logger.error("\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff01");
            response.getWriter().write("-3");
            return;
        }
        logger.debug("path:{}", (Object)path);
        String MD5 = FileUtil.pathToMD5(path.split("\\.")[0]);
        FileModel fileModel = this.fileModelService.findFileModelByMD5(MD5);
        if (null == fileModel) {
            return;
        }
        if (fileModel.getUseAble().booleanValue()) {
            this.fileOperationService.downloadFile(path, fileModel.getFileName(), response);
        }
    }

    @Override
    public void showImage(String path, HttpServletResponse response) throws IOException {
        if (Utils.isBlank((CharSequence)path)) {
            logger.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
            response.getWriter().write("-3");
            return;
        }
        if (!path.contains(".")) {
            logger.error("\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff01");
            response.getWriter().write("-3");
            return;
        }
        logger.debug("path:{}", (Object)path);
        String MD5 = FileUtil.pathToMD5(path.split("\\.")[0]);
        FileModel fileModel = this.fileModelService.findFileModelByMD5(MD5);
        if (null == fileModel) {
            return;
        }
        if (fileModel.getUseAble().booleanValue()) {
            this.fileOperationService.showImage(path, response);
        }
    }

    @Override
    public List<FileModel> getAllFile() {
        return this.fileModelService.getAllFile();
    }

    @Override
    public Map<String, Object> getAllFile(Integer page, Integer pageSize) {
        if (null == page || 0 >= page) {
            page = 1;
        }
        if (null == pageSize || 0 >= pageSize) {
            pageSize = 5;
        }
        return this.fileModelService.getAllFile(page, pageSize);
    }

    @Override
    public File getFileByMD5(String MD5) {
        FileModel fileModel = this.fileModelService.findFileModelByMD5(MD5);
        return this.fileOperationService.getFile(fileModel.getPath());
    }

    @Override
    public Boolean deleteFile(Long id) {
        boolean flag = this.fileModelService.deleteFileModel(id);
        return flag;
    }

    @Override
    public Boolean deleteFileByPath(String path) {
        if (Utils.isBlank((CharSequence)path)) {
            logger.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
            return false;
        }
        if (!path.contains(".")) {
            logger.error("\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff01");
            return false;
        }
        String MD5 = FileUtil.pathToMD5(path.split("\\.")[0]);
        boolean flag = this.fileModelService.deleteFileModelByMD5(MD5);
        if (flag) {
            flag = this.fileOperationService.deleteFile(path);
        }
        return flag;
    }

    @Override
    public Boolean updateFileInfo(FileModel fileModel) {
        return this.fileModelService.updateFileModel(fileModel);
    }

    @Override
    public Boolean setUseAble(Long id, boolean able) {
        return this.fileModelService.setUseAble(id, able);
    }

    @Override
    public List<Long> exportFiles(List<String> urlList, String filePath, String dbPath) throws IOException {
        if (null == urlList || urlList.isEmpty()) {
            return null;
        }
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> MD5List = new ArrayList<String>();
        log.debug("\u5bfc\u51faurl\u5217\u8868\uff1a{}", (Object)new Gson().toJson(urlList));
        Iterator<String> iterator = urlList.iterator();
        while (iterator.hasNext()) {
            String md5;
            String url;
            String path = url = iterator.next();
            if (url.startsWith("http")) {
                if (url.contains("/file/image/")) {
                    path = url.split("/file/image/")[1];
                } else if (url.contains("/file/fileDownload/")) {
                    path = url.split("/file/fileDownload/")[1];
                } else {
                    logger.warn("\u65e0\u6548\u7684\u5730\u5740\uff1a{}", (Object)url);
                    continue;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(md5 = FileUtil.pathToMD5(path.split("\\.")[0])))) continue;
            pathList.add(path);
            MD5List.add(md5);
        }
        List<Long> idList = this.fileModelService.exportFileModels(MD5List, dbPath);
        if (!idList.isEmpty()) {
            this.fileOperationService.exportFiles(pathList, filePath);
        }
        return idList;
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

