/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Utils
extends StringUtils {
    private static String pattern = "yyyy-MM-dd HH:mm:ss.S";

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replaceAll("-", "");
    }

    public static Integer toInteger(String value) {
        if (value == null || "".equals(value)) {
            return new Integer(0);
        }
        return new Integer(value);
    }

    public static int toInt(String value) {
        return Utils.toInteger(value);
    }

    public static String disNull(String value) {
        return value == null ? "--" : value;
    }

    public static String toDoubleString(String value) {
        String ret = "0";
        try {
            ret = Double.parseDouble(value) + "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String NULL(String value) {
        return value == null ? "" : value;
    }

    public static String htmlDisNull(String value) {
        if (value == null) {
            value = "--";
        }
        return "".equals(value) ? "--" : value;
    }

    public static String getString(String data, String defaults) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return defaults;
        }
        return data;
    }

    public static String replaceSplit(String str) {
        if (str != null) {
            str = str.replaceAll(",", "\u2593");
        }
        return str;
    }

    public static boolean isNullValue(String value) {
        return null == value || "".equals(value);
    }

    public static boolean isNotNullValue(String value) {
        return null != value && !"".equals(value);
    }

    public static boolean isNullValue(Object o) {
        return null == o;
    }

    public static boolean isNullObjects(Object ... o) {
        boolean bool = false;
        for (Object o1 : o) {
            if (null != o1 && !"".equals(o1.toString())) continue;
            bool = true;
            break;
        }
        return bool;
    }

    public static String printStrAll(String cs, String content, int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n * 2; ++i) {
            if (i == n - 1) {
                s.append(content);
                continue;
            }
            s.append(cs);
        }
        return s.toString();
    }

    public static String printStrLeft(String cs, String content, int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            s.append(cs);
        }
        s.append(content);
        return s.toString();
    }

    public static String printStrRight(String cs, String content, int n) {
        StringBuilder s = new StringBuilder(content);
        for (int i = 0; i < n; ++i) {
            s.append(cs);
        }
        return s.toString();
    }

    public static List<String> rexMatcher(String rex, String sourceStr) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(rex);
        Matcher matcher = pattern.matcher(sourceStr);
        while (matcher.find()) {
            String data = matcher.group();
            list.add(data);
        }
        return list;
    }

    public static String rexMatcherStr(String rex, String sourceStr) {
        Pattern pattern = Pattern.compile(rex);
        Matcher matcher = pattern.matcher(sourceStr);
        if (matcher.find()) {
            String data = matcher.group();
            return data;
        }
        return "";
    }

    public static String joinWithWarp(List liststr, String separator, String wrapWith) {
        for (int i = 0; i < liststr.size(); ++i) {
            if (!Utils.isNotBlank((CharSequence)liststr.get(i).toString())) continue;
            liststr.set(i, Utils.wrap((String)liststr.get(i).toString(), (String)wrapWith));
        }
        return Utils.join((Iterable)liststr, (String)separator);
    }

    public static Integer getRandom() {
        int max = 2550;
        int min = 0;
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static boolean isBlankWithEquals(String source, String value) {
        return Utils.isNotBlank((CharSequence)source) && Utils.equals((CharSequence)source, (CharSequence)value);
    }

    public static void warpListElement(String left, List<String> list, String right) {
        if (null != list && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                String tempval = String.valueOf(list.get(i));
                StringBuilder val = new StringBuilder(tempval);
                if (Utils.isNotBlank((CharSequence)left)) {
                    val.insert(0, left);
                }
                if (Utils.isNotBlank((CharSequence)right)) {
                    val.append(right);
                }
                list.set(i, val.toString());
            }
        }
    }

    public static List<String> join(String source, String separator) {
        return Utils.isBlank((CharSequence)source) ? null : Arrays.asList(source.split(separator));
    }

    public static String appendNotStr(String source, String append) {
        if (Utils.contains((CharSequence)source, (CharSequence)append)) {
            return source;
        }
        return source + "_" + append;
    }

    public static String findWithReplace(String source, String start, String end) {
        String res = "";
        if (Utils.isNotBlank((CharSequence)source)) {
            res = source.startsWith("\"{") && source.endsWith("}\"") ? source.replaceFirst("^(\"\\{)", "{").replaceFirst("(\\}\")", "\\}") : source;
        }
        return res;
    }
}

