app.factory('fileManagerService',['SyncRequestSrv','Constant',function(SyncRequestSrv,Constant){
    var fileManagerService={
        checkFileMD5:function(fileMD5){
            var reqResult=SyncRequestSrv.checkMd5(fileMD5,Constant.baseSrvPath+'file/checkMD5');
            return reqResult;
        },
        uploadFile:function(file,fileMD5){
            var reqResult=SyncRequestSrv.uploadData(file,fileMD5,Constant.baseSrvPath+'file/upload');
            return reqResult;
        },
        getFileList:function(page,pageSize){
            var param={
                page:page,
                pageSize:pageSize
            };
            var reqResult=SyncRequestSrv.getData(param,Constant.baseSrvPath+'file/list');
            return reqResult;
        },
        setFileUserAble:function(id,able){
            var param={
                id:id,
                userAble:able
            };
            var reqResult=SyncRequestSrv.getData(param,Constant.baseSrvPath+'file/setUseAble');
            return reqResult;
        },
        updateFileInfo:function(){

        },
        deleteFile:function(id){
            var reqResult=SyncRequestSrv.getData({id:id},Constant.baseSrvPath+'file/delete');
            return reqResult;
        },
        exportFile:function(urlList,filePath,dbPath){
            var param={
                urlList:urlList,
                filePath:filePath,
                dbPath:dbPath
            };
            var reqResult=SyncRequestSrv.getData(param,Constant.baseSrvPath+'file/export');
            return reqResult;
        }
    };

    return fileManagerService;
}]);