/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class DataToScriptService {
    private static final Logger log = LoggerFactory.getLogger(DataToScriptService.class);

    public String loadData(String filePath, Object c, List ids, JpaRepository jpaRepository, Boolean isSequence) throws IOException {
        List dataList = jpaRepository.findAllById((Iterable)ids);
        List<String> sqlLists = this.dataToInsertSql(c, dataList);
        sqlLists.forEach(s -> log.info(s));
        if (null != sqlLists && !sqlLists.isEmpty()) {
            if (isSequence.booleanValue()) {
                this.initSequence(sqlLists);
            }
            this.writerFile(filePath, sqlLists);
        } else {
            log.warn("\u672a\u83b7\u53d6\u5230\u6570\u636e,\u4e0d\u6267\u884c\u5199\u5165\u6587\u4ef6\u64cd\u4f5c");
        }
        return filePath;
    }

    private List<String> dataToInsertSql(Object classze, List datas) throws RuntimeException {
        Table table = classze.getClass().getAnnotation(Table.class);
        StringBuilder sql = new StringBuilder();
        if (null != table) {
            sql.append("INSERT INTO ");
            sql.append(table.name());
            ArrayList<String> columns = new ArrayList<String>();
            for (Field field : classze.getClass().getDeclaredFields()) {
                Column column = field.getAnnotation(Column.class);
                if (null == column) continue;
                columns.add(column.name());
            }
            sql.append(" (").append(StringUtils.join(columns, (String)",")).append(")").append(" \n\tVALUES ");
        }
        return datas.stream().map(data -> {
            Object aClass = data;
            ArrayList<String> rowVals = new ArrayList<String>();
            for (Field field : aClass.getClass().getDeclaredFields()) {
                try {
                    Transient ts = field.getAnnotation(Transient.class);
                    if (null != ts) {
                        log.warn("[{}]\u975e\u8868\u5b57\u6bb5\u8df3\u8fc7", (Object)field.getName());
                        continue;
                    }
                    if (this.encoderByMd5("serialVersionUID").equals(this.encoderByMd5(field.getName()))) continue;
                    Method method = aClass.getClass().getMethod("get" + DataToScriptService.toUpperCaseFirstOne(field.getName()), new Class[0]);
                    Object val = method.invoke(aClass, new Object[0]);
                    if (null == val) {
                        rowVals.add("null");
                        continue;
                    }
                    if (val instanceof Number) {
                        rowVals.add(method.getReturnType().cast(val).toString());
                        continue;
                    }
                    if (val instanceof Date) {
                        rowVals.add("'" + (Date)val + "'");
                        continue;
                    }
                    rowVals.add("'" + method.getReturnType().cast(val).toString() + "'");
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return sql.toString() + "(" + StringUtils.join(rowVals, (String)",") + ");\r\n";
        }).collect(Collectors.toList());
    }

    private void writerFile(String filePath, List<String> dataVals) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        File dest = new File(filePath);
        File dir = dest.getParentFile();
        if (null == dir) {
            log.error("dir is error");
            log.error(filePath);
            throw new IOException("\u521b\u5efa\u6570\u636e\u5e93\u6587\u4ef6\u5b58\u653e\u76ee\u5f55\u5931\u8d25");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            dataVals.forEach(d -> {
                try {
                    bufferedWriter.write((String)d);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            bufferedWriter.flush();
            log.info("\u6210\u529f\u5199\u5165[{}]\u884c\u6570\u636e\u5230\u6587\u4ef6[{}]\u4e2d", (Object)dataVals.size(), (Object)filePath);
        }
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private String encoderByMd5(String str) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        BASE64Encoder base64en = new BASE64Encoder();
        String newstr = base64en.encode(md5.digest(str.getBytes("utf-8")));
        return newstr;
    }

    private void initSequence(List<String> initSqls) {
        String sql = "INSERT INTO datak_base_sequence(name,current_value,increment) \r\n\tVALUES('init_sequence',0,1);";
        initSqls.add(sql);
    }
}

