/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.base;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import java.sql.SQLException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DruidConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${druid.mysql.jdbcUrl}")
    private String dbUrl;
    @Value(value="${druid.mysql.username}")
    private String username;
    @Value(value="${druid.mysql.password}")
    private String password;
    @Value(value="${druid.mysql.driverClass}")
    private String driverClassName;
    @Value(value="${druid.mysql.initialSize}")
    private int initialSize;
    @Value(value="${druid.mysql.minIdle}")
    private int minIdle;
    @Value(value="${druid.mysql.maxActive}")
    private int maxActive;
    @Value(value="${druid.mysql.maxWait}")
    private int maxWait;
    @Value(value="${druid.mysql.timeBetweenEvictionRunsMillis}")
    private int timeBetweenEvictionRunsMillis;
    @Value(value="${druid.mysql.minEvictableIdleTimeMillis}")
    private int minEvictableIdleTimeMillis;
    @Value(value="${druid.mysql.validationQuery}")
    private String validationQuery;
    @Value(value="${druid.mysql.testWhileIdle}")
    private boolean testWhileIdle;
    @Value(value="${druid.mysql.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${druid.mysql.testOnReturn}")
    private boolean testOnReturn;
    @Value(value="${druid.mysql.poolPreparedStatements}")
    private boolean poolPreparedStatements;
    @Value(value="${druid.mysql.filters}")
    private String filters;

    @Bean
    public ServletRegistrationBean druidServlet() {
        ServletRegistrationBean reg = new ServletRegistrationBean();
        reg.setServlet((Servlet)new StatViewServlet());
        reg.addUrlMappings(new String[]{"/druid/*"});
        reg.addInitParameter("loginUsername", "druid");
        reg.addInitParameter("loginPassword", "druid321");
        return reg;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new WebStatFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        filterRegistrationBean.addInitParameter("profileEnable", "true");
        filterRegistrationBean.addInitParameter("principalCookieName", "USER_COOKIE");
        filterRegistrationBean.addInitParameter("principalSessionName", "USER_SESSION");
        return filterRegistrationBean;
    }

    @Bean(name={"druidDataSource"})
    @Primary
    public DataSource druidDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dbUrl);
        datasource.setUsername(this.username);
        datasource.setPassword(this.password);
        datasource.setDriverClassName(this.driverClassName);
        datasource.setInitialSize(this.initialSize);
        datasource.setMinIdle(this.minIdle);
        datasource.setMaxActive(this.maxActive);
        datasource.setMaxWait((long)this.maxWait);
        datasource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        datasource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
        datasource.setValidationQuery(this.validationQuery);
        datasource.setTestWhileIdle(this.testWhileIdle);
        datasource.setTestOnBorrow(this.testOnBorrow);
        datasource.setTestOnReturn(this.testOnReturn);
        datasource.setPoolPreparedStatements(this.poolPreparedStatements);
        try {
            datasource.setFilters(this.filters);
        }
        catch (SQLException e) {
            this.logger.error("druid configuration initialization filter", (Throwable)e);
        }
        return datasource;
    }
}

