/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.service.serviceimpl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.datakbase.mapper.DatakMultiviewRecordMapper;
import com.tydic.datakbase.model.DatakMultiviewRecord;
import com.tydic.datakbase.service.DatakMultiviewRecordService;
import com.tydic.datakbase.service.SeqService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatakMultiviewRecordServiceImpl
implements DatakMultiviewRecordService {
    private Logger logger = LoggerFactory.getLogger(DatakMultiviewRecordServiceImpl.class);
    @Autowired
    private SeqService seqService;
    @Autowired
    private DatakMultiviewRecordMapper datakMultiviewRecordMapper;

    @Override
    public int getId() {
        return this.seqService.nextVal("mult_view_id_sequence");
    }

    @Override
    public Map<String, Object> saveOrUpdate(DatakMultiviewRecord record, String multiViewId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)record.getViewName()) || StringUtils.isBlank((CharSequence)record.getCtOption())) {
            result.put("flag", 0);
            result.put("msg", "\u53c2\u6570\u9519\u8bef");
            result.put("data", null);
            return result;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)multiViewId)) {
                record.setMultiViewId(Integer.parseInt(multiViewId));
                result = this.update(record);
            } else {
                result = this.save(record);
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            result.put("flag", 0);
            result.put("msg", "\u64cd\u4f5c\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", null);
            return result;
        }
        return result;
    }

    @Override
    public Map<String, Object> save(DatakMultiviewRecord record) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int id = this.getId();
        record.setMultiViewId(id);
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        int cnt = this.datakMultiviewRecordMapper.insertSelective(record);
        if (0 == cnt) {
            this.logger.error("\u4fdd\u5b58\u5931\u8d25");
            result.put("flag", 0);
            result.put("msg", "\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", null);
        } else {
            this.logger.info("\u4fdd\u5b58\u6210\u529f");
            result.put("flag", 1);
            result.put("msg", "\u5199\u5165\u6570\u636e\u5e93\u6210\u529f");
            result.put("data", null);
        }
        return result;
    }

    @Override
    public Map<String, Object> update(DatakMultiviewRecord record) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        record.setUpdateTime(new Date());
        int cn = this.datakMultiviewRecordMapper.updateSelectiveById(record);
        if (0 != cn) {
            this.logger.info("\u66f4\u65b0\u6210\u529f");
            result.put("flag", 1);
            result.put("msg", "\u66f4\u65b0\u6570\u636e\u5e93\u6210\u529f");
            result.put("data", record.getMultiViewId());
        } else {
            this.logger.error("\u66f4\u65b0\u5931\u8d25");
            result.put("flag", 0);
            result.put("msg", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", null);
        }
        return result;
    }

    @Override
    public Map<String, Object> selectMultiViewById(String multiViewId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)multiViewId)) {
            this.logger.error("\u53c2\u6570\u9519\u8bef");
            result.put("flag", 0);
            result.put("msg", "\u53c2\u6570[multiViewId]\u4e0d\u80fd\u4e3a\u7a7a!");
            result.put("data", null);
            return result;
        }
        if (multiViewId == null) {
            return null;
        }
        DatakMultiviewRecord record = null;
        try {
            record = this.datakMultiviewRecordMapper.selectByPrimaryKey(Integer.parseInt(multiViewId));
        }
        catch (NumberFormatException e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u9519\u8bef", (Throwable)e);
            result.put("flag", 0);
            result.put("msg", "\u67e5\u8be2\u6570\u636e\u5e93\u9519\u8bef");
            result.put("data", null);
            return result;
        }
        if (record == null) {
            this.logger.error("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            result.put("flag", 0);
            result.put("msg", "\u67e5\u8be2\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", null);
            return result;
        }
        result.put("flag", 1);
        result.put("msg", "\u67e5\u8be2\u6570\u636e\u5e93\u6210\u529f");
        result.put("data", record);
        return result;
    }

    @Override
    public int selectExistById(String multiViewId) {
        return this.datakMultiviewRecordMapper.selectCountByPrimaryKey(Integer.parseInt(multiViewId));
    }

    @Override
    public Map<String, Object> getMultiViewDataList(String userId, String searchViewName, int pageSize, int curPage) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (curPage <= 1) {
            curPage = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        PageInfo atcpi = null;
        HashMap<String, PageInfo> data = new HashMap<String, PageInfo>();
        try {
            PageHelper.startPage((int)curPage, (int)pageSize);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userId", userId);
            params.put("searchViewName", searchViewName);
            List<DatakMultiviewRecord> list = this.datakMultiviewRecordMapper.selectMultiViewDataList(params);
            atcpi = new PageInfo(list);
            data.put("viewListPageInfo", atcpi);
        }
        catch (Exception e) {
            this.logger.error("getMultiViewDataList: selectMultiViewDataList\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u9519");
            this.logger.error(e.getMessage());
            resultMap.put("flag", 0);
            resultMap.put("data", null);
            resultMap.put("msg", "query fail");
            return resultMap;
        }
        resultMap.put("flag", 1);
        resultMap.put("data", data);
        resultMap.put("msg", "query success");
        return resultMap;
    }

    @Override
    public List<DatakMultiviewRecord> selectByIdList(List<String> idList) {
        return this.datakMultiviewRecordMapper.selectByPrimaryKeyList(idList);
    }
}

