/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.service.serviceimpl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.datakbase.mapper.DatakViewRecordMapper;
import com.tydic.datakbase.mapper.DatakViewShareMapper;
import com.tydic.datakbase.model.DatakViewRecord;
import com.tydic.datakbase.model.DatakViewShare;
import com.tydic.datakbase.service.DatakViewRecordService;
import com.tydic.datakbase.service.SeqService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatakViewRecordServiceImpl
implements DatakViewRecordService {
    private Logger logger = LoggerFactory.getLogger(DatakViewRecordServiceImpl.class);
    @Autowired
    private DatakViewRecordMapper datakViewRecordMapper;
    @Autowired
    private DatakViewShareMapper datakViewShareMapper;
    @Autowired
    private SeqService seqService;

    @Override
    public int getId() {
        return this.seqService.nextVal("view_id_sequence");
    }

    @Override
    public Map<String, Object> save(DatakViewRecord datakViewRecord, String userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int id = this.getId();
        datakViewRecord.setViewId(id);
        datakViewRecord.setCreateTime(new Date());
        datakViewRecord.setUpdateTime(new Date());
        int cnt = this.datakViewRecordMapper.insert(datakViewRecord);
        if (0 == cnt) {
            this.logger.error("\u4fdd\u5b58\u5931\u8d25");
            result.put("flag", 0);
            result.put("msg", "\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", null);
            return result;
        }
        DatakViewShare datakViewShare = new DatakViewShare();
        datakViewShare.setCreateUserId(userId);
        datakViewShare.setShareUserId(userId);
        datakViewShare.setViewId(Long.valueOf(id));
        int resultShare = this.datakViewShareMapper.insert(datakViewShare);
        if (resultShare != 0) {
            result.put("flag", 1);
            result.put("msg", "\u4fdd\u5b58\u64cd\u4f5c\uff0c\u5206\u4eab\u6210\u529f\uff01");
            result.put("data", id);
            return result;
        }
        result.put("flag", 0);
        result.put("msg", "\u4fdd\u5b58\u64cd\u4f5c\uff0c\u5206\u4eab\u5931\u8d25\uff01");
        result.put("data", null);
        return result;
    }

    @Override
    public Map<String, Object> updata(DatakViewRecord datakViewRecord) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        datakViewRecord.setUpdateTime(new Date());
        int cn = this.datakViewRecordMapper.updateByPrimaryKeyWithBLOBs(datakViewRecord);
        if (0 != cn) {
            result.put("flag", 1);
            result.put("msg", "\u5199\u5165\u6570\u636e\u5e93\u6210\u529f");
            result.put("data", datakViewRecord.getViewId());
        } else {
            result.put("flag", 0);
            result.put("msg", "\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", datakViewRecord.getViewId());
        }
        return result;
    }

    @Override
    public Map<String, Object> saveOrUpdate(DatakViewRecord record, String viewId, String userId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)record.getViewName()) || StringUtils.isBlank((CharSequence)record.getViewInfo())) {
            result.put("flag", 0);
            result.put("msg", "\u53c2\u6570\u9519\u8bef");
            result.put("data", null);
            return result;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)viewId)) {
                record.setViewId(Integer.parseInt(viewId));
                result = this.updata(record);
            } else {
                result = this.save(record, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u4fdd\u5b58\u5931\u8d25");
            result.put("flag", 0);
            result.put("msg", "\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", null);
            return result;
        }
        return result;
    }

    @Override
    public PageInfo<DatakViewRecord> getList(String userId, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<DatakViewRecord> list = this.datakViewRecordMapper.selectByUserId(userId);
        return new PageInfo(list);
    }

    @Override
    public Map<String, Object> getById(String viewId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)viewId)) {
            this.logger.error("\u53c2\u6570\u9519\u8bef");
            result.put("flag", 0);
            result.put("msg", "\u53c2\u6570[viewId]\u4e0d\u80fd\u4e3a\u7a7a!");
            result.put("data", null);
            return result;
        }
        if (viewId == null) {
            return null;
        }
        DatakViewRecord record = null;
        try {
            record = this.datakViewRecordMapper.selectByPrimaryKey(Integer.parseInt(viewId));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u9519\u8bef");
            result.put("flag", 0);
            result.put("msg", "\u67e5\u8be2\u6570\u636e\u5e93\u9519\u8bef");
            result.put("data", null);
            return result;
        }
        if (record == null) {
            this.logger.error("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            result.put("flag", 0);
            result.put("msg", "\u67e5\u8be2\u6570\u636e\u5e93\u5931\u8d25");
            result.put("data", null);
            return result;
        }
        result.put("flag", 1);
        result.put("msg", "\u67e5\u8be2\u6570\u636e\u5e93\u6210\u529f");
        result.put("data", record);
        return result;
    }

    @Override
    public PageInfo<DatakViewRecord> selectViewDataList(Map map) {
        int curPage = (Integer)map.get("curPage");
        int pageSize = (Integer)map.get("pageSize");
        PageHelper.startPage((int)curPage, (int)pageSize);
        List<DatakViewRecord> list = this.datakViewRecordMapper.selectViewDataList(map);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<DatakViewRecord> selectViewDataShareList(Map map) {
        int curPage = (Integer)map.get("curPage");
        int pageSize = (Integer)map.get("pageSize");
        PageHelper.startPage((int)curPage, (int)pageSize);
        List<DatakViewRecord> list = this.datakViewRecordMapper.selectViewDataShareList(map);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<DatakViewRecord> selectViewDataMyselfList(Map map) {
        int curPage = (Integer)map.get("curPage");
        int pageSize = (Integer)map.get("pageSize");
        PageHelper.startPage((int)curPage, (int)pageSize);
        List<DatakViewRecord> list = this.datakViewRecordMapper.selectViewDataMyselfList(map);
        return new PageInfo(list);
    }

    @Override
    public Map<String, Object> getViewDataList(String userId, String type, String searchViewName, String viewId, int pageSize, int curPage, String viewIdList) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)userId)) {
            this.logger.error("getViewList: \u53c2\u6570\u9519\u8bef\uff0cuserId\u4e3a\u7a7a");
            resultMap.put("viewList", null);
            return resultMap;
        }
        if (curPage <= 1) {
            curPage = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("userId", userId);
        paramMap.put("curPage", curPage);
        paramMap.put("pageSize", pageSize);
        if (StringUtils.isNotBlank((CharSequence)searchViewName)) {
            paramMap.put("viewName", searchViewName);
        } else {
            paramMap.put("viewName", null);
        }
        if (StringUtils.isNotBlank((CharSequence)viewId) && StringUtils.isBlank((CharSequence)viewIdList)) {
            paramMap.put("viewIdList", viewId);
        }
        if (StringUtils.isBlank((CharSequence)viewId) && StringUtils.isNotBlank((CharSequence)viewIdList)) {
            viewIdList = viewIdList.replace("[", "");
            viewIdList = viewIdList.replace("]", "");
            paramMap.put("viewIdList", viewIdList);
        }
        PageInfo<DatakViewRecord> atcpi = null;
        PageInfo<DatakViewRecord> pageTotal = null;
        PageInfo<DatakViewRecord> pageByShare = null;
        PageInfo<DatakViewRecord> pageByMyself = null;
        HashMap<String, String> resultListMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> data = new HashMap<String, HashMap<String, String>>();
        try {
            atcpi = type != null && type.equals("0") ? this.selectViewDataList(paramMap) : (type != null && type.equals("1") ? this.selectViewDataShareList(paramMap) : (type != null && type.equals("2") ? this.selectViewDataMyselfList(paramMap) : this.selectViewDataList(paramMap)));
            if (type != null && !type.equals("")) {
                pageTotal = this.selectViewDataList(paramMap);
                if (pageTotal != null) {
                    resultListMap.put("total", String.valueOf(pageTotal.getTotal()));
                } else {
                    resultListMap.put("total", "0");
                }
                pageByShare = this.selectViewDataShareList(paramMap);
                if (pageByShare != null) {
                    resultListMap.put("totalShare", String.valueOf(pageByShare.getTotal()));
                } else {
                    resultListMap.put("totalShare", "0");
                }
                pageByMyself = this.selectViewDataMyselfList(paramMap);
                if (pageByMyself != null) {
                    resultListMap.put("totalByMyself", String.valueOf(pageByMyself.getTotal()));
                } else {
                    resultListMap.put("totalByMyself", "0");
                }
            }
            data.put("totalList", resultListMap);
            data.put("viewListPageInfo", (HashMap<String, String>)atcpi);
        }
        catch (Exception e) {
            this.logger.error("getViewDataList: selectViewDataList\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u9519");
            this.logger.error(e.getMessage());
            resultMap.put("flag", 0);
            resultMap.put("data", null);
            resultMap.put("msg", "query fail");
            return resultMap;
        }
        resultMap.put("flag", 1);
        resultMap.put("data", data);
        resultMap.put("msg", "query success");
        return resultMap;
    }

    @Override
    public DatakViewRecord selectViewById(String viewId) {
        return this.datakViewRecordMapper.selectByPrimaryKey(Integer.parseInt(viewId));
    }
}

