/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.service.serviceimpl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tydic.datakbase.base.SysConstant;
import com.tydic.datakbase.mapper.DatakViewShareMapper;
import com.tydic.datakbase.model.DatakViewRecord;
import com.tydic.datakbase.model.DatakViewShare;
import com.tydic.datakbase.model.DatakViewShareExample;
import com.tydic.datakbase.model.DatakViewShareRemove;
import com.tydic.datakbase.model.UserInfo;
import com.tydic.datakbase.pojo.UserList;
import com.tydic.datakbase.service.DatakViewShareService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatakViewShareServiceImpl
implements DatakViewShareService {
    private static final Gson gson = new GsonBuilder().serializeNulls().create();
    @Autowired
    private DatakViewShareMapper datakViewShareMapper;

    @Override
    public int save(DatakViewShare datakViewShare) {
        if (datakViewShare == null) {
            return 0;
        }
        int cnt = this.datakViewShareMapper.insert(datakViewShare);
        if (cnt != 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Map<String, Object> getShareType(String viewIdStr) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{viewIdStr})) {
            result.put("flag", 0);
            result.put("msg", "\u53c2\u6570[viewId]\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        HashMap<String, Object> shareMap = null;
        try {
            shareMap = new HashMap<String, Object>();
            Long viewId = Long.parseLong(viewIdStr);
            DatakViewShareExample datakViewShareExample = new DatakViewShareExample();
            DatakViewShareExample.Criteria criteria = datakViewShareExample.createCriteria();
            criteria.andViewIdEqualTo(viewId);
            List<DatakViewShare> viewShareList = this.datakViewShareMapper.selectByExample(datakViewShareExample);
            if (viewShareList.size() == 0) {
                shareMap.put("shareType", 1);
                shareMap.put("userList", null);
            } else if (viewShareList.size() == 1) {
                String shareUserId = viewShareList.get(0).getShareUserId();
                if ("*".equals(shareUserId)) {
                    shareMap.put("shareType", "2");
                } else {
                    shareMap.put("shareType", "1");
                }
                shareMap.put("userList", null);
            } else {
                shareMap.put("shareType", "3");
                ArrayList<String> userList = new ArrayList<String>();
                for (int i = 0; i < viewShareList.size(); ++i) {
                    if (viewShareList.get(i).getCreateUserId().equals(viewShareList.get(i).getShareUserId())) continue;
                    userList.add(viewShareList.get(i).getShareUserId());
                }
                shareMap.put("userList", userList);
            }
        }
        catch (Exception e) {
            result.put("flag", 0);
            result.put("msg", "\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef\uff01");
            return result;
        }
        result.put("flag", 1);
        result.put("msg", "success");
        result.put("data", shareMap);
        return result;
    }

    @Override
    public int deleteByViewId(DatakViewShare datakViewShare) {
        DatakViewShareExample datakViewShareExample = new DatakViewShareExample();
        DatakViewShareExample.Criteria criteria = datakViewShareExample.createCriteria();
        criteria.andViewIdEqualTo(datakViewShare.getViewId());
        return this.datakViewShareMapper.deleteByExample(datakViewShareExample);
    }

    @Override
    public List<DatakViewShare> selectByViewId(String viewId) {
        return this.datakViewShareMapper.selectByViewId(viewId);
    }

    @Override
    public Map<String, Object> insert(String userId, DatakViewRecord record, String userIdlist, String poupTypeStr) throws Exception {
        HashMap<String, Object> resultMap;
        block9: {
            resultMap = new HashMap<String, Object>();
            if (userId == null || "".equals(userId.trim())) {
                resultMap.put("flag", 0);
                resultMap.put("msg", "\u53c2\u6570[userId]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5206\u4eab\u5931\u8d25");
                resultMap.put("data", null);
                return resultMap;
            }
            if (poupTypeStr == null || "".equals(poupTypeStr.trim())) {
                resultMap.put("flag", 0);
                resultMap.put("msg", "\u53c2\u6570[poupType]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5206\u4eab\u5931\u8d25");
                resultMap.put("data", null);
                return resultMap;
            }
            String rptName = record.getViewName();
            if (!record.getUserId().equals(userId)) {
                resultMap.put("flag", 0);
                resultMap.put("msg", "\u4e0d\u662f\u521b\u5efa\u4eba\u4e0d\u80fd\u5206\u4eab\u62a5\u8868");
                resultMap.put("data", null);
                return resultMap;
            }
            DatakViewShare datakViewShare = new DatakViewShare();
            datakViewShare.setViewId((long)record.getViewId());
            datakViewShare.setCreateUserId(userId);
            int poupType = Integer.parseInt(poupTypeStr);
            try {
                this.deleteByViewId(datakViewShare);
                this.deleteDatakViewShareRemoveByViewId((long)record.getViewId());
                if (poupType == SysConstant.SHARE_TO_ONE) {
                    datakViewShare.setShareUserId(userId);
                    this.datakViewShareMapper.insert(datakViewShare);
                    break block9;
                }
                if (poupType == SysConstant.SHARE_TO_ALL) {
                    datakViewShare.setShareUserId("*");
                    this.datakViewShareMapper.insert(datakViewShare);
                    break block9;
                }
                if (poupType == SysConstant.SHARE_TO_OTHER) {
                    UserList userList = new UserList();
                    userList = (UserList)gson.fromJson(userIdlist, UserList.class);
                    List<UserInfo> tmpUserList = new ArrayList();
                    tmpUserList = userList.getUserIdList();
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(userId);
                    tmpUserList.add(userInfo);
                    for (UserInfo user : tmpUserList) {
                        datakViewShare.setShareUserId(user.getId());
                        this.datakViewShareMapper.insert(datakViewShare);
                    }
                    break block9;
                }
                resultMap.put("flag", 0);
                resultMap.put("msg", "\u53c2\u6570[poupType]\u9519\u8bef\uff0c\u5206\u4eab\u5931\u8d25");
                resultMap.put("data", null);
                return resultMap;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                ex.printStackTrace();
                resultMap.put("flag", 0);
                resultMap.put("msg", "\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef\uff0c\u5206\u4eab\u5931\u8d25");
                resultMap.put("data", null);
                return resultMap;
            }
        }
        resultMap.put("flag", 1);
        resultMap.put("msg", "\u5206\u4eab\u6210\u529f");
        resultMap.put("data", 1);
        return resultMap;
    }

    @Override
    public boolean deleteViewShareByViewIdAndUserId(String viewIdStr, String shareUserIdStr) {
        boolean resultFlag;
        block3: {
            List<DatakViewShare> datakViewShareList;
            block1: {
                String shareUserId;
                DatakViewShare datakViewShare;
                block2: {
                    resultFlag = false;
                    datakViewShareList = this.datakViewShareMapper.selectByViewId(viewIdStr);
                    if (datakViewShareList.size() != 1) break block1;
                    datakViewShare = datakViewShareList.get(0);
                    shareUserId = datakViewShare.getShareUserId();
                    if (!"*".equals(shareUserId)) break block2;
                    DatakViewShareRemove record = new DatakViewShareRemove();
                    record.setCreateUserId(datakViewShare.getCreateUserId());
                    record.setShareUserId(shareUserIdStr);
                    record.setViewId(datakViewShare.getViewId());
                    record.setRemoveTime(new Date());
                    this.datakViewShareMapper.insertDatakViewShareRemoveSelective(record);
                    break block3;
                }
                if (!shareUserIdStr.equals(shareUserId)) break block3;
                this.deleteByViewIdAndShareUserId(datakViewShare);
                break block3;
            }
            for (DatakViewShare datakViewShare : datakViewShareList) {
                String shareUserId = datakViewShare.getShareUserId();
                if (!shareUserIdStr.equals(shareUserId)) continue;
                this.deleteByViewIdAndShareUserId(datakViewShare);
            }
        }
        resultFlag = true;
        return resultFlag;
    }

    public int deleteByViewIdAndShareUserId(DatakViewShare datakViewShare) {
        DatakViewShareExample datakViewShareExample = new DatakViewShareExample();
        DatakViewShareExample.Criteria criteria = datakViewShareExample.createCriteria();
        criteria.andViewIdEqualTo(datakViewShare.getViewId());
        criteria.andShareUserIdEqualTo(datakViewShare.getShareUserId());
        return this.datakViewShareMapper.deleteByExample(datakViewShareExample);
    }

    public int deleteDatakViewShareRemoveByViewId(Long viewId) {
        DatakViewShareRemove datakViewShareRemove = new DatakViewShareRemove();
        datakViewShareRemove.setViewId(viewId);
        return this.datakViewShareMapper.deleteDatakViewShareRemoveByViewId(datakViewShareRemove);
    }
}

