/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.service.serviceimpl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.datakbase.mapper.DatakMaterialClassificationMapper;
import com.tydic.datakbase.mapper.DatakMaterialMapper;
import com.tydic.datakbase.model.DatakMaterial;
import com.tydic.datakbase.model.DatakMaterialClassification;
import com.tydic.datakbase.model.DatakMaterialClassificationExample;
import com.tydic.datakbase.model.DatakMaterialExample;
import com.tydic.datakbase.service.MaterialService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialServiceImpl
implements MaterialService {
    @Autowired
    private DatakMaterialMapper datakMaterialMapper;
    @Autowired
    private DatakMaterialClassificationMapper datakMaterialClassificationMapper;

    @Override
    public PageInfo<DatakMaterialClassification> getDatakMaterialClassificationList(String operId, int pageNum, int pageSize) {
        DatakMaterialClassificationExample datakMaterialClassificationExample = new DatakMaterialClassificationExample();
        DatakMaterialClassificationExample.Criteria criteria = datakMaterialClassificationExample.createCriteria();
        DatakMaterialClassificationExample.Criteria criteria2 = datakMaterialClassificationExample.createCriteria();
        criteria.andUserIdEqualTo(operId);
        criteria.andStateEqualTo(1);
        datakMaterialClassificationExample.setOrderByClause("create_time desc");
        criteria2.andUserIdEqualTo("");
        criteria2.andStateEqualTo(1);
        datakMaterialClassificationExample.or(criteria2);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<DatakMaterialClassification> list = this.datakMaterialClassificationMapper.selectByExample(datakMaterialClassificationExample);
        return new PageInfo(list);
    }

    @Override
    public int delDatakMaterialClassification(int classificationId, int newClassificationId, String operId) {
        DatakMaterialClassification datakMaterialClassification = this.datakMaterialClassificationMapper.selectByPrimaryKey(classificationId);
        if (operId.equals(datakMaterialClassification.getUserId())) {
            DatakMaterial datakMaterial = new DatakMaterial();
            if (newClassificationId == 0) {
                datakMaterial.setState(0);
            } else {
                DatakMaterialClassification newDatakMaterialClassification = this.datakMaterialClassificationMapper.selectByPrimaryKey(newClassificationId);
                if (StringUtils.isBlank((CharSequence)newDatakMaterialClassification.getUserId()) || operId.equals(newDatakMaterialClassification.getUserId())) {
                    datakMaterial.setClassificationId(newClassificationId);
                } else {
                    datakMaterial.setState(0);
                }
            }
            DatakMaterialExample datakMaterialExample = new DatakMaterialExample();
            DatakMaterialExample.Criteria criteria = datakMaterialExample.createCriteria();
            criteria.andClassificationIdEqualTo(classificationId);
            this.datakMaterialMapper.updateByExampleSelective(datakMaterial, datakMaterialExample);
            datakMaterialClassification.setState(0);
            return this.datakMaterialClassificationMapper.updateByPrimaryKey(datakMaterialClassification);
        }
        return 0;
    }

    @Override
    public int saveDatakMaterialClassification(DatakMaterialClassification materialClassification) {
        materialClassification.setState(1);
        materialClassification.setUpdateTime(new Date());
        if (materialClassification.getClassificationId() == null) {
            materialClassification.setCreateTime(new Date());
            return this.datakMaterialClassificationMapper.insertSelective(materialClassification);
        }
        return this.datakMaterialClassificationMapper.updateByPrimaryKeySelective(materialClassification);
    }

    @Override
    public PageInfo<DatakMaterial> getDatakMaterial(String operId, int classificationId, int pageNum, int pageSize) {
        DatakMaterialExample datakMaterialExample = new DatakMaterialExample();
        DatakMaterialExample.Criteria criteria = datakMaterialExample.createCriteria();
        criteria.andUserIdEqualTo(operId);
        criteria.andStateEqualTo(1);
        criteria.andClassificationIdEqualTo(classificationId);
        datakMaterialExample.setOrderByClause("create_time desc");
        DatakMaterialExample.Criteria criteria2 = datakMaterialExample.createCriteria();
        criteria2.andUserIdEqualTo("");
        criteria2.andClassificationIdIsNull();
        datakMaterialExample.or(criteria2);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<DatakMaterial> list = this.datakMaterialMapper.selectByExample(datakMaterialExample);
        return new PageInfo(list);
    }

    @Override
    public int delDatakMaterial(int materialId, String operId) {
        DatakMaterial datakMaterial = this.datakMaterialMapper.selectByPrimaryKey(materialId);
        if (operId.equals(datakMaterial.getUserId())) {
            datakMaterial.setState(0);
            return this.datakMaterialMapper.updateByPrimaryKeySelective(datakMaterial);
        }
        return 0;
    }

    @Override
    public int saveDatakMaterial(DatakMaterial datakMaterial) {
        datakMaterial.setUpdateTime(new Date());
        datakMaterial.setState(1);
        if (datakMaterial.getMaterialId() == null) {
            datakMaterial.setCreateTime(new Date());
            return this.datakMaterialMapper.insertSelective(datakMaterial);
        }
        return this.datakMaterialMapper.updateByPrimaryKeySelective(datakMaterial);
    }
}

