/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialPO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="redisSerialService")
public class CfcRedisSerialServiceImpl
implements CfcRedisSerialService {
    private static final Logger log = LoggerFactory.getLogger(CfcRedisSerialServiceImpl.class);
    public static final String PREFIX = "PKESS";
    public static final String CONNECTOR_UNDERLINE = "_";
    @Value(value="${encodedSerial.redis.enable:true}")
    private Boolean encodedSerialRedisEnable;
    @Value(value="${encodedSerial.updateNum:1000}")
    private Integer encodedSerialUpdateNum;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;
    @Autowired
    private CfcEncodedSerialGenerateMapper cfcEncodedSerialGenerateMapper;
    @Autowired
    private CfcEncodedSerialMapper cfcEncodedSerialMapper;

    @Override
    public CfcEncodedSerialGetServiceRspBO getSerial(CfcEncodedSerialGetServiceReqBO reqBO) {
        Object encodedSerial;
        if (reqBO == null) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCenter())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleCode())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrgType())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u673a\u6784\u7c7b\u578b\u4e3a\u7a7a");
        }
        CfcEncodedSerialGetServiceRspBO rspBO = new CfcEncodedSerialGetServiceRspBO();
        CfcEncodedSerialPO cfcEncodedSerialPO = null;
        String encodedSerialKey = null;
        String encodedSerialGenerateKey = null;
        String encodedSerialGenerateUpdateKey = null;
        Integer generateValue = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String effDate = df.format(LocalDateTime.now());
        if (this.encodedSerialRedisEnable.booleanValue() && (encodedSerial = this.cacheClient.get(encodedSerialKey = "PKESS_" + reqBO.getCenter() + CONNECTOR_UNDERLINE + reqBO.getEncodedRuleCode() + CONNECTOR_UNDERLINE + reqBO.getOrgType())) != null && (cfcEncodedSerialPO = (CfcEncodedSerialPO)JSON.parseObject((String)((String)encodedSerial), CfcEncodedSerialPO.class)) != null && StringUtils.isNotBlank((CharSequence)cfcEncodedSerialPO.getEncodedSerialPrefix()) && effDate.equals(cfcEncodedSerialPO.getEffDate())) {
            encodedSerialGenerateKey = encodedSerialKey + CONNECTOR_UNDERLINE + cfcEncodedSerialPO.getEncodedSerialPrefix();
            generateValue = (Integer)this.cacheClient.get(encodedSerialGenerateKey);
            encodedSerialGenerateUpdateKey = encodedSerialKey + CONNECTOR_UNDERLINE + "UPDATE" + CONNECTOR_UNDERLINE + cfcEncodedSerialPO.getEncodedSerialPrefix();
        }
        if (cfcEncodedSerialPO != null && generateValue != null) {
            CfcEncodedSerialServiceRspBO cfcEncodedSerialServiceRspBO = this.cfcEncodedSerialGetService.getSerial(reqBO);
            cfcEncodedSerialPO = cfcEncodedSerialServiceRspBO.getCfcEncodedSerialPO();
            generateValue = cfcEncodedSerialServiceRspBO.getCfcEncodedSerialGeneratePO().getGenerateValue();
            if (this.encodedSerialRedisEnable.booleanValue()) {
                encodedSerialKey = "PKESS_" + cfcEncodedSerialPO.getCenter() + CONNECTOR_UNDERLINE + cfcEncodedSerialPO.getEncodedRuleCode() + CONNECTOR_UNDERLINE + cfcEncodedSerialPO.getOrgType();
                this.cacheClient.set(encodedSerialKey, (Object)JSON.toJSONString((Object)cfcEncodedSerialPO));
                encodedSerialGenerateKey = encodedSerialKey + CONNECTOR_UNDERLINE + cfcEncodedSerialPO.getEncodedSerialPrefix();
                this.cacheClient.set(encodedSerialGenerateKey, (Object)generateValue);
                encodedSerialGenerateUpdateKey = encodedSerialKey + CONNECTOR_UNDERLINE + "UPDATE" + CONNECTOR_UNDERLINE + cfcEncodedSerialPO.getEncodedSerialPrefix();
                this.cacheClient.set(encodedSerialGenerateUpdateKey, (Object)generateValue);
            }
            rspBO.setSerialNoList(cfcEncodedSerialServiceRspBO.getSerialNoList());
            return rspBO;
        }
        if (null == cfcEncodedSerialPO) {
            cfcEncodedSerialPO = this.getEncodedSerial(reqBO);
        }
        if (null == encodedSerialGenerateKey) {
            encodedSerialGenerateKey = encodedSerialKey + CONNECTOR_UNDERLINE + cfcEncodedSerialPO.getEncodedSerialPrefix();
        }
        Integer num = 1;
        if (reqBO.getNum() != null && reqBO.getNum() > 0) {
            num = reqBO.getNum();
        }
        Long newNum = this.cacheClient.incrBy(encodedSerialGenerateKey, (long)num.intValue());
        Integer lastUpdateNum = (Integer)this.cacheClient.get(encodedSerialGenerateUpdateKey);
        if (newNum - (long)lastUpdateNum.intValue() > (long)this.encodedSerialUpdateNum.intValue()) {
            CfcEncodedSerialGeneratePO selectCfcEncodedSerialGeneratePO = new CfcEncodedSerialGeneratePO();
            selectCfcEncodedSerialGeneratePO.setSerialId(cfcEncodedSerialPO.getId());
            selectCfcEncodedSerialGeneratePO.setGeneratePrefix(cfcEncodedSerialPO.getEncodedSerialPrefix());
            List<CfcEncodedSerialGeneratePO> encodedSerialGenerateResult = this.cfcEncodedSerialGenerateMapper.getList(selectCfcEncodedSerialGeneratePO);
            if (encodedSerialGenerateResult != null && encodedSerialGenerateResult.size() > 0) {
                int updateFlag = this.cfcEncodedSerialGenerateMapper.updateGenerateValue(encodedSerialGenerateResult.get(0).getId(), num);
                if (updateFlag < 1) {
                    throw new CfcEncodedPluginBusinessException("8888", "\u5c1d\u8bd5\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
                }
                this.cacheClient.set(encodedSerialGenerateUpdateKey, (Object)generateValue);
            } else {
                throw new CfcEncodedPluginBusinessException("8888", "\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728");
            }
        }
        ArrayList<String> serialNoList = new ArrayList<String>();
        for (int i = num - 1; i >= 0; --i) {
            String generatePrefix = cfcEncodedSerialPO.getEncodedSerialPrefix();
            if (reqBO.getReplaceJson() != null) {
                for (Map.Entry itemJson : reqBO.getReplaceJson().entrySet()) {
                    String itemJsonKey = "\\$\\{" + (String)itemJson.getKey() + "\\}";
                    generatePrefix = generatePrefix.replaceAll(itemJsonKey, itemJson.getValue().toString());
                }
            }
            String serialNo = generatePrefix + String.format("%0" + cfcEncodedSerialPO.getEncodedSerialDigit() + "d", newNum - (long)i);
            serialNoList.add(serialNo);
        }
        rspBO.setSerialNoList(serialNoList);
        return rspBO;
    }

    private CfcEncodedSerialPO getEncodedSerial(CfcEncodedSerialGetServiceReqBO reqBO) {
        CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
        esParam.setCenter(reqBO.getCenter());
        esParam.setEncodedRuleCode(reqBO.getEncodedRuleCode());
        esParam.setEffFlag("1");
        List<CfcEncodedSerialPO> cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
        ArrayList<CfcEncodedSerialPO> validList = new ArrayList<CfcEncodedSerialPO>(cfcEncodedSerialPOS.size());
        if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
            for (CfcEncodedSerialPO itemPO : cfcEncodedSerialPOS) {
                String effDate = this.composeEffDate(itemPO);
                if (StringUtils.isEmpty((CharSequence)effDate) || !"none".equals(effDate) && !effDate.equals(itemPO.getEffDate())) continue;
                validList.add(itemPO);
            }
        }
        CfcEncodedSerialPO cfcEncodedSerialPO = null;
        int extendLength = -1;
        for (CfcEncodedSerialPO itemPO : validList) {
            if (StringUtils.isBlank((CharSequence)reqBO.getRelId())) {
                if (!StringUtils.isBlank((CharSequence)itemPO.getRelId())) continue;
                cfcEncodedSerialPO = itemPO;
                break;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRelType())) {
                reqBO.setRelType("org");
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getRelId())) {
                if (cfcEncodedSerialPO != null) continue;
                cfcEncodedSerialPO = itemPO;
                continue;
            }
            if ("1".equals(reqBO.getExtendFlag())) {
                if (!reqBO.getRelId().contains(itemPO.getRelId()) || !reqBO.getRelType().equals(itemPO.getRelType())) continue;
                String[] ids = reqBO.getRelId().split("-");
                for (int i = 0; i < ids.length; ++i) {
                    if (!ids[i].equals(itemPO.getRelId()) || i <= extendLength) continue;
                    extendLength = i;
                    cfcEncodedSerialPO = itemPO;
                }
                continue;
            }
            if (!reqBO.getRelId().equals(itemPO.getRelId()) || !reqBO.getRelType().equals(itemPO.getRelType())) continue;
            cfcEncodedSerialPO = itemPO;
            break;
        }
        return cfcEncodedSerialPO;
    }

    private String composeEffDate(CfcEncodedSerialPO cfcEncodedSerialPO) {
        if ("none".equals(cfcEncodedSerialPO.getEffType())) {
            return "none";
        }
        if ("date".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("mouth".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        return null;
    }
}

