/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialGeneratePO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.bo.CfcEncodedRedisSerialSyncReqBo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class CfcEncodedRedisSerialServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedRedisSerialServiceConsumer.class);
    @Value(value="${ENCODED_CENTER}")
    private String encodedCenter;
    @Autowired
    private CfcEncodedSerialGenerateMapper cfcEncodedSerialGenerateMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            CfcEncodedRedisSerialSyncReqBo redisSerialSyncReqBo = (CfcEncodedRedisSerialSyncReqBo)JSONObject.parseObject((String)message.getContent(), CfcEncodedRedisSerialSyncReqBo.class);
            CfcEncodedSerialGeneratePO selectCfcEncodedSerialGeneratePO = new CfcEncodedSerialGeneratePO();
            selectCfcEncodedSerialGeneratePO.setSerialId(redisSerialSyncReqBo.getSerialId());
            selectCfcEncodedSerialGeneratePO.setGeneratePrefix(redisSerialSyncReqBo.getGeneratePrefix());
            if (this.encodedCenter.equals(redisSerialSyncReqBo.getCenter())) {
                List<CfcEncodedSerialGeneratePO> encodedSerialGenerateResult = this.cfcEncodedSerialGenerateMapper.getList(selectCfcEncodedSerialGeneratePO);
                if (encodedSerialGenerateResult != null && encodedSerialGenerateResult.size() > 0) {
                    int updateFlag = this.cfcEncodedSerialGenerateMapper.updateGenerateValue(encodedSerialGenerateResult.get(0).getId(), Math.toIntExact(redisSerialSyncReqBo.getSerialNumberDifference()));
                    if (updateFlag < 1) {
                        throw new CfcEncodedPluginBusinessException("8888", "\u5c1d\u8bd5\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
                    }
                } else {
                    selectCfcEncodedSerialGeneratePO.setId(Sequence.getInstance().nextId());
                    selectCfcEncodedSerialGeneratePO.setGenerateValue(Math.toIntExact(redisSerialSyncReqBo.getGenerateValue()));
                    this.cfcEncodedSerialGenerateMapper.insert(selectCfcEncodedSerialGeneratePO);
                }
            }
        }
        catch (Exception e) {
            log.error("Redis\u83b7\u53d6\u7f16\u7801\u66f4\u65b0\u6d41\u6c34\u53f7\u6d88\u606f\u961f\u5217\u6d88\u8d39\u8005\u5f02\u5e38\uff1a", (Throwable)e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

