/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.contract.ability.bo.ContractQryAuditLogBO;
import com.tydic.contract.atom.ContractQryAuditLogAtomService;
import com.tydic.contract.atom.bo.ContractQryAuditLogAtomReqBO;
import com.tydic.contract.atom.bo.ContractQryAuditLogAtomRspBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractQryAuditLogAtomServiceImpl
implements ContractQryAuditLogAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryAuditLogAtomServiceImpl.class);
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;

    @Override
    public ContractQryAuditLogAtomRspBO qryAuditLog(ContractQryAuditLogAtomReqBO reqBO) {
        ContractQryAuditLogAtomRspBO contractQryAuditLogAtomRspBO = new ContractQryAuditLogAtomRspBO();
        ArrayList<ContractQryAuditLogBO> auditLogBOS = new ArrayList<ContractQryAuditLogBO>();
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(reqBO.getPageNo());
        uacQryAuditLogReqBO.setPageSize(reqBO.getPageSize());
        uacQryAuditLogReqBO.setObjId(reqBO.getObjId());
        uacQryAuditLogReqBO.setObjType(reqBO.getObjType());
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if ("0000".equals(uacQryAuditLogRspBO.getRespCode())) {
            contractQryAuditLogAtomRspBO.setPageNo(uacQryAuditLogRspBO.getPageNo());
            contractQryAuditLogAtomRspBO.setRecordsTotal(uacQryAuditLogRspBO.getTotalRecords());
            List logPOS = uacQryAuditLogRspBO.getRows();
            for (int i = 0; i < logPOS.size(); ++i) {
                ApprovalLogBO approvalLogBO = (ApprovalLogBO)logPOS.get(i);
                if (approvalLogBO.getAuditResult() == null) {
                    approvalLogBO.setAudit("\u63d0\u4ea4");
                    approvalLogBO.setAuditAdvice("");
                } else {
                    approvalLogBO.setAudit(String.valueOf(approvalLogBO.getAuditResult()).equals("1") ? "\u901a\u8fc7" : "\u9a73\u56de");
                }
                if (i < logPOS.size() - 1) {
                    Date date = ((ApprovalLogBO)logPOS.get(i + 1)).getDealTime();
                    long time = approvalLogBO.getDealTime().getTime() - date.getTime();
                    long hours = time / 3600000L;
                    long lestMinutes = time % 3600000L;
                    long minutes = lestMinutes / 60000L;
                    long lestS = lestMinutes % 60000L;
                    long s = lestS / 1000L;
                    String str = "";
                    if (hours > 0L) {
                        str = hours + "\u5c0f\u65f6";
                    }
                    if (minutes > 0L) {
                        str = str + minutes + "\u5206";
                    } else if (StringUtils.isNotBlank((String)str)) {
                        str = str + "0\u5206";
                    }
                    if (s > 0L) {
                        str = str + s + "\u79d2";
                    } else if (StringUtils.isNotBlank((String)str)) {
                        str = str + "0\u79d2";
                    }
                    approvalLogBO.setProcessTimeStr(str);
                    approvalLogBO.setProcessTime(Long.valueOf(time));
                }
                ContractQryAuditLogBO contractQryAuditLogBO = new ContractQryAuditLogBO();
                BeanUtils.copyProperties((Object)approvalLogBO, (Object)contractQryAuditLogBO);
                contractQryAuditLogBO.setOperId(approvalLogBO.getOperid());
                auditLogBOS.add(0, contractQryAuditLogBO);
            }
            if (logPOS.size() > 0) {
                String nextStationId = ((ApprovalLogBO)logPOS.get(0)).getNextStationId();
                log.info("\u67e5\u8be2nextStation\u6570\u636e:" + nextStationId);
                log.info("\u67e5\u8be2orgId\u6570\u636e\uff1a" + reqBO.getOrgId());
                if (!StringUtils.isBlank((String)nextStationId)) {
                    DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                    dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(Long.parseLong(nextStationId)));
                    dycStationOrgSelectUserNameReqBO.setOrgIdWeb(reqBO.getOrgId());
                    DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                    if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                        for (UserBO itemBO : dycStationOrgSelectUserNameRspBO.getUserList()) {
                            ContractQryAuditLogBO contractQryAuditLogBO = new ContractQryAuditLogBO();
                            contractQryAuditLogBO.setOperName(itemBO.getName());
                            contractQryAuditLogBO.setOperDept(itemBO.getCompanyFullName());
                            auditLogBOS.add(contractQryAuditLogBO);
                        }
                    }
                }
            }
        }
        contractQryAuditLogAtomRspBO.setRows(auditLogBOS);
        contractQryAuditLogAtomRspBO.setRespCode(uacQryAuditLogRspBO.getRespCode());
        contractQryAuditLogAtomRspBO.setRespDesc(uacQryAuditLogRspBO.getRespDesc());
        return contractQryAuditLogAtomRspBO;
    }
}

