/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractChoiceOrderBO;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.busi.ContractAddBusiService;
import com.tydic.contract.busi.bo.ContractAddBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractLadderRateMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractSaleCategoryRateMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractLadderRatePo;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.po.ContractPayTypePo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractSaleCategoryRatePo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractAddBusiServiceImpl
implements ContractAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddBusiServiceImpl.class);
    public static final String FIELD_CONTRACT_ID = "contractId";
    public static final String FIELD_CONTRACT_CODE = "contractCode";
    private final ContractMapper contractMapper;
    private final ContractOrderMapper contractOrderMapper;
    private final ContractAccessoryMapper contractAccessoryMapper;
    private final ContractPayTypeMapper contractPayTypeMapper;
    private final ContractItemMapper contractItemMapper;
    private final ContractSaleCategoryRateMapper contractSaleCategoryRateMapper;
    private final ContractLadderRateMapper contractLadderRateMapper;
    private final ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;

    public ContractAddBusiServiceImpl(ContractMapper contractMapper, ContractOrderMapper contractOrderMapper, ContractAccessoryMapper contractAccessoryMapper, ContractPayTypeMapper contractPayTypeMapper, ContractItemMapper contractItemMapper, ContractSaleCategoryRateMapper contractSaleCategoryRateMapper, ContractLadderRateMapper contractLadderRateMapper, ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService) {
        this.contractMapper = contractMapper;
        this.contractOrderMapper = contractOrderMapper;
        this.contractAccessoryMapper = contractAccessoryMapper;
        this.contractPayTypeMapper = contractPayTypeMapper;
        this.contractItemMapper = contractItemMapper;
        this.contractSaleCategoryRateMapper = contractSaleCategoryRateMapper;
        this.contractLadderRateMapper = contractLadderRateMapper;
        this.contractRecordContractNodeOperLogAtomService = contractRecordContractNodeOperLogAtomService;
    }

    @Override
    public ContractAddBusiRspBO addContract(ContractAddBusiReqBO reqBO) {
        ContractAddBusiRspBO rspBO = new ContractAddBusiRspBO();
        if ("0".equals(reqBO.getOperType()) || "3".equals(reqBO.getOperType())) {
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                Map<String, Object> resultMap = this.addOrderContract(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u8ba2\u5355\u5408\u540c\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            if (ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType()) || ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                Map<String, Object> resultMap = this.addAgreeContract(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u534f\u8bae\u5408\u540c\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            if (ContractConstant.ContractType.ENTER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                Map<String, Object> resultMap = this.addEnterContract(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u5165\u9a7b\u5408\u540c\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
            return rspBO;
        }
        if ("1".equals(reqBO.getOperType())) {
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveOrderContract(reqBO);
                rspBO.setContractId(reqBO.getContractId());
                rspBO.setContractCode(reqBO.getContractCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u8ba2\u5355\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType()) || ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveAgreeContract(reqBO);
                rspBO.setContractId(reqBO.getContractId());
                rspBO.setContractCode(reqBO.getContractCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u534f\u8bae\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.ENTER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveEnterContract(reqBO);
                rspBO.setContractId(reqBO.getContractId());
                rspBO.setContractCode(reqBO.getContractCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u5165\u9a7b\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
            return rspBO;
        }
        if ("2".equals(reqBO.getOperType())) {
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveOrderContract(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u63d0\u4ea4\u8ba2\u5355\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType()) || ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveAgreeContract(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u63d0\u4ea4\u534f\u8bae\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.ENTER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveEnterContract(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u63d0\u4ea4\u5165\u9a7b\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
            return rspBO;
        }
        rspBO.setRespCode("1007");
        rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        return rspBO;
    }

    private void saveEnterContract(ContractAddBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
        this.saveSaleCategoryRateInfo(reqBO);
        this.saveLadderRateInfo(reqBO);
    }

    private void saveAgreeContract(ContractAddBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.updateContractItemInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
    }

    private void saveOrderContract(ContractAddBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.updateContractPayTypeInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
    }

    private Map<String, Object> addAgreeContract(ContractAddBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        this.recordContractNodeOperLog((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO.getUserId(), reqBO.getUserName());
        return addContractResultMap;
    }

    private Map<String, Object> addEnterContract(ContractAddBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCategoryRateList())) {
            this.addSaleCategoryRateInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getYearEndRateList())) {
            this.addLadderRateInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        this.recordContractNodeOperLog((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO.getUserId(), reqBO.getUserName());
        return addContractResultMap;
    }

    private Map<String, Object> addOrderContract(ContractAddBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        this.addContractOrderInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayTypes())) {
            this.addContractPayTypeInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        this.recordContractNodeOperLog((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO.getUserId(), reqBO.getUserName());
        return addContractResultMap;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode("CREATE_CONTRACT");
        contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u5408\u540c\u521b\u5efa");
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }

    private void updateContractAccessoryInfo(ContractAddBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getContractId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getContractCode());
        deleteContractAccessoryPo.setAcceessoryType(ContractConstant.AccessoryType.ACCESSORY_TYPE);
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo(reqBO.getContractId(), reqBO);
        }
    }

    private void addContractAccessoryInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getAcceessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(contractId);
            contractAccessoryPo.setRelateCode(reqBO.getContractCode());
            contractAccessoryPo.setCreateUserId(reqBO.getUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getUserName());
            contractAccessoryPo.setAcceessoryType(ContractConstant.AccessoryType.ACCESSORY_TYPE);
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractPayTypeInfo(ContractAddBusiReqBO reqBO) {
        ContractPayTypePo deleteContractPayTypePo = new ContractPayTypePo();
        deleteContractPayTypePo.setRelateId(reqBO.getContractId());
        deleteContractPayTypePo.setRelateCode(reqBO.getContractCode());
        this.contractPayTypeMapper.deleteByCondition(deleteContractPayTypePo);
        if (!CollectionUtils.isEmpty(reqBO.getPayTypes())) {
            this.addContractPayTypeInfo(reqBO.getContractId(), reqBO);
        }
    }

    private void addContractPayTypeInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        ArrayList<ContractPayTypePo> list = new ArrayList<ContractPayTypePo>();
        for (Integer payType : reqBO.getPayTypes()) {
            ContractPayTypePo insertContractPayTypePo = new ContractPayTypePo();
            insertContractPayTypePo.setPayTypeId(Sequence.getInstance().nextId());
            insertContractPayTypePo.setRelateCode(reqBO.getContractCode());
            insertContractPayTypePo.setRelateId(contractId);
            insertContractPayTypePo.setRelationType(ContractConstant.ContractPayTypeRelationType.RELATION_TYPE_CONTRACT);
            insertContractPayTypePo.setPayType(payType);
            insertContractPayTypePo.setPayTypeStr(ContractTransFieldUtil.transOrderContractPayType(payType));
            list.add(insertContractPayTypePo);
        }
        int result = this.contractPayTypeMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u652f\u4ed8\u65b9\u5f0f\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractItemInfo(ContractAddBusiReqBO reqBO) {
        ContractItemPo deleteContractItemPo = new ContractItemPo();
        deleteContractItemPo.setRelateId(reqBO.getContractId());
        deleteContractItemPo.setRelateCode(reqBO.getContractCode());
        this.contractItemMapper.deleteByCondition(deleteContractItemPo);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo(reqBO.getContractId(), reqBO);
        }
    }

    private void addContractItemInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getItemList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractItemPo.class);
        for (ContractItemPo contractItemPo : list) {
            if (!ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                if (contractItemPo.getUnitPrice() != null) {
                    contractItemPo.setUnitPrice(contractItemPo.getUnitPrice() * 10000L);
                    log.info("unitPrice\uff1a" + contractItemPo.getUnitPrice());
                }
                if (contractItemPo.getTotalAmount() != null) {
                    contractItemPo.setTotalAmount(contractItemPo.getTotalAmount() * 10000L);
                    log.info("totalAmount\uff1a" + contractItemPo.getTotalAmount());
                }
            }
            contractItemPo.setItemId(Sequence.getInstance().nextId());
            contractItemPo.setRelateId(contractId);
            contractItemPo.setRelateCode(contractItemPo.getOrderCode());
            contractItemPo.setCreateUserId(reqBO.getUserId());
            contractItemPo.setCreateUserName(reqBO.getUserName());
            contractItemPo.setUpdateUserId(reqBO.getUserId());
            contractItemPo.setUpdateUserName(reqBO.getUserName());
            contractItemPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractItemPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractItemPo.setNeedArriveTime(DateTimeUtils.Date2String(contractItemPo.getNeedArriveTime()));
            int result = this.contractItemMapper.insertSelective(contractItemPo);
            if (result >= 1) continue;
            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractOrderInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getContractChoiceOrderBOList())) {
            ArrayList<ContractOrderPo> contractOrderPoList = new ArrayList<ContractOrderPo>();
            for (ContractChoiceOrderBO contractChoiceOrderBO : reqBO.getContractChoiceOrderBOList()) {
                ContractOrderPo insertContractOrderPo = new ContractOrderPo();
                insertContractOrderPo.setId(Sequence.getInstance().nextId());
                insertContractOrderPo.setRelateId(contractId);
                insertContractOrderPo.setRelateCode(reqBO.getContractCode());
                insertContractOrderPo.setOrderId(contractChoiceOrderBO.getOrderId());
                insertContractOrderPo.setOrderCode(contractChoiceOrderBO.getOrderCode());
                insertContractOrderPo.setOrderSource(contractChoiceOrderBO.getOrderSource());
                insertContractOrderPo.setOrderModel("1");
                contractOrderPoList.add(insertContractOrderPo);
            }
            int result = this.contractOrderMapper.insertBatch(contractOrderPoList);
            if (result < 1) {
                throw new ZTBusinessException("\u5408\u540c\u8ba2\u5355\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private void saveContractInfo(ContractAddBusiReqBO reqBO) {
        ContractPo oldContractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (oldContractPo != null) {
            ContractPo updateContractPo = new ContractPo();
            BeanUtils.copyProperties((Object)oldContractPo, (Object)updateContractPo);
            BeanUtils.copyProperties((Object)reqBO, (Object)updateContractPo);
            updateContractPo.setUpdateUserId(reqBO.getUserId());
            updateContractPo.setUpdateUserName(reqBO.getUserName());
            updateContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            updateContractPo.setCustomerConfirm(reqBO.getCustomerConfirm());
            if ("2".equals(reqBO.getOperType())) {
                if (ContractConstant.CustomerConfirm.NO_NEED.equals(reqBO.getCustomerConfirm())) {
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
                } else {
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
                }
            } else {
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
            }
            int updateResult = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
            if (updateResult != 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u539f\u5408\u540c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private Map<String, Object> addContractInfo(ContractAddBusiReqBO reqBO) {
        int addContractResult;
        ContractPo insertContractPo = new ContractPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)insertContractPo);
        insertContractPo.setContractId(Sequence.getInstance().nextId());
        insertContractPo.setCreateUserId(reqBO.getUserId());
        insertContractPo.setCreateUserName(reqBO.getUserName());
        insertContractPo.setUpdateUserId(reqBO.getUserId());
        insertContractPo.setUpdateUserName(reqBO.getUserName());
        insertContractPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setNeedArriveTime(reqBO.getNeedArriveTime());
        insertContractPo.setCustomerConfirm(reqBO.getCustomerConfirm());
        insertContractPo.setChargePlatformEntyFee(reqBO.getChargePlatformEntyFee());
        insertContractPo.setPlatformEntyFee(reqBO.getPlatformEntyFee());
        insertContractPo.setPlatformEntyRule(reqBO.getPlatformEntyRule());
        insertContractPo.setContractVersion(1);
        if ("3".equals(reqBO.getOperType())) {
            if (ContractConstant.CustomerConfirm.NO_NEED.equals(reqBO.getCustomerConfirm())) {
                insertContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
            }
        } else {
            insertContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
        }
        insertContractPo.setSignContractId(reqBO.getSignContractId());
        if (insertContractPo.getSignContractId() != null) {
            log.info("\u5165\u9a7b\u5408\u540c\u65b0\u589e-signContractId\uff1a" + insertContractPo.getSignContractId());
        }
        if (1 == (addContractResult = this.contractMapper.insertSelective(insertContractPo))) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(FIELD_CONTRACT_ID, insertContractPo.getContractId());
            resultMap.put(FIELD_CONTRACT_CODE, insertContractPo.getContractCode());
            return resultMap;
        }
        throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\u5931\u8d25");
    }

    private void addSaleCategoryRateInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        String saleCategoryRateJsonStr = JSON.toJSONString(reqBO.getCategoryRateList());
        List addSaleCategoryRateInfos = JSONArray.parseArray((String)saleCategoryRateJsonStr).toJavaList(ContractSaleCategoryRatePo.class);
        for (ContractSaleCategoryRatePo contractSaleCategoryRatePo : addSaleCategoryRateInfos) {
            contractSaleCategoryRatePo.setId(Sequence.getInstance().nextId());
            contractSaleCategoryRatePo.setRelateCode(reqBO.getContractCode());
            contractSaleCategoryRatePo.setRelateId(contractId);
            contractSaleCategoryRatePo.setCreateUserId(reqBO.getUserId());
            contractSaleCategoryRatePo.setCreateUserName(reqBO.getUserName());
            contractSaleCategoryRatePo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        this.contractSaleCategoryRateMapper.insertBatch(addSaleCategoryRateInfos);
    }

    private void saveSaleCategoryRateInfo(ContractAddBusiReqBO reqBO) {
        ContractSaleCategoryRatePo deleteContractSaleCategoryRatePo = new ContractSaleCategoryRatePo();
        deleteContractSaleCategoryRatePo.setRelateCode(reqBO.getContractCode());
        deleteContractSaleCategoryRatePo.setRelateId(reqBO.getContractId());
        this.contractSaleCategoryRateMapper.deleteByCondition(deleteContractSaleCategoryRatePo);
        if (!CollectionUtils.isEmpty(reqBO.getCategoryRateList())) {
            this.addSaleCategoryRateInfo(reqBO.getContractId(), reqBO);
        }
    }

    private void addLadderRateInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        String saleCategoryRateJsonStr = JSON.toJSONString(reqBO.getYearEndRateList());
        List addLadderRateInfos = JSONArray.parseArray((String)saleCategoryRateJsonStr).toJavaList(ContractLadderRatePo.class);
        for (ContractLadderRatePo contractLadderRatePo : addLadderRateInfos) {
            contractLadderRatePo.setId(Sequence.getInstance().nextId());
            contractLadderRatePo.setRelateId(contractId);
            contractLadderRatePo.setRelateCode(reqBO.getContractCode());
            contractLadderRatePo.setCreateUserId(reqBO.getUserId());
            contractLadderRatePo.setCreateUserName(reqBO.getUserName());
            contractLadderRatePo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        this.contractLadderRateMapper.insertBatch(addLadderRateInfos);
    }

    private void saveLadderRateInfo(ContractAddBusiReqBO reqBO) {
        ContractLadderRatePo deleteContractLadderRatePo = new ContractLadderRatePo();
        deleteContractLadderRatePo.setRelateCode(reqBO.getContractCode());
        deleteContractLadderRatePo.setRelateId(reqBO.getContractId());
        this.contractLadderRateMapper.deleteByCondition(deleteContractLadderRatePo);
        if (!CollectionUtils.isEmpty(reqBO.getYearEndRateList())) {
            this.addLadderRateInfo(reqBO.getContractId(), reqBO);
        }
    }
}

