/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.ContractStartApprovalProcessAtomService;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomRspBO;
import com.tydic.contract.busi.ContractApplyAddBusiService;
import com.tydic.contract.busi.bo.ContractApplyAddBusiReqBO;
import com.tydic.contract.busi.bo.ContractApplyAddBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractLadderRateMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractSaleCategoryRateMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractLadderRatePo;
import com.tydic.contract.po.ContractModifyApplyPo;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.po.ContractPayTypePo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractSaleCategoryRatePo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractApplyAddBusiServiceImpl
implements ContractApplyAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractApplyAddBusiServiceImpl.class);
    public static final String PROCESS = "contract_modify_create";
    private static final String FIELD_UPDATE_APPLY_ID = "updateApplyId";
    private static final String FIELD_UPDATE_APPLY_CODE = "updateApplyCode";
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private ContractSaleCategoryRateMapper contractSaleCategoryRateMapper;
    @Autowired
    private ContractLadderRateMapper contractLadderRateMapper;
    @Autowired
    private ContractStartApprovalProcessAtomService contractStartApprovalProcessAtomService;

    @Override
    public ContractApplyAddBusiRspBO addApplyContract(ContractApplyAddBusiReqBO reqBO) {
        ContractApplyAddBusiRspBO rspBO = new ContractApplyAddBusiRspBO();
        if ("0".equals(reqBO.getOperType())) {
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                Map<String, Object> resultMap = this.addOrderContractApply(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u8ba2\u5355\u5408\u540c\u53d8\u66f4\u6210\u529f");
                rspBO.setUpdateApplyId((Long)resultMap.get(FIELD_UPDATE_APPLY_ID));
                rspBO.setUpdateApplyCode((String)resultMap.get(FIELD_UPDATE_APPLY_CODE));
                return rspBO;
            }
            if (ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType()) || ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                Map<String, Object> resultMap = this.addAgreeContractApply(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u534f\u8bae\u5408\u540c\u53d8\u66f4\u6210\u529f");
                rspBO.setUpdateApplyId((Long)resultMap.get(FIELD_UPDATE_APPLY_ID));
                rspBO.setUpdateApplyCode((String)resultMap.get(FIELD_UPDATE_APPLY_CODE));
                return rspBO;
            }
            if (ContractConstant.ContractType.ENTER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                Map<String, Object> resultMap = this.addEnterContractApply(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u5165\u9a7b\u5408\u540c\u53d8\u66f4\u6210\u529f");
                rspBO.setUpdateApplyId((Long)resultMap.get(FIELD_UPDATE_APPLY_ID));
                rspBO.setUpdateApplyCode((String)resultMap.get(FIELD_UPDATE_APPLY_CODE));
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
            return rspBO;
        }
        if ("1".equals(reqBO.getOperType())) {
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveOrderContractApply(reqBO);
                rspBO.setUpdateApplyId(reqBO.getUpdateApplyId());
                rspBO.setUpdateApplyCode(reqBO.getUpdateApplyCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u8ba2\u5355\u5408\u540c\u53d8\u66f4\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType()) || ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveAgreeContractApply(reqBO);
                rspBO.setUpdateApplyId(reqBO.getUpdateApplyId());
                rspBO.setUpdateApplyCode(reqBO.getUpdateApplyCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u534f\u8bae\u5408\u540c\u53d8\u66f4\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.ENTER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                this.saveEnterContractApply(reqBO);
                rspBO.setUpdateApplyId(reqBO.getUpdateApplyId());
                rspBO.setUpdateApplyCode(reqBO.getUpdateApplyCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u5165\u9a7b\u5408\u540c\u53d8\u66f4\u6210\u529f");
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
            return rspBO;
        }
        if ("2".equals(reqBO.getOperType())) {
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                atomReqBO.setProcDefKey(PROCESS);
                atomReqBO.setContractId(reqBO.getUpdateApplyId());
                atomReqBO.setMenuId(PROCESS);
                atomReqBO.setObjType(1);
                atomReqBO.setUserId(reqBO.getUserId());
                atomReqBO.setUsername(reqBO.getUserName());
                atomReqBO.setOrgId(reqBO.getOrgId());
                ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                reqBO.setStepId(atomRspBO.getStepId());
                this.saveOrderContractApply(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u63d0\u4ea4\u8ba2\u5355\u5408\u540c\u53d8\u66f4\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType()) || ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                atomReqBO.setProcDefKey(PROCESS);
                atomReqBO.setContractId(reqBO.getUpdateApplyId());
                atomReqBO.setMenuId(PROCESS);
                atomReqBO.setObjType(1);
                atomReqBO.setUserId(reqBO.getUserId());
                atomReqBO.setUsername(reqBO.getUserName());
                atomReqBO.setOrgId(reqBO.getOrgId());
                ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                reqBO.setStepId(atomRspBO.getStepId());
                this.saveAgreeContractApply(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u63d0\u4ea4\u534f\u8bae\u5408\u540c\u53d8\u66f4\u6210\u529f");
                return rspBO;
            }
            if (ContractConstant.ContractType.ENTER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                atomReqBO.setProcDefKey(PROCESS);
                atomReqBO.setContractId(reqBO.getUpdateApplyId());
                atomReqBO.setMenuId(PROCESS);
                atomReqBO.setObjType(1);
                atomReqBO.setUserId(reqBO.getUserId());
                atomReqBO.setUsername(reqBO.getUserName());
                atomReqBO.setOrgId(reqBO.getOrgId());
                ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                reqBO.setStepId(atomRspBO.getStepId());
                this.saveEnterContractApply(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u63d0\u4ea4\u5165\u9a7b\u5408\u540c\u53d8\u66f4\u6210\u529f");
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
            return rspBO;
        }
        rspBO.setRespCode("1007");
        rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        return rspBO;
    }

    private Map<String, Object> addOrderContractApply(ContractApplyAddBusiReqBO reqBO) {
        Map<String, Object> addContractApplyResultMap = this.addContractApplyInfo(reqBO);
        this.addContractOrderInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayTypes())) {
            this.addContractPayTypeInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAcceessoryList())) {
            this.addContractApplyAccessoryInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getContractAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        return addContractApplyResultMap;
    }

    private void saveOrderContractApply(ContractApplyAddBusiReqBO reqBO) {
        this.saveContractApplyInfo(reqBO);
        this.updateContractOrderInfo(reqBO);
        this.updateContractItemInfo(reqBO);
        this.updateContractPayTypeInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
        this.updateContractApplyAccessoryInfo(reqBO);
    }

    private Map<String, Object> addAgreeContractApply(ContractApplyAddBusiReqBO reqBO) {
        Map<String, Object> addContractApplyResultMap = this.addContractApplyInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getContractAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAcceessoryList())) {
            this.addContractApplyAccessoryInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        return addContractApplyResultMap;
    }

    private void saveAgreeContractApply(ContractApplyAddBusiReqBO reqBO) {
        this.saveContractApplyInfo(reqBO);
        this.updateContractItemInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
        this.updateContractApplyAccessoryInfo(reqBO);
    }

    private Map<String, Object> addEnterContractApply(ContractApplyAddBusiReqBO reqBO) {
        Map<String, Object> addContractApplyResultMap = this.addContractApplyInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getContractAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAcceessoryList())) {
            this.addContractApplyAccessoryInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCategoryRateList())) {
            this.addSaleCategoryRateInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getYearEndRateList())) {
            this.addLadderRateInfo((Long)addContractApplyResultMap.get(FIELD_UPDATE_APPLY_ID), reqBO);
        }
        return addContractApplyResultMap;
    }

    private void saveEnterContractApply(ContractApplyAddBusiReqBO reqBO) {
        this.saveContractApplyInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
        this.updateContractApplyAccessoryInfo(reqBO);
        this.saveSaleCategoryRateInfo(reqBO);
        this.saveLadderRateInfo(reqBO);
    }

    private Map<String, Object> addContractApplyInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractPo contractInfoPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractInfoPo != null) {
            ContractModifyApplyPo insertContractApplyPo = new ContractModifyApplyPo();
            BeanUtils.copyProperties((Object)contractInfoPo, (Object)insertContractApplyPo);
            BeanUtils.copyProperties((Object)reqBO, (Object)insertContractApplyPo);
            insertContractApplyPo.setBussNode(reqBO.getBussNode());
            insertContractApplyPo.setContractDocUrl(contractInfoPo.getContractDocUrl());
            insertContractApplyPo.setContractSignDate(DateTimeUtils.Date2String(insertContractApplyPo.getContractSignDate()));
            insertContractApplyPo.setContractEndDate(DateTimeUtils.Date2String(insertContractApplyPo.getContractEndDate()));
            insertContractApplyPo.setCreateDeptId(contractInfoPo.getCreateDeptId());
            insertContractApplyPo.setCreateDeptName(contractInfoPo.getCreateDeptName());
            insertContractApplyPo.setUpdateApplyId(Sequence.getInstance().nextId());
            insertContractApplyPo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_DRAFT);
            insertContractApplyPo.setModifyCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            insertContractApplyPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            try {
                insertContractApplyPo.setPrePay(MoneyUtils.Long2BigDecimal((Long)(reqBO.getPrePay() * 10000L)));
                insertContractApplyPo.setQuaAmount(MoneyUtils.Long2BigDecimal((Long)(reqBO.getQuaAmount() * 10000L)));
                insertContractApplyPo.setDeliveryPay(MoneyUtils.Long2BigDecimal((Long)(reqBO.getDeliveryPay() * 10000L)));
                insertContractApplyPo.setInvoicePay(MoneyUtils.Long2BigDecimal((Long)(reqBO.getInvoicePay() * 10000L)));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u5408\u540c\u53d8\u66f4\u64cd\u4f5c\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
            int addContractApplyResult = this.contractModifyApplyMapper.insertSelective(insertContractApplyPo);
            if (1 == addContractApplyResult) {
                ContractPo updateContractPo = new ContractPo();
                BeanUtils.copyProperties((Object)contractInfoPo, (Object)updateContractPo);
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
                int updateResult = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (1 == updateResult) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put(FIELD_UPDATE_APPLY_ID, insertContractApplyPo.getUpdateApplyId());
                    resultMap.put(FIELD_UPDATE_APPLY_CODE, insertContractApplyPo.getUpdateApplyCode());
                    return resultMap;
                }
                throw new ZTBusinessException("\u539f\u5408\u540c\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            throw new ZTBusinessException("\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5931\u8d25");
        }
        throw new ZTBusinessException("\u9700\u53d8\u66f4\u7684\u5408\u540c\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    private void addContractOrderInfo(Long updateApplyId, ContractApplyAddBusiReqBO reqBO) {
        int result;
        ContractOrderPo insertContractOrderPo = new ContractOrderPo();
        insertContractOrderPo.setId(Sequence.getInstance().nextId());
        insertContractOrderPo.setRelateId(updateApplyId);
        insertContractOrderPo.setRelateCode(reqBO.getUpdateApplyCode());
        insertContractOrderPo.setOrderId(reqBO.getOrderId());
        insertContractOrderPo.setOrderCode(reqBO.getOrderCode());
        insertContractOrderPo.setOrderSource(reqBO.getOrderSource());
        ContractOrderPo queryContractOrderPo = new ContractOrderPo();
        queryContractOrderPo.setRelateId(reqBO.getContractId());
        List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectByCondition(queryContractOrderPo);
        if (contractOrderPos != null && contractOrderPos.size() > 0) {
            log.info("\u8ba2\u5355\u6a21\u5f0f\uff1a" + contractOrderPos.get(0).getOrderModel());
            insertContractOrderPo.setOrderModel(contractOrderPos.get(0).getOrderModel());
        }
        if ((result = this.contractOrderMapper.insertSelective(insertContractOrderPo)) != 1) {
            throw new ZTBusinessException("\u5408\u540c\u8ba2\u5355\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractItemInfo(Long updateApplyId, ContractApplyAddBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getItemList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractItemPo.class);
        for (ContractItemPo contractItemPo : list) {
            if (!ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractType())) {
                if (contractItemPo.getUnitPrice() != null) {
                    contractItemPo.setUnitPrice(contractItemPo.getUnitPrice() * 10000L);
                    log.info("unitPrice\uff1a" + contractItemPo.getUnitPrice());
                }
                if (contractItemPo.getTotalAmount() != null) {
                    contractItemPo.setTotalAmount(contractItemPo.getTotalAmount() * 10000L);
                    log.info("totalAmount\uff1a" + contractItemPo.getTotalAmount());
                }
            }
            contractItemPo.setItemId(Sequence.getInstance().nextId());
            contractItemPo.setRelateId(updateApplyId);
            contractItemPo.setRelateCode(reqBO.getUpdateApplyCode());
            contractItemPo.setCreateUserId(reqBO.getModifyCreateUserId());
            contractItemPo.setCreateUserName(reqBO.getModifyCreateUserName());
            contractItemPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractItemPo.setUpdateUserId(reqBO.getModifyCreateUserId());
            contractItemPo.setUpdateUserName(reqBO.getModifyCreateUserName());
            contractItemPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            int result = this.contractItemMapper.insertSelective(contractItemPo);
            if (result >= 1) continue;
            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractPayTypeInfo(Long updateApplyId, ContractApplyAddBusiReqBO reqBO) {
        ArrayList<ContractPayTypePo> list = new ArrayList<ContractPayTypePo>();
        for (Integer payType : reqBO.getPayTypes()) {
            ContractPayTypePo insertContractPayTypePo = new ContractPayTypePo();
            insertContractPayTypePo.setPayTypeId(Sequence.getInstance().nextId());
            insertContractPayTypePo.setRelateCode(reqBO.getUpdateApplyCode());
            insertContractPayTypePo.setRelateId(updateApplyId);
            insertContractPayTypePo.setRelationType(ContractConstant.ContractPayTypeRelationType.RELATION_TYPE_CONTRACT);
            insertContractPayTypePo.setPayType(payType);
            insertContractPayTypePo.setPayTypeStr(ContractTransFieldUtil.transOrderContractPayType(insertContractPayTypePo.getPayType()));
            list.add(insertContractPayTypePo);
        }
        int result = this.contractPayTypeMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u652f\u4ed8\u65b9\u5f0f\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractAccessoryInfo(Long updateApplyId, ContractApplyAddBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getContractAcceessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(updateApplyId);
            contractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
            contractAccessoryPo.setCreateUserId(reqBO.getModifyCreateUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getModifyCreateUserName());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractApplyAccessoryInfo(Long updateApplyId, ContractApplyAddBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getUpdateAcceessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(updateApplyId);
            contractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
            contractAccessoryPo.setCreateUserId(reqBO.getModifyCreateUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getModifyCreateUserName());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractPayTypeInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractPayTypePo deleteContractPayTypePo = new ContractPayTypePo();
        deleteContractPayTypePo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractPayTypePo.setRelateCode(reqBO.getUpdateApplyCode());
        this.contractPayTypeMapper.deleteByCondition(deleteContractPayTypePo);
        if (!CollectionUtils.isEmpty(reqBO.getPayTypes())) {
            this.addContractPayTypeInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }

    private void updateContractAccessoryInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
        deleteContractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getContractAcceessoryList())) {
            this.addContractAccessoryInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }

    private void updateContractApplyAccessoryInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
        deleteContractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY);
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAcceessoryList())) {
            this.addContractApplyAccessoryInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }

    private void saveContractApplyInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractModifyApplyPo oldContractModifyApplyPo = this.contractModifyApplyMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
        if (oldContractModifyApplyPo != null) {
            int updateResult;
            ContractModifyApplyPo updateContractModifyApplyPo = new ContractModifyApplyPo();
            BeanUtils.copyProperties((Object)oldContractModifyApplyPo, (Object)updateContractModifyApplyPo);
            BeanUtils.copyProperties((Object)reqBO, (Object)updateContractModifyApplyPo);
            updateContractModifyApplyPo.setBussNode(reqBO.getBussNode());
            updateContractModifyApplyPo.setCreateDeptName(oldContractModifyApplyPo.getCreateDeptName());
            updateContractModifyApplyPo.setCreateDeptId(oldContractModifyApplyPo.getCreateDeptId());
            updateContractModifyApplyPo.setContractSignDate(DateTimeUtils.Date2String(updateContractModifyApplyPo.getContractSignDate()));
            updateContractModifyApplyPo.setContractEndDate(DateTimeUtils.Date2String(updateContractModifyApplyPo.getContractEndDate()));
            if ("2".equals(reqBO.getOperType())) {
                updateContractModifyApplyPo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE);
            }
            if ((updateResult = this.contractModifyApplyMapper.updateByPrimaryKeySelective(updateContractModifyApplyPo)) != 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u53d8\u66f4\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u539f\u5408\u540c\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private void updateContractOrderInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractOrderPo deleteContractOrderPo = new ContractOrderPo();
        deleteContractOrderPo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractOrderPo.setRelateCode(reqBO.getUpdateApplyCode());
        this.contractOrderMapper.deleteByCondition(deleteContractOrderPo);
        this.addContractOrderInfo(reqBO.getUpdateApplyId(), reqBO);
    }

    private void updateContractItemInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractItemPo deleteContractItemPo = new ContractItemPo();
        deleteContractItemPo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractItemPo.setRelateCode(reqBO.getUpdateApplyCode());
        this.contractItemMapper.deleteByCondition(deleteContractItemPo);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }

    private void addSaleCategoryRateInfo(Long updateApplyId, ContractApplyAddBusiReqBO reqBO) {
        String saleCategoryRateJsonStr = JSON.toJSONString(reqBO.getCategoryRateList());
        List addSaleCategoryRateInfos = JSONArray.parseArray((String)saleCategoryRateJsonStr).toJavaList(ContractSaleCategoryRatePo.class);
        for (ContractSaleCategoryRatePo contractSaleCategoryRatePo : addSaleCategoryRateInfos) {
            contractSaleCategoryRatePo.setId(Sequence.getInstance().nextId());
            contractSaleCategoryRatePo.setRelateId(updateApplyId);
            String updateApplyCode = reqBO.getUpdateApplyCode();
            contractSaleCategoryRatePo.setRelateCode(updateApplyCode);
            contractSaleCategoryRatePo.setCreateUserId(reqBO.getModifyCreateUserId());
            contractSaleCategoryRatePo.setCreateUserName(reqBO.getModifyCreateUserName());
            contractSaleCategoryRatePo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        this.contractSaleCategoryRateMapper.insertBatch(addSaleCategoryRateInfos);
    }

    private void addLadderRateInfo(Long updateApplyId, ContractApplyAddBusiReqBO reqBO) {
        String saleCategoryRateJsonStr = JSON.toJSONString(reqBO.getYearEndRateList());
        List addLadderRateInfos = JSONArray.parseArray((String)saleCategoryRateJsonStr).toJavaList(ContractLadderRatePo.class);
        for (ContractLadderRatePo contractLadderRatePo : addLadderRateInfos) {
            contractLadderRatePo.setId(Sequence.getInstance().nextId());
            contractLadderRatePo.setRelateId(updateApplyId);
            contractLadderRatePo.setRelateCode(reqBO.getUpdateApplyCode());
            contractLadderRatePo.setCreateUserId(reqBO.getModifyCreateUserId());
            contractLadderRatePo.setCreateUserName(reqBO.getModifyCreateUserName());
            contractLadderRatePo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        this.contractLadderRateMapper.insertBatch(addLadderRateInfos);
    }

    private void saveSaleCategoryRateInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractSaleCategoryRatePo deleteContractSaleCategoryRatePo = new ContractSaleCategoryRatePo();
        deleteContractSaleCategoryRatePo.setRelateCode(reqBO.getUpdateApplyCode());
        deleteContractSaleCategoryRatePo.setRelateId(reqBO.getUpdateApplyId());
        this.contractSaleCategoryRateMapper.deleteByCondition(deleteContractSaleCategoryRatePo);
        if (!CollectionUtils.isEmpty(reqBO.getCategoryRateList())) {
            this.addSaleCategoryRateInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }

    private void saveLadderRateInfo(ContractApplyAddBusiReqBO reqBO) {
        ContractLadderRatePo deleteContractLadderRatePo = new ContractLadderRatePo();
        deleteContractLadderRatePo.setRelateCode(reqBO.getUpdateApplyCode());
        deleteContractLadderRatePo.setRelateId(reqBO.getUpdateApplyId());
        this.contractLadderRateMapper.deleteByCondition(deleteContractLadderRatePo);
        if (!CollectionUtils.isEmpty(reqBO.getYearEndRateList())) {
            this.addLadderRateInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }
}

