/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.atom.ContractDealApprovalAtomService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.bo.ContractDealApprovalAtomReqBO;
import com.tydic.contract.atom.bo.ContractDealApprovalAtomRspBO;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.busi.ContractApprovalBusiService;
import com.tydic.contract.busi.bo.ContractApprovalBusiReqBO;
import com.tydic.contract.busi.bo.ContractApprovalBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractPo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractApprovalBusiServiceImpl
implements ContractApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractApprovalBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    private ContractDealApprovalAtomService contractDealApprovalAtomService;

    @Override
    public ContractApprovalBusiRspBO dealApprovalContract(ContractApprovalBusiReqBO reqBO) {
        ContractApprovalBusiRspBO rspBO = new ContractApprovalBusiRspBO();
        for (Long contractId : reqBO.getContractIdList()) {
            ContractPo contractPo = this.contractMapper.selectByPrimaryKey(contractId);
            if (contractPo != null) {
                ContractDealApprovalAtomRspBO atomRspBO;
                ContractDealApprovalAtomReqBO atomReqBO;
                ContractPo updateContractPo = new ContractPo();
                BeanUtils.copyProperties((Object)contractPo, (Object)updateContractPo);
                if (ContractConstant.AuditResult.AUDIT_RESULT_YES.equals(reqBO.getContractApprovalResult())) {
                    atomReqBO = new ContractDealApprovalAtomReqBO();
                    atomReqBO.setAuditAdvice(reqBO.getContractApprovalRemark());
                    atomReqBO.setUsername(reqBO.getContractApprovalUserName());
                    atomReqBO.setStepId(contractPo.getStepId());
                    atomReqBO.setContractId(contractPo.getContractId());
                    atomReqBO.setObjType(1);
                    atomReqBO.setDept(reqBO.getContractApprovalDept());
                    atomReqBO.setOperId(reqBO.getContractApprovalUserId().toString());
                    atomReqBO.setAuditResult(ContractConstant.AuditResult.AUDIT_RESULT_YES);
                    atomRspBO = this.contractDealApprovalAtomService.dealApproval(atomReqBO);
                    log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6ccode\uff1a" + atomRspBO.getRespCode());
                    if (!atomRspBO.getRespCode().equals("0000")) {
                        throw new ZTBusinessException(atomRspBO.getRespDesc());
                    }
                    updateContractPo.setStepId(atomRspBO.getStepId());
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
                } else if (ContractConstant.AuditResult.AUDIT_RESULT_NO.equals(reqBO.getContractApprovalResult())) {
                    atomReqBO = new ContractDealApprovalAtomReqBO();
                    atomReqBO.setAuditAdvice(reqBO.getContractApprovalRemark());
                    atomReqBO.setUsername(reqBO.getContractApprovalUserName());
                    atomReqBO.setStepId(contractPo.getStepId());
                    atomReqBO.setContractId(contractPo.getContractId());
                    atomReqBO.setObjType(1);
                    atomReqBO.setDept(reqBO.getContractApprovalDept());
                    atomReqBO.setOperId(reqBO.getContractApprovalUserId().toString());
                    atomReqBO.setAuditResult(ContractConstant.AuditResult.AUDIT_RESULT_NO);
                    atomRspBO = this.contractDealApprovalAtomService.dealApproval(atomReqBO);
                    log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6ccode\uff1a" + atomRspBO.getRespCode());
                    if (!atomRspBO.getRespCode().equals("0000")) {
                        throw new ZTBusinessException(atomRspBO.getRespDesc());
                    }
                    updateContractPo.setStepId(atomRspBO.getStepId());
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
                } else {
                    rspBO.setRespCode("1013");
                    rspBO.setRespDesc("\u9519\u8bef\u7684\u5ba1\u6279\u7ed3\u679c");
                    return rspBO;
                }
                updateContractPo.setContractApprovalUserId(reqBO.getContractApprovalUserId());
                updateContractPo.setContractApprovalUserName(reqBO.getContractApprovalUserName());
                updateContractPo.setContractApprovalResult(reqBO.getContractApprovalResult());
                updateContractPo.setContractApprovalRemark(reqBO.getContractApprovalRemark());
                updateContractPo.setContractApprovalTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                int updateResult = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (updateResult == 1) {
                    if (!ContractConstant.AuditResult.AUDIT_RESULT_YES.equals(reqBO.getContractApprovalResult())) continue;
                    ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
                    contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
                    contractRecordContractNodeOperLogAtomReqBO.setNodeCode("CONTRACT_APPROVAL");
                    contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u5408\u540c\u5ba1\u6279");
                    contractRecordContractNodeOperLogAtomReqBO.setOperUserId(reqBO.getContractApprovalUserId());
                    contractRecordContractNodeOperLogAtomReqBO.setOperUserName(reqBO.getContractApprovalUserName());
                    this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
                    continue;
                }
                throw new ZTBusinessException("\u5ba1\u6279\u5931\u8d25");
            }
            rspBO.setRespCode("1013");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5408\u540c\u6570\u636e");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }
}

