/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.tydic.contract.busi.ContractDeleteBusiService;
import com.tydic.contract.busi.bo.ContractDeleteBusiReqBO;
import com.tydic.contract.busi.bo.ContractDeleteBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractLadderRateMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractSaleCategoryRateMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractLadderRatePo;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.po.ContractPayTypePo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractSaleCategoryRatePo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractDeleteBusiServiceImpl
implements ContractDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractDeleteBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private ContractSaleCategoryRateMapper contractSaleCategoryRateMapper;
    @Autowired
    private ContractLadderRateMapper contractLadderRateMapper;

    @Override
    public ContractDeleteBusiRspBO deleteContract(ContractDeleteBusiReqBO reqBO) {
        ContractDeleteBusiRspBO rspBO = new ContractDeleteBusiRspBO();
        List<ContractPo> contractPos = this.contractMapper.qryByContractIdList(reqBO.getContractIdList());
        if (!CollectionUtils.isEmpty(contractPos)) {
            Long signContractId = this.getSignContractId(reqBO);
            for (ContractPo contractPo : contractPos) {
                this.deleteAssociateData(contractPo);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u5220\u9664\u6210\u529f");
            rspBO.setSignContractId(signContractId);
            return rspBO;
        }
        rspBO.setRespCode("1009");
        rspBO.setRespDesc("\u5408\u540c\u5220\u9664-\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u5230\u76f8\u5e94\u7684\u5408\u540c\u4fe1\u606f");
        return rspBO;
    }

    private Long getSignContractId(ContractDeleteBusiReqBO reqBO) {
        Long contractId = reqBO.getContractIdList().get(0);
        Long signContractId = this.contractMapper.selectByPrimaryKey(contractId).getSignContractId();
        log.info("\u8be5\u5408\u540c\u5bf9\u5e94\u7684signContractId\uff1a" + signContractId);
        return signContractId;
    }

    private void deleteAssociateData(ContractPo contractPo) {
        this.contractMapper.deleteByPrimaryKey(contractPo.getContractId());
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateCode(contractPo.getContractCode());
        deleteContractAccessoryPo.setRelateId(contractPo.getContractId());
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (contractPo.getContractType().equals(ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE) || contractPo.getContractType().equals(ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE)) {
            ContractItemPo deleteContractItemPo = new ContractItemPo();
            deleteContractItemPo.setRelateCode(contractPo.getContractCode());
            deleteContractItemPo.setRelateId(contractPo.getContractId());
            this.contractItemMapper.deleteByCondition(deleteContractItemPo);
        } else if (contractPo.getContractType().equals(ContractConstant.ContractType.ENTER_CONTRACT_TYPE)) {
            ContractSaleCategoryRatePo deleteContractSaleCategoryRatePo = new ContractSaleCategoryRatePo();
            deleteContractSaleCategoryRatePo.setRelateId(contractPo.getContractId());
            deleteContractSaleCategoryRatePo.setRelateCode(contractPo.getContractCode());
            this.contractSaleCategoryRateMapper.deleteByCondition(deleteContractSaleCategoryRatePo);
            ContractLadderRatePo deleteContractLadderRatePo = new ContractLadderRatePo();
            deleteContractLadderRatePo.setRelateId(contractPo.getContractId());
            deleteContractLadderRatePo.setRelateCode(contractPo.getContractCode());
            this.contractLadderRateMapper.deleteByCondition(deleteContractLadderRatePo);
        } else if (contractPo.getContractType().equals(ContractConstant.ContractType.ORDER_CONTRACT_TYPE)) {
            ContractPayTypePo deleteContractPayTypePo = new ContractPayTypePo();
            deleteContractPayTypePo.setRelateCode(contractPo.getContractCode());
            deleteContractPayTypePo.setRelateId(contractPo.getContractId());
            this.contractPayTypeMapper.deleteByCondition(deleteContractPayTypePo);
            ContractItemPo deleteContractItemPo = new ContractItemPo();
            deleteContractItemPo.setRelateCode(contractPo.getContractCode());
            deleteContractItemPo.setRelateId(contractPo.getContractId());
            this.contractItemMapper.deleteByCondition(deleteContractItemPo);
            ContractOrderPo deleteContractOrderPo = new ContractOrderPo();
            deleteContractOrderPo.setRelateCode(contractPo.getContractCode());
            deleteContractOrderPo.setRelateId(contractPo.getContractId());
            this.contractOrderMapper.deleteByCondition(deleteContractOrderPo);
        }
    }
}

