/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.ability.bo.ContractPayTypeBO;
import com.tydic.contract.ability.bo.ContractVersionBO;
import com.tydic.contract.busi.ContractQryDetailBusiService;
import com.tydic.contract.busi.bo.ContractQryDetailBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryDetailBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.po.ContractPayTypePo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractTermsPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQryDetailBusiServiceImpl
implements ContractQryDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryDetailBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;

    @Override
    public ContractQryDetailBusiRspBO qryContractDetail(ContractQryDetailBusiReqBO reqBO) {
        ContractQryDetailBusiRspBO rspBO = new ContractQryDetailBusiRspBO();
        ContractPo contractInfoPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractInfoPo != null) {
            BeanUtils.copyProperties((Object)contractInfoPo, (Object)((Object)rspBO));
            ContractTermsPo selectPo = new ContractTermsPo();
            selectPo.setTermCode(contractInfoPo.getTermCode());
            ContractTermsPo contractTermsPo = this.contractTermsMapper.selectByTermCode(selectPo);
            if (contractInfoPo != null) {
                log.info("\u67e5\u8be2\u5408\u540c\u6761\u6b3e:" + contractTermsPo.getTermText());
                rspBO.setContractTermText(contractTermsPo.getTermText());
            }
            this.transResult(rspBO);
            rspBO.setContractSignDate(DateTimeUtils.Time2Date(rspBO.getContractSignDate()));
            rspBO.setNeedArriveTime(DateTimeUtils.Time2Date(rspBO.getNeedArriveTime()));
            rspBO.setContractEndDate(DateTimeUtils.Time2Date(rspBO.getContractEndDate()));
            log.info("\u5408\u540c\u8be6\u60c5\u67e5\u8be2API: contractSignDate" + rspBO.getContractSignDate() + " needArriveTime " + rspBO.getNeedArriveTime());
            ContractAccessoryPo queryContractAccessoryPo = new ContractAccessoryPo();
            queryContractAccessoryPo.setRelateCode(contractInfoPo.getContractCode());
            queryContractAccessoryPo.setRelateId(contractInfoPo.getContractId());
            queryContractAccessoryPo.setAcceessoryType(ContractConstant.AccessoryType.ACCESSORY_TYPE);
            List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(queryContractAccessoryPo);
            if (!CollectionUtils.isEmpty(contractAccessoryPos)) {
                String resultString = JSON.toJSONString(contractAccessoryPos);
                List acceessoryList = JSONArray.parseArray((String)resultString).toJavaList(ContractAccessoryBO.class);
                rspBO.setAcceessoryList(acceessoryList);
            }
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(contractInfoPo.getContractType())) {
                ContractPayTypePo queryContractPayTypePo = new ContractPayTypePo();
                queryContractPayTypePo.setRelateId(contractInfoPo.getContractId());
                queryContractPayTypePo.setRelateCode(contractInfoPo.getContractCode());
                List<ContractPayTypePo> contractPayTypePos = this.contractPayTypeMapper.qryByCondition(queryContractPayTypePo);
                if (!CollectionUtils.isEmpty(contractPayTypePos)) {
                    String resultString = JSON.toJSONString(contractPayTypePos);
                    List payTypes = JSONArray.parseArray((String)resultString).toJavaList(ContractPayTypeBO.class);
                    rspBO.setPayTypes(payTypes);
                    String payTypeStr = "";
                    for (ContractPayTypeBO payType : payTypes) {
                        payTypeStr = payTypeStr + payType.getPayTypeStr() + ",";
                    }
                    payTypeStr = payTypeStr.substring(0, payTypeStr.length() - 1);
                    rspBO.setPayTypeStr(payTypeStr);
                }
                ContractOrderPo contractOrderPo = new ContractOrderPo();
                contractOrderPo.setRelateId(contractInfoPo.getContractId());
                contractOrderPo.setRelateCode(contractInfoPo.getContractCode());
                List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectByCondition(contractOrderPo);
                if (contractOrderPos != null && contractOrderPos.size() > 0) {
                    rspBO.setOrderCode(contractOrderPos.get(0).getOrderCode());
                }
            }
        } else {
            rspBO.setRespCode("1008");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5408\u540c\u6570\u636e");
            return rspBO;
        }
        ContractAccessoryPo contractAccessoryPo = new ContractAccessoryPo();
        ArrayList<Integer> accessoryTypeList = new ArrayList<Integer>();
        accessoryTypeList.add(ContractConstant.AccessoryType.ACCESSORY_TYPE_CONTRACT);
        accessoryTypeList.add(ContractConstant.AccessoryType.ACCESSORY_TYPE_LAUNCH);
        accessoryTypeList.add(ContractConstant.AccessoryType.ACCESSORY_TYPE_SIGN);
        contractAccessoryPo.setAcceessoryTypeList(accessoryTypeList);
        contractAccessoryPo.setRelateId(contractInfoPo.getContractId());
        List<ContractAccessoryPo> contractAccessoryPoList = this.contractAccessoryMapper.qrySignContract(contractAccessoryPo);
        ArrayList<ContractVersionBO> contractVersionBOList = new ArrayList<ContractVersionBO>();
        contractVersionBOList.addAll(contractAccessoryPoList.stream().map(contractAccessoryPO -> {
            ContractVersionBO BO = new ContractVersionBO();
            BO.setVersionNum("V" + contractAccessoryPO.getAcceessoryType());
            BO.setOperType(ContractTransFieldUtil.transContractAccessoryType(contractAccessoryPO.getAcceessoryType()));
            BO.setCreateUserId(contractAccessoryPO.getCreateUserId());
            BO.setCreateUserName(contractAccessoryPO.getCreateUserName());
            BO.setCreateTime(contractAccessoryPO.getCreateTime());
            BO.setDocUrl(contractAccessoryPO.getAcceessoryUrl());
            return BO;
        }).collect(Collectors.toList()));
        rspBO.setContractVersionBOList(contractVersionBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private void transResult(ContractQryDetailBusiRspBO rspBO) {
        if (rspBO.getContractAmount() != null) {
            rspBO.setContractAmountMoney(ContractTransFieldUtil.transContractAmount(rspBO.getContractAmount()));
        }
        if (rspBO.getContractType() != null) {
            rspBO.setContractTypeStr(ContractTransFieldUtil.transContractType(rspBO.getContractType()));
        }
        if (rspBO.getExpectSettle() != null) {
            rspBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(rspBO.getExpectSettle()));
        }
        if (rspBO.getPayType() != null) {
            rspBO.setPayTypeStr(ContractTransFieldUtil.transPayType(rspBO.getPayType()));
        }
        if (rspBO.getSsBusiWay() != null) {
            rspBO.setSsBusiWayStr(ContractTransFieldUtil.transSsBusiWay(rspBO.getSsBusiWay()));
        }
        if (rspBO.getOrgType() != null) {
            rspBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(rspBO.getOrgType()));
        }
        if (rspBO.getServiceFeeType() != null) {
            rspBO.setServiceFeeTypeStr(ContractTransFieldUtil.transServiceFeeType(rspBO.getServiceFeeType()));
        }
        if (rspBO.getChargeSaleCategoryFee() != null) {
            rspBO.setChargeSaleCategoryFeeStr(ContractTransFieldUtil.transChargeSaleCategoryFee(rspBO.getChargeSaleCategoryFee()));
        }
        if (rspBO.getChargeSaleCategoryFeeNode() != null) {
            rspBO.setChargeSaleCategoryFeeNodeStr(ContractTransFieldUtil.transChargeSaleCategoryFeeNode(rspBO.getChargeSaleCategoryFeeNode()));
        }
        if (rspBO.getChargeLadderRateFee() != null) {
            rspBO.setChargeLadderRateFeeStr(ContractTransFieldUtil.transChargeLadderRateFee(rspBO.getChargeLadderRateFee()));
        }
        if (rspBO.getContractApprovalResult() != null) {
            rspBO.setContractApprovalResultStr(ContractTransFieldUtil.transContractApprovalResult(rspBO.getContractApprovalResult()));
        }
        if (rspBO.getBussNode() != null) {
            log.info("BUSS_NODE:" + rspBO.getBussNode());
            rspBO.setBussNodeStr(ContractTransFieldUtil.transContractBussNode(rspBO.getBussNode()));
        }
        if (rspBO.getCustomerConfirm() != null) {
            rspBO.setCustomerConfirmStr(ContractTransFieldUtil.transContractCustomerConfirm(rspBO.getCustomerConfirm()));
        }
        if (rspBO.getChargePlatformEntyFee() != null) {
            rspBO.setChargePlatformEntyFeeStr(ContractTransFieldUtil.transChargePlatformEntyFee(rspBO.getChargePlatformEntyFee()));
        }
    }
}

