/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.ContractStartApprovalProcessAtomService;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomRspBO;
import com.tydic.contract.busi.ContractSignBusiService;
import com.tydic.contract.busi.bo.ContractSignBusiReqBO;
import com.tydic.contract.busi.bo.ContractSignBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractPo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractSignBusiServiceImpl
implements ContractSignBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractSignBusiServiceImpl.class);
    public static final String FIELD_CONTRACT_ID = "contractId";
    public static final String FIELD_CONTRACT_CODE = "contractCode";
    public static final String PROCESS = "contract_create";
    @Autowired
    private ContractStartApprovalProcessAtomService contractStartApprovalProcessAtomService;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;

    @Override
    public ContractSignBusiRspBO dealContractSign(ContractSignBusiReqBO reqBO) {
        ContractSignBusiRspBO rspBO = new ContractSignBusiRspBO();
        ContractPo contractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractPo == null) {
            throw new ZTBusinessException("\u6839\u636e\u5408\u540cid\u6ca1\u6709\u67e5\u5230\u54cd\u5e94\u6570\u636e");
        }
        if (contractPo.getContractDocUrl() == null) {
            throw new ZTBusinessException("\u8be5\u5408\u540c\u6ca1\u6709\u751f\u6210\u5408\u540c\u6587\u4ef6");
        }
        ContractAccessoryPo contractAccessoryPo = new ContractAccessoryPo();
        contractAccessoryPo.setRelateId(reqBO.getContractId());
        contractAccessoryPo.setRelateCode(contractPo.getContractCode());
        contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
        contractAccessoryPo.setCreateUserId(reqBO.getUserId());
        contractAccessoryPo.setCreateUserName(reqBO.getUserName());
        contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (ContractConstant.ContractSignOperType.PRODUCERS_SIGN.equals(reqBO.getSignType())) {
            contractAccessoryPo.setAcceessoryType(ContractConstant.AccessoryType.ACCESSORY_TYPE_LAUNCH);
            contractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
        } else {
            contractAccessoryPo.setAcceessoryType(ContractConstant.AccessoryType.ACCESSORY_TYPE_SIGN);
            contractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
        }
        contractAccessoryPo.setAcceessoryName(reqBO.getSignContractDoc().getAcceessoryName());
        contractAccessoryPo.setAcceessoryUrl(reqBO.getSignContractDoc().getAcceessoryUrl());
        contractPo.setContractDocName(reqBO.getSignContractDoc().getAcceessoryName());
        contractPo.setContractDocUrl(reqBO.getSignContractDoc().getAcceessoryUrl());
        int i = this.contractAccessoryMapper.insert(contractAccessoryPo);
        if (i != 1) {
            throw new ZTBusinessException("\u5408\u540c\u7b7e\u7ae0\u5f02\u5e38\uff1a\u5408\u540c\u9644\u4ef6\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        if (ContractConstant.ContractSignOperType.SIGNATORIES_SIGN.equals(reqBO.getSignType())) {
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(contractPo.getContractType())) {
                ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                atomReqBO.setProcDefKey(PROCESS);
                atomReqBO.setContractId(reqBO.getContractId());
                atomReqBO.setMenuId(PROCESS);
                atomReqBO.setObjType(1);
                atomReqBO.setDept(reqBO.getCreateDeptName());
                atomReqBO.setUserId(reqBO.getUserId());
                atomReqBO.setUsername(reqBO.getUserName());
                atomReqBO.setOrgId(reqBO.getOrgId());
                ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode() + " \u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2stepId\uff1a" + atomRspBO.getStepId());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                contractPo.setStepId(atomRspBO.getStepId());
            } else if (ContractConstant.ContractType.ENTER_CONTRACT_TYPE.equals(contractPo.getContractType())) {
                ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                atomReqBO.setProcDefKey(PROCESS);
                atomReqBO.setContractId(reqBO.getContractId());
                atomReqBO.setMenuId(PROCESS);
                atomReqBO.setObjType(1);
                atomReqBO.setUserId(reqBO.getUserId());
                atomReqBO.setUsername(reqBO.getUserName());
                atomReqBO.setOrgId(reqBO.getOrgId());
                ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode() + " \u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2stepId\uff1a" + atomRspBO.getStepId());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                contractPo.setStepId(atomRspBO.getStepId());
            } else {
                rspBO.setRespCode("1007");
                rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
                return rspBO;
            }
        }
        this.contractMapper.updateByPrimaryKeySelective(contractPo);
        this.recordContractNodeOperLog(reqBO.getContractId(), reqBO.getUserId(), reqBO.getUserName(), reqBO.getSignType());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u7b7e\u7ae0\u6210\u529f");
        return rspBO;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName, Integer signType) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        if (ContractConstant.ContractSignOperType.PRODUCERS_SIGN.equals(signType)) {
            contractRecordContractNodeOperLogAtomReqBO.setNodeCode("PRODUCER_SIGN");
            contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u751f\u6210\u65b9\u7b7e\u7ae0");
        } else {
            contractRecordContractNodeOperLogAtomReqBO.setNodeCode("SIGNATORIES_SIGN");
            contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u7b7e\u8ba2\u65b9\u7b7e\u7ae0");
        }
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }
}

