/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.busi.CopyContractTemplateBusiService;
import com.tydic.contract.busi.bo.CopyContractTemplateBusiReqBO;
import com.tydic.contract.busi.bo.CopyContractTemplateBusiRspBO;
import com.tydic.contract.dao.ContractTemplateApplyUnitMapper;
import com.tydic.contract.dao.ContractTemplateMapper;
import com.tydic.contract.po.ContractTemplateApplyUnitPo;
import com.tydic.contract.po.ContractTemplatePo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CopyContractTemplateBusiServiceImpl
implements CopyContractTemplateBusiService {
    private static final Logger log = LoggerFactory.getLogger(CopyContractTemplateBusiServiceImpl.class);
    @Autowired
    private ContractTemplateMapper contractTemplateMapper;
    @Autowired
    private ContractTemplateApplyUnitMapper contractTemplateApplyUnitMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CopyContractTemplateBusiRspBO copyContractTemplate(CopyContractTemplateBusiReqBO reqBO) {
        CopyContractTemplateBusiRspBO rspBO = new CopyContractTemplateBusiRspBO();
        ContractTemplatePo oldContractTemplatePo = this.contractTemplateMapper.selectByPrimaryKey(reqBO.getTemplateId());
        if (oldContractTemplatePo != null) {
            String templateName = oldContractTemplatePo.getTemplateName();
            String templateNewName = this.getTemplateName(templateName);
            ContractTemplatePo copyPo = new ContractTemplatePo();
            BeanUtils.copyProperties((Object)oldContractTemplatePo, (Object)copyPo);
            copyPo.setTemplateId(Sequence.getInstance().nextId());
            copyPo.setTemplateCode(reqBO.getTemplateCodeNew());
            copyPo.setTemplateName(templateNewName);
            copyPo.setCreateUserId(reqBO.getUserId());
            copyPo.setCreateUserName(reqBO.getUserName());
            copyPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            copyPo.setUpdateUserId(reqBO.getUserId());
            copyPo.setUpdateUserName(reqBO.getUserName());
            copyPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            int i = this.contractTemplateMapper.insertSelective(copyPo);
            if (i != 1) throw new ZTBusinessException("\u590d\u5236\u5408\u540c\u6a21\u677f\u5931\u8d25");
            List<ContractTemplateApplyUnitPo> oldContractTemplateApplyUnitPos = this.contractTemplateApplyUnitMapper.qryByTemplateCode(oldContractTemplatePo.getTemplateCode());
            if (!CollectionUtils.isEmpty(oldContractTemplateApplyUnitPos)) {
                for (ContractTemplateApplyUnitPo contractTemplateApplyUnitPo : oldContractTemplateApplyUnitPos) {
                    ContractTemplateApplyUnitPo templateApplyUnitCopyPo = new ContractTemplateApplyUnitPo();
                    BeanUtils.copyProperties((Object)contractTemplateApplyUnitPo, (Object)templateApplyUnitCopyPo);
                    templateApplyUnitCopyPo.setTemplateCode(reqBO.getTemplateCodeNew());
                    templateApplyUnitCopyPo.setTemplateUnitId(Sequence.getInstance().nextId());
                    templateApplyUnitCopyPo.setCreateUserId(reqBO.getUserId());
                    templateApplyUnitCopyPo.setCreateUserName(reqBO.getUserName());
                    templateApplyUnitCopyPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    int j = this.contractTemplateApplyUnitMapper.insertSelective(templateApplyUnitCopyPo);
                    if (j == 1) continue;
                    throw new ZTBusinessException("\u590d\u5236\u5408\u540c\u6a21\u677f\u9002\u7528\u5355\u4f4d\u5931\u8d25");
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u6a21\u677f\u590d\u5236\u6210\u529f");
            return rspBO;
        } else {
            rspBO.setRespCode("1006");
            rspBO.setRespDesc("\u9700\u8981\u590d\u5236\u7684\u5408\u540c\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        return rspBO;
    }

    public String getTemplateName(String templateName) {
        List<String> allTemplateNames = this.contractTemplateMapper.selectAllTemplateName();
        int size = templateName.length();
        for (int i = 1; i < 100; ++i) {
            if (!allTemplateNames.contains(templateName = templateName + "-" + i)) {
                log.info("templateNewName:" + templateName);
                return templateName;
            }
            templateName = templateName.substring(0, size);
        }
        return null;
    }

    public String getList(List<String> list) {
        String name = "";
        for (String s : list) {
            name = name + s;
        }
        return name;
    }
}

