/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;

public class FileHelper {
    private FileHelper() {
    }

    public static byte[] getBytes(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream fis = null;
        byte[] buffer = null;
        try {
            fis = new FileInputStream(file);
            buffer = new byte[(int)file.length()];
            fis.read(buffer);
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new IOException("\u5173\u95ed\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
                }
            }
        }
        return buffer;
    }

    public static String getFileName(String path) {
        return new File(path).getName();
    }

    private static byte[] getFileMd5Bytes128(String filePath) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filePath));
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[fis.available()];
            int len = -1;
            while ((len = fis.read(buffer, 0, 1024)) != -1) {
                md5.update(buffer, 0, len);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6md5\u4e8c\u8fdb\u5236\u6570\u7ec4\u5931\u8d25", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new IOException("\u5173\u95ed\u8bfb\u5199\u6d41\u5931\u8d25", e);
                }
            }
        }
    }
}

