/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.utils.npc.aop;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.utils.npc.bo.NpcBaseRspBo;
import com.tydic.utils.npc.bo.NpcRpcControllerReqBo;
import com.tydic.utils.npc.bo.NpcRpcControllerRspBo;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import lombok.extern.ohaotian.TempServiceInfo;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpcNativeRpcCallAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(NpcNativeRpcCallAdvice.class);
    private static final String SUCCESS_CODE = "0";
    private final String rpcCallUrl;

    public NpcNativeRpcCallAdvice(String rpcCallUrl) {
        this.rpcCallUrl = rpcCallUrl;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Class<?> aClass = method.getDeclaringClass();
        TempServiceInfo tempAnnotation = aClass.getAnnotation(TempServiceInfo.class);
        if (null != tempAnnotation) {
            String responseBody;
            NpcBaseRspBo baseRspBo;
            NpcRpcControllerReqBo reqBo = new NpcRpcControllerReqBo();
            reqBo.setInterClass(aClass.getName());
            reqBo.setMethod(method.getName());
            Object data = methodInvocation.getArguments()[0];
            reqBo.setData(data);
            String reqBoJson = JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            HttpResponse response = HttpRequest.post((String)this.rpcCallUrl).body(reqBoJson).timeout(60000).execute();
            if (200 != response.getStatus()) {
                String failureDesc = "\u8c03\u7528\u670d\u52a1\u5668RPC ControllerHttp\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a\uff1a" + response.getStatus() + "\uff1b\u8bf7\u6c42\u5165\u53c2\uff1a" + reqBoJson + "\uff1b\u8bf7\u6c42\u5730\u5740\uff1a" + this.rpcCallUrl;
                log.info(failureDesc);
                baseRspBo = new NpcBaseRspBo();
                baseRspBo.setRespCode("8888");
                baseRspBo.setRespDesc(failureDesc);
                baseRspBo.setCode("1");
                baseRspBo.setMessage(failureDesc);
                responseBody = JSON.toJSONString((Object)baseRspBo);
            } else {
                responseBody = response.body();
            }
            NpcRpcControllerRspBo rspBo = (NpcRpcControllerRspBo)JSON.parseObject((String)responseBody, NpcRpcControllerRspBo.class);
            if (!SUCCESS_CODE.equals(rspBo.getCode())) {
                baseRspBo = new NpcBaseRspBo();
                baseRspBo.setRespCode("8888");
                baseRspBo.setRespDesc(rspBo.getMessage());
                baseRspBo.setCode(rspBo.getCode());
                baseRspBo.setMessage(rspBo.getMessage());
                rspBo.setData(baseRspBo);
            }
            AnnotatedType annotatedReturnType = methodInvocation.getMethod().getAnnotatedReturnType();
            String rspJson = JSONObject.toJSONString((Object)rspBo.getData());
            rspJson = rspJson.replace("\\\"", "");
            log.info("\u8fdc\u7a0bRPC\u670d\u52a1\u8c03\u7528\u65e5\u5fd7\u6253\u5370\n\u63a5\u53e3\uff1a{}\n\u5165\u53c2\uff1a{}\n\u51fa\u53c2\uff1a{}", new Object[]{reqBo.getInterClass() + "." + reqBo.getMethod(), JSON.toJSONString((Object)data), rspJson});
            return JSON.parseObject((String)rspJson, (Type)annotatedReturnType.getType(), (Feature[])new Feature[0]);
        }
        return methodInvocation.proceed();
    }
}

