/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService"})
public class FscBillOrderCreateAbilityServiceImpl
implements FscBillOrderCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderCreateBusiService fscBillOrderCreateBusiService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    private static final String DEAL_DESC = "\u5f00\u7968\u4e3b\u5355\u521b\u5efa";
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Value(value="${FSC_INVOICE_APLLY_TOPIC:FSC_INVOICE_APLLY_TOPIC}")
    private String FSC_INVOICE_APLLY_TOPIC;
    @Value(value="${FSC_INVOICE_APPLY_TAG:*}")
    private String FSC_INVOICE_APPLY_TAG;
    @Value(value="${FSC_DOWN_TAKE_UP_ORDER_CREATE_TOPIC:FSC_DOWN_TAKE_UP_ORDER_CREATE_TOPIC}")
    private String FSC_DOWN_TAKE_UP_ORDER_CREATE_TOPIC;
    @Value(value="${FSC_DOWN_TAKE_UP_ORDER_CREATE_TAG:*}")
    private String FSC_DOWN_TAKE_UP_ORDER_CREATE_TAG;
    @Resource(name="fscInvoiceApplyProvider")
    private ProxyMessageProducer fscInvoiceApplyProvider;
    @Resource(name="fscDownTakeUpOrderCreateProvider")
    private ProxyMessageProducer fscDownTakeUpOrderCreateProvider;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService;
    private static final String ALLOW_DOWN_CREATE_FSC_ORDER = "1";
    private static final Integer GROUPWAY_NOSPLIT = 0;
    private static String UP;

    @BigDecimalConvert
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealCreate"})
    public FscBillOrderCreateAbilityRspBO dealCreate(@RequestBody FscBillOrderCreateAbilityReqBO reqBO) {
        this.val(reqBO, false);
        if (null == reqBO.getOrderFlow()) {
            reqBO.setOrderFlow(FscOrderFlowEnum.INVOICE.getCode());
        }
        ArrayList<Long> inspectionVoucherIdList = new ArrayList<Long>();
        for (SplitOrderBO splitOrderBO2 : reqBO.getSplitOrderList()) {
            if (null == splitOrderBO2.getAmount()) {
                throw new FscBusinessException("191014", "\u62c6\u5206\u91d1\u989d\u4e3a\u7a7a");
            }
            if (BigDecimal.ZERO.compareTo(splitOrderBO2.getAmount()) >= 0) {
                throw new FscBusinessException("191014", "\u62c6\u5206\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            splitOrderBO2.getRelOrderList().forEach(relOrderBO -> {
                if (null == relOrderBO.getAcceptOrderId()) {
                    if ("4".equals(reqBO.getOrderSource())) {
                        throw new FscBusinessException("191014", "\u53d1\u8d27\u5355ID\u4e3a\u7a7a");
                    }
                    if ("5".equals(reqBO.getOrderSource())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355ID\u4e3a\u7a7a");
                    }
                }
                inspectionVoucherIdList.add(relOrderBO.getAcceptOrderId());
            });
        }
        this.checkOrderBillStatus(reqBO, inspectionVoucherIdList);
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
        fscAcceptOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        }
        fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
        }
        fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscAcceptOrderListQueryAtomReqBO.setPurchaseType(reqBO.getPurchaseType());
        FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = new FscAcceptOrderListQueryAtomRspBO();
        if (reqBO.getIsAutoCreateOrder().booleanValue()) {
            fscAcceptOrderListQueryAtomRspBO.setFscOrderInfoBoMap(reqBO.getFscOrderInfoBoMap());
        } else {
            fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        }
        if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
            throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        FscOrderInfoBO fscOrderInfoBO = this.checkOrderParam(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap(), reqBO, false);
        reqBO.getSplitOrderList().forEach(splitOrderBO -> splitOrderBO.setAmount(splitOrderBO.getAmount().setScale(2, 4)));
        this.verifyIsExtPersonal(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap(), reqBO);
        if ("2".equals(reqBO.getOrderSource())) {
            this.checkResult(reqBO, inspectionVoucherIdList);
        }
        FscBillOrderCreateBusiReqBO fscBillOrderCreateBusiReqBO = (FscBillOrderCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderCreateBusiReqBO.class));
        fscBillOrderCreateBusiReqBO.setRelType(fscAcceptOrderListQueryAtomReqBO.getRelType());
        fscBillOrderCreateBusiReqBO.setSupplierName(fscOrderInfoBO.getSupplierName());
        fscBillOrderCreateBusiReqBO.setProOrgName(fscOrderInfoBO.getProOrgName());
        fscBillOrderCreateBusiReqBO.setPurchaserName(fscOrderInfoBO.getCompanyName());
        fscBillOrderCreateBusiReqBO.setPurchaserId(fscOrderInfoBO.getCompanyId());
        fscBillOrderCreateBusiReqBO.setAccountSetId(fscOrderInfoBO.getAccountSetId());
        fscBillOrderCreateBusiReqBO.setAccountSetName(fscOrderInfoBO.getAccountSetName());
        if (!StringUtils.isBlank((CharSequence)fscOrderInfoBO.getProOrgId())) {
            fscBillOrderCreateBusiReqBO.setProOrgId(Long.parseLong(fscOrderInfoBO.getProOrgId()));
        }
        fscBillOrderCreateBusiReqBO.setPayType(fscOrderInfoBO.getPayType());
        fscBillOrderCreateBusiReqBO.setFscOrderInfoBoMap(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap());
        fscBillOrderCreateBusiReqBO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        fscBillOrderCreateBusiReqBO.setBusiName(FscOrderFlowEnum.INVOICE.getDescr());
        fscBillOrderCreateBusiReqBO.setBusiCode(FscOrderFlowEnum.INVOICE.getCode().toString());
        fscBillOrderCreateBusiReqBO.setDealDesc(DEAL_DESC);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_START);
        fscBillOrderCreateBusiReqBO.setParamMap(paramMap);
        StringBuffer keySb = new StringBuffer();
        keySb.append(reqBO.getReceiveType());
        keySb.append(FscConstants.FscBusiModel.MATCHING);
        keySb.append(reqBO.getOrderSource());
        fscBillOrderCreateBusiReqBO.setOrderNos(this.getSerial(keySb.toString(), reqBO.getSplitOrderList().size()));
        this.setPayInfo(fscBillOrderCreateBusiReqBO);
        FscBillOrderCreateAbilityReqBO upReqBO = null;
        if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
            upReqBO = this.calAutoBillParam(reqBO, fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap());
        }
        fscBillOrderCreateBusiReqBO.setPurchaseType(reqBO.getPurchaseType());
        FscBillOrderCreateBusiRspBO fscBillOrderCreateBusiRspBO = this.fscBillOrderCreateBusiService.dealCreate(fscBillOrderCreateBusiReqBO);
        if (!"0000".equals(fscBillOrderCreateBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscBillOrderCreateBusiRspBO.getRespDesc());
        }
        this.sendMq(fscBillOrderCreateBusiRspBO, reqBO, upReqBO);
        return new FscBillOrderCreateAbilityRspBO();
    }

    private void val(FscBillOrderCreateAbilityReqBO reqBO, boolean isUp) {
        UP = isUp ? "\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u65f6\uff0c" : "";
        if (null == reqBO) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getMakeType()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
        if (!(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType()) || FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType()))) {
            throw new FscBusinessException("191000", UP + "\u5f00\u7968\u65b9\u53ea\u80fd\u4e3a\u7535\u5546\u3001\u4f9b\u5e94\u5546\u3001\u8fd0\u8425\u65b9");
        }
        if (null == reqBO.getReceiveType()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[purchaserId]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSource())) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[orderSource]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSplitOrderList())) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[splitOrderList]\u4e3a\u7a7a");
        }
        if (!ALLOW_DOWN_CREATE_FSC_ORDER.equals(reqBO.getMemUserType()) && null == reqBO.getTaxNo()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[taxNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getBuyName()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[buyName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRuleType()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[ruleType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCategory()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[invoiceCategory]\u4e3a\u7a7a");
        }
        if (!FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceCategory()) && !FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory())) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[invoiceCategory]\u53d1\u7968\u7c7b\u522b\u53ea\u80fd\u4e3a1\u62162");
        }
        if (FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceCategory()) && StringUtils.isBlank((CharSequence)reqBO.getReceiveEmail())) {
            throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7535\u7968\u65f6\uff0c\u6536\u7968\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getProvince())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[province]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getProvinceCode())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[provinceCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCity())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[city]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCityCode())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[cityCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getArea())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[area]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAreaCode())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[areaCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveAddr())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveAddr]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveName())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceivePhone())) {
                throw new FscBusinessException("191000", UP + "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receivePhone]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (null == reqBO.getInvoiceType()) {
            throw new FscBusinessException("191000", UP + "\u5165\u53c2[invoiceType]\u4e3a\u7a7a");
        }
    }

    private void verifyIsExtPersonal(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscBillOrderCreateAbilityReqBO reqBO) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FscCfcUniteParamQryListDetailExternalRspBO configuration = this.getConfiguration("ext_person_billing_time");
        String billingTime = configuration.getBillingTime();
        FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.values().stream().min(Comparator.comparing(FscOrderInfoBO::getInspectionTime)).get();
        GregorianCalendar cal = new GregorianCalendar();
        if (fscOrderInfoBO.getInspectionTime() != null) {
            cal.setTime(fscOrderInfoBO.getInspectionTime());
        }
        ((Calendar)cal).add(5, Integer.parseInt(billingTime));
        Date latestBillDate = cal.getTime();
        String latestBillDateStr = simpleDateFormat.format(latestBillDate);
        if (log.isDebugEnabled()) {
            log.debug("\u5916\u90e8\u4e2a\u4eba\u53ef\u5f00\u5177\u53d1\u7968\u65f6\u9650\uff0c\u4ece\u9a8c\u6536\u65e5\u8d77\uff1a{} \u5929\u5185", (Object)billingTime);
            log.debug("\u8ba2\u5355\u6700\u65e9\u9a8c\u6536\u65f6\u95f4\uff1a{} ", (Object)fscOrderInfoBO.getInspectionTime());
            log.debug("\u8ba2\u5355\u5f00\u5177\u53d1\u7968\u65f6\u9650\uff1a{} ", (Object)latestBillDateStr);
        }
        if (latestBillDate.getTime() < System.currentTimeMillis()) {
            throw new FscBusinessException("191014", StrUtil.format((CharSequence)"\u60a8\u9009\u62e9\u7684\u6570\u636e[{}]\u5df2\u8d85\u8fc7\u53d1\u8d77\u7ed3\u7b97\u5355\u65f6\u9650\u8d85\u8fc7\u53ef\u5f00\u5177\u53d1\u7968\u65f6\u9650{}\u5929\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406", (Object[])new Object[]{fscOrderInfoBO.getOrderNo(), billingTime}));
        }
    }

    private void checkResult(FscBillOrderCreateAbilityReqBO reqBO, List<Long> inspectionVoucherIdList) {
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType()) || FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
            FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
            fscCheckResultPO.setAcceptOrderIds(inspectionVoucherIdList);
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            Integer checkCount = this.fscCheckResultMapper.getCheckBy(fscCheckResultPO);
            log.info("\u5bf9\u8d26\u4e00\u81f4\u6570\u91cf:{}", (Object)checkCount);
            if (!checkCount.equals(inspectionVoucherIdList.size())) {
                throw new FscBusinessException("191014", "\u5bf9\u8d26\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5f00\u7968");
            }
        }
    }

    private FscCfcUniteParamQryListDetailExternalRspBO getConfiguration(String cfcParamCodes) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode(cfcParamCodes);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        return fscCfcUniteParamQryListDetailExternalRspBO;
    }

    private List<String> getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }

    private void sendMq(FscBillOrderCreateBusiRspBO fscBillOrderCreateBusiRspBO, FscBillOrderCreateAbilityReqBO reqBO, FscBillOrderCreateAbilityReqBO upReqBO) {
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
            JSONObject fscOrderIdJson = new JSONObject();
            fscOrderIdJson.put("orderIds", fscBillOrderCreateBusiRspBO.getFscOrderIds());
            this.fscInvoiceApplyProvider.send(new ProxyMessage(this.FSC_INVOICE_APLLY_TOPIC, this.FSC_INVOICE_APPLY_TAG, fscOrderIdJson.toJSONString()));
        }
        for (Long fscOrderId : fscBillOrderCreateBusiRspBO.getFscOrderIds()) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && Boolean.TRUE.equals(upReqBO.getAotuBillEnable())) {
            this.fscDownTakeUpOrderCreateProvider.send(new ProxyMessage(this.FSC_DOWN_TAKE_UP_ORDER_CREATE_TOPIC, this.FSC_DOWN_TAKE_UP_ORDER_CREATE_TAG, JSON.toJSONString((Object)upReqBO)));
        }
    }

    private FscOrderInfoBO checkOrderParam(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscBillOrderCreateAbilityReqBO reqBO, boolean isUp) {
        UP = isUp ? "\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u65f6\uff0c" : "";
        FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.get(((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId());
        if (null == fscOrderInfoBO) {
            throw new FscBusinessException("191014", UP + "\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + ((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        BigDecimal[] totalCharge = new BigDecimal[]{BigDecimal.ZERO};
        fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfo) -> {
            if (BigDecimal.ZERO.compareTo(fscOrderInfo.getInspTotalMoney()) >= 0) {
                throw new FscBusinessException("191014", UP + "\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + fscOrderInfo.getAcceptOrderNo() + "]\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u7ed3\u7b97");
            }
            totalCharge[0] = totalCharge[0].add(fscOrderInfo.getInspTotalMoney());
            if (!fscOrderInfoBO.getPayType().equals(fscOrderInfo.getPayType())) {
                throw new FscBusinessException("191014", UP + "\u8ba2\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                if (!fscOrderInfoBO.getCompanyId().equals(fscOrderInfo.getCompanyId())) {
                    throw new FscBusinessException("191014", UP + "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355");
                }
                if (null != fscOrderInfoBO.getAccountSetId() && !fscOrderInfoBO.getAccountSetId().equals(fscOrderInfo.getAccountSetId())) {
                    throw new FscBusinessException("191014", UP + "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u8d26\u5957\u7684\u8ba2\u5355");
                }
            }
            if (!FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && !fscOrderInfoBO.getSupplierId().equals(fscOrderInfo.getSupplierId())) {
                throw new FscBusinessException("191014", UP + "\u5f00\u7968\u65b9\u4e3a\u8fd0\u8425\u65b9\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u4f9b\u5e94\u5546\u7684\u8ba2\u5355");
            }
        });
        reqBO.getSplitOrderList().forEach(splitOrderBO -> {
            BigDecimal[] amount = new BigDecimal[]{BigDecimal.ZERO};
            splitOrderBO.getRelOrderList().forEach(relOrderBO -> {
                amount[0] = FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType()) || isUp ? amount[0].add(((FscOrderInfoBO)fscOrderInfoBoMap.get(relOrderBO.getAcceptOrderId())).getInspTotalPurchaseMoney()) : amount[0].add(((FscOrderInfoBO)fscOrderInfoBoMap.get(relOrderBO.getAcceptOrderId())).getInspTotalMoney());
            });
            if (amount[0].setScale(2, 4).compareTo(splitOrderBO.getAmount().setScale(2, 4)) != 0) {
                throw new FscBusinessException("191014", UP + "\u63d0\u4ea4\u8ba2\u5355\u91d1\u989d\u4e0e\u540e\u7aef\u4e0d\u4e00\u81f4");
            }
        });
        return fscOrderInfoBO;
    }

    private void setPayInfo(FscBillOrderCreateBusiReqBO fscBillOrderCreateBusiReqBO) {
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscBillOrderCreateBusiReqBO.getMakeType())) {
            fscBillOrderCreateBusiReqBO.setPayeeId(fscBillOrderCreateBusiReqBO.getProOrgId());
            fscBillOrderCreateBusiReqBO.setPayeeName(fscBillOrderCreateBusiReqBO.getProOrgName());
        } else {
            fscBillOrderCreateBusiReqBO.setPayeeId(fscBillOrderCreateBusiReqBO.getSupplierId());
            fscBillOrderCreateBusiReqBO.setPayeeName(fscBillOrderCreateBusiReqBO.getSupplierName());
        }
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscBillOrderCreateBusiReqBO.getReceiveType())) {
            fscBillOrderCreateBusiReqBO.setPayerId(fscBillOrderCreateBusiReqBO.getProOrgId());
            fscBillOrderCreateBusiReqBO.setPayerName(fscBillOrderCreateBusiReqBO.getProOrgName());
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscBillOrderCreateBusiReqBO.getReceiveType())) {
            fscBillOrderCreateBusiReqBO.setPayerId(fscBillOrderCreateBusiReqBO.getPurchaserId());
            fscBillOrderCreateBusiReqBO.setPayerName(fscBillOrderCreateBusiReqBO.getPurchaserName());
        }
        if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscBillOrderCreateBusiReqBO.getReceiveType())) {
            fscBillOrderCreateBusiReqBO.setPayerId(fscBillOrderCreateBusiReqBO.getSupplierId());
            fscBillOrderCreateBusiReqBO.setPayerName(fscBillOrderCreateBusiReqBO.getSupplierName());
        }
    }

    private FscBillOrderCreateAbilityReqBO calAutoBillParam(FscBillOrderCreateAbilityReqBO reqBO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap) {
        ArrayList<FscOrderInfoBO> fscOrderInfoBOS = new ArrayList<FscOrderInfoBO>(fscOrderInfoBoMap.values());
        FscBillOrderCreateAbilityReqBO fscBillOrderCreateAbilityReqBO = new FscBillOrderCreateAbilityReqBO();
        HashMap<Long, FscOrderInfoBO> fscOrderInfoMap = new HashMap<Long, FscOrderInfoBO>(16);
        fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfoBO) -> fscOrderInfoBO.getFscRelInfoBos().forEach(fscProFscRelInfoBo -> {
            if (FscConstants.FscRelType.PRO_INVOICE.equals(fscProFscRelInfoBo.getRelType()) && FscConstants.FscRelStatus.UNCOMMITTED.equals(fscProFscRelInfoBo.getRelState())) {
                fscOrderInfoMap.put((Long)acceptOrderId, (FscOrderInfoBO)fscOrderInfoBO);
            }
        }));
        if (CollectionUtils.isEmpty(fscOrderInfoMap)) {
            fscBillOrderCreateAbilityReqBO.setAotuBillEnable(Boolean.valueOf(false));
            return fscBillOrderCreateAbilityReqBO;
        }
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO = this.checkInvoiceParam(fscOrderInfoBOS.get(0).getProOrgId());
        fscBillOrderCreateAbilityReqBO.setUserId(reqBO.getUserId());
        fscBillOrderCreateAbilityReqBO.setName(reqBO.getName());
        fscBillOrderCreateAbilityReqBO.setOrgId(reqBO.getOrgId());
        fscBillOrderCreateAbilityReqBO.setOrgName(reqBO.getOrgName());
        fscBillOrderCreateAbilityReqBO.setCompanyId(reqBO.getCompanyId());
        fscBillOrderCreateAbilityReqBO.setCompanyName(reqBO.getCompanyName());
        fscBillOrderCreateAbilityReqBO.setRuleType(GROUPWAY_NOSPLIT);
        fscBillOrderCreateAbilityReqBO.setOrderFlow(reqBO.getOrderFlow());
        if ("2".equals(reqBO.getOrderSource())) {
            fscBillOrderCreateAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE);
        } else {
            fscBillOrderCreateAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.SUPPLIER);
        }
        fscBillOrderCreateAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        fscBillOrderCreateAbilityReqBO.setOrderSource(reqBO.getOrderSource());
        fscBillOrderCreateAbilityReqBO.setSupplierName(reqBO.getSupplierName());
        fscBillOrderCreateAbilityReqBO.setSupplierId(reqBO.getSupplierId());
        fscBillOrderCreateAbilityReqBO.setPurchaserId(reqBO.getPurchaserId());
        fscBillOrderCreateAbilityReqBO.setMaxCharge(reqBO.getMaxCharge());
        fscBillOrderCreateAbilityReqBO.setMaxOrderCount(reqBO.getMaxOrderCount());
        fscBillOrderCreateAbilityReqBO.setBuyName(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getInvoiceTitle());
        fscBillOrderCreateAbilityReqBO.setInvoiceType(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getInvoiceType());
        fscBillOrderCreateAbilityReqBO.setInvoiceCategory(Integer.valueOf(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getInvoiceClass()));
        fscBillOrderCreateAbilityReqBO.setTaxNo(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getTaxpayerId());
        fscBillOrderCreateAbilityReqBO.setBank(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getBank());
        fscBillOrderCreateAbilityReqBO.setBank(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getBank());
        fscBillOrderCreateAbilityReqBO.setAccount(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getAccount());
        fscBillOrderCreateAbilityReqBO.setAddress(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getAddress());
        fscBillOrderCreateAbilityReqBO.setPhone(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getPhone());
        fscBillOrderCreateAbilityReqBO.setReceiveName(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getContactNameWeb());
        fscBillOrderCreateAbilityReqBO.setReceiveAddr(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getAddrDesc());
        fscBillOrderCreateAbilityReqBO.setReceivePhone(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTel());
        fscBillOrderCreateAbilityReqBO.setReceiveEmail(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getElcInvoiceEmail());
        fscBillOrderCreateAbilityReqBO.setTownCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTownId());
        fscBillOrderCreateAbilityReqBO.setTown(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTownName());
        fscBillOrderCreateAbilityReqBO.setAreaCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCountyId());
        fscBillOrderCreateAbilityReqBO.setArea(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCountyName());
        fscBillOrderCreateAbilityReqBO.setCityCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCityId());
        fscBillOrderCreateAbilityReqBO.setCity(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCityName());
        fscBillOrderCreateAbilityReqBO.setProvinceCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getProvinceId());
        fscBillOrderCreateAbilityReqBO.setProvince(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getProvinceName());
        fscBillOrderCreateAbilityReqBO.setSplitOrderList(reqBO.getSplitOrderList());
        ArrayList<SplitOrderBO> splitOrderList = new ArrayList<SplitOrderBO>();
        BigDecimal totalPurAmt = fscOrderInfoMap.values().stream().map(FscOrderInfoBO::getInspTotalPurchaseMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        SplitOrderBO splitOrderBO = new SplitOrderBO();
        splitOrderBO.setAmount(totalPurAmt);
        splitOrderBO.setOrderNum(Integer.valueOf(fscOrderInfoMap.size()));
        ArrayList<RelOrderBO> relOrderList = new ArrayList<RelOrderBO>();
        for (FscOrderInfoBO fscOrderInfoBO2 : fscOrderInfoMap.values()) {
            RelOrderBO relOrderBO = new RelOrderBO();
            relOrderBO.setOrderId(fscOrderInfoBO2.getOrderId());
            relOrderBO.setAcceptOrderId(fscOrderInfoBO2.getAcceptOrderId());
            relOrderList.add(relOrderBO);
        }
        splitOrderBO.setRelOrderList(relOrderList);
        splitOrderList.add(splitOrderBO);
        fscBillOrderCreateAbilityReqBO.setSplitOrderList(splitOrderList);
        this.val(fscBillOrderCreateAbilityReqBO, true);
        if (log.isDebugEnabled()) {
            log.debug("\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u4e0a\u6e38\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscBillOrderCreateAbilityReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!CollectionUtils.isEmpty(fscOrderInfoMap)) {
            this.checkOrderParam(fscOrderInfoMap, fscBillOrderCreateAbilityReqBO, true);
            fscBillOrderCreateAbilityReqBO.setAotuBillEnable(Boolean.valueOf(true));
        }
        return fscBillOrderCreateAbilityReqBO;
    }

    private FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO checkInvoiceParam(String orgId) {
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO = new FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO();
        fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO.setOrgId(Long.valueOf(orgId));
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO = this.fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService.qryMain(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO);
        if (!"0000".equals(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getRespDesc());
        }
        if (null == fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO()) {
            throw new FscBusinessException("191014", "\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u65f6\uff0c\u4e0a\u6e38\u9ed8\u8ba4\u53d1\u7968\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO()) {
            throw new FscBusinessException("191014", "\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u65f6\uff0c\u4e0a\u6e38\u9ed8\u8ba4\u6536\u7968\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO;
    }

    private void checkOrderBillStatus(FscBillOrderCreateAbilityReqBO reqBO, List<Long> inspectionVoucherIdList) {
        List fscOrderIds;
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setAcceptOrderIds(inspectionVoucherIdList);
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS) && !CollectionUtils.isEmpty(fscOrderIds = fscOrderRelationPOS.stream().map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList()))) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIds);
            fscOrderPO.setRemoveState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
            List fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
                fscOrderPOS.forEach(fscOrder -> {
                    if (reqBO.getReceiveType().equals(fscOrder.getReceiveType()) && reqBO.getMakeType().equals(fscOrder.getMakeType())) {
                        throw new FscBusinessException("191014", "\u5b58\u5728\u8ba2\u5355\u6216\u53d1\u8d27\u5355\u5df2\u53d1\u8d77\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u7ed3\u7b97");
                    }
                });
            }
        }
    }
}

