/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComOrderListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderListQueryAbilityService"})
public class FscComOrderListQueryAbilityServiceImpl
implements FscComOrderListQueryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;

    @BigDecimalConvert
    @PostMapping(value={"qryOrderList"})
    public FscComOrderListQueryAbilityRspBO qryOrderList(@RequestBody FscComOrderListQueryAbilityReqBO reqBO) {
        FscOrderPO fscOrderPo = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderPO.class);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        List fscOrderPOS = this.fscOrderMapper.getFscOrderInvoiceListPage(fscOrderPo, page);
        if (CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
            return new FscComOrderListQueryAbilityRspBO();
        }
        ArrayList fscOrderIds = new ArrayList();
        fscOrderPOS.forEach(fscOrderPO -> fscOrderIds.add(fscOrderPO.getFscOrderId()));
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderIds(fscOrderIds);
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        HashMap attUrlMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            fscAttachmentPOS.forEach(fscAttachment -> {
                if (null == attUrlMap.get(fscAttachment.getFscOrderId())) {
                    ArrayList<String> urls = new ArrayList<String>();
                    urls.add(fscAttachment.getAttachmentUrl());
                    attUrlMap.put(fscAttachment.getFscOrderId(), urls);
                } else {
                    ((List)attUrlMap.get(fscAttachment.getFscOrderId())).add(fscAttachment.getAttachmentUrl());
                }
            });
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(fscOrderIds);
        List fscOrderRelationCounts = this.fscOrderRelationMapper.getCheckByFscOrderIdGroupBy(fscOrderRelationPo);
        HashMap orderCountMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationCounts)) {
            fscOrderRelationCounts.forEach(fscOrderRelation -> orderCountMap.put(fscOrderRelation.getFscOrderId(), fscOrderRelation.getOrderCount()));
        }
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderIds(fscOrderIds);
        List fscInvoicePOS = this.fscInvoiceMapper.getSumByFscOrderIdGroupBy(fscInvoicePo);
        HashMap invoiceAmtMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            fscInvoicePOS.forEach(fscInvoice -> invoiceAmtMap.put(fscInvoice.getFscOrderId(), fscInvoice.getAmt()));
        }
        Map orderType = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        Map buildActionMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUILD_ACTION");
        Map orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_STATE");
        List fscComOrderListBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscOrderPOS), FscComOrderListBO.class);
        for (FscComOrderListBO fscComOrderListBO : fscComOrderListBOS) {
            fscComOrderListBO.setOrderTypeStr((String)orderType.get(fscComOrderListBO.getOrderType()));
            fscComOrderListBO.setBuildActionStr((String)buildActionMap.get(fscComOrderListBO.getBuildAction()));
            fscComOrderListBO.setOrderStateStr((String)orderStateMap.get(fscComOrderListBO.getOrderState()));
            fscComOrderListBO.setAttachmentList((List)attUrlMap.get(fscComOrderListBO.getFscOrderId()));
            fscComOrderListBO.setPayEvidenceUrls((List)attUrlMap.get(fscComOrderListBO.getFscOrderId()));
            fscComOrderListBO.setOrderNum((Integer)orderCountMap.get(fscComOrderListBO.getFscOrderId()));
            fscComOrderListBO.setTotalChargeBill((BigDecimal)invoiceAmtMap.get(fscComOrderListBO.getFscOrderId()));
        }
        FscComOrderListQueryAbilityRspBO rspBO = new FscComOrderListQueryAbilityRspBO();
        rspBO.setRows(fscComOrderListBOS);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }
}

