/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.bo.FscSkuCategoryBO;
import com.tydic.fsc.busibase.external.api.ucc.FscUccCategoryatthefrontdeskQryService;
import com.tydic.fsc.busibase.external.api.ucc.bo.FscUccCategoryatthefrontdeskQryReqBO;
import com.tydic.fsc.busibase.external.api.ucc.bo.FscUccCategoryatthefrontdeskQryRspBO;
import com.tydic.fsc.busibase.external.api.ucc.bo.FscUccGuideCatalogTreeMapBO;
import com.tydic.fsc.common.ability.api.FscMerchantSkuCategoryListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantSkuCategoryListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantSkuCategoryListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscSkuCategoryMapper;
import com.tydic.fsc.po.FscSkuCategoryPO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantSkuCategoryListQueryAbilityService"})
public class FscMerchantSkuCategoryListQueryAbilityServiceImpl
implements FscMerchantSkuCategoryListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantSkuCategoryListQueryAbilityServiceImpl.class);
    private static final Integer CATEGORY_STATUS_VALID = 1;
    @Autowired
    private FscSkuCategoryMapper fscSkuCategoryMapper;
    @Autowired
    private FscUccCategoryatthefrontdeskQryService fscUccCategoryatthefrontdeskQryService;

    @PostMapping(value={"querySkuCategory"})
    public FscMerchantSkuCategoryListQueryAbilityRspBO querySkuCategory(@RequestBody FscMerchantSkuCategoryListQueryAbilityReqBO reqBO) {
        FscMerchantSkuCategoryListQueryAbilityRspBO retBo = (FscMerchantSkuCategoryListQueryAbilityRspBO)FscRspUtil.getSuccessRspBo(FscMerchantSkuCategoryListQueryAbilityRspBO.class);
        FscUccCategoryatthefrontdeskQryReqBO uccReqBo = new FscUccCategoryatthefrontdeskQryReqBO();
        uccReqBo.setCatalogStatus(CATEGORY_STATUS_VALID);
        FscUccCategoryatthefrontdeskQryRspBO uccRetBo = this.fscUccCategoryatthefrontdeskQryService.queryCategory(uccReqBo);
        if (!"0000".equals(uccRetBo.getRespCode()) || CollectionUtils.isEmpty((Map)uccRetBo.getTreeMap())) {
            log.error("\u8c03\u7528\u5546\u54c1\u67e5\u8be2\u7c7b\u76ee\u5931\u8d25\uff1a{}", (Object)uccRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)uccRetBo, (Object)retBo);
            return retBo;
        }
        ArrayList<FscSkuCategoryBO> allSkuCategory = new ArrayList<FscSkuCategoryBO>();
        this.treeMapToList(allSkuCategory, uccRetBo.getTreeMap());
        retBo.setAllSkuCategory(allSkuCategory);
        Collection categories = null;
        if (null != reqBO.getMerchantId()) {
            FscSkuCategoryPO qryPo = new FscSkuCategoryPO();
            qryPo.setMerchantId(reqBO.getMerchantId());
            categories = this.fscSkuCategoryMapper.getList(qryPo);
        }
        List<Object> selectedBottommostId = new ArrayList();
        if (!CollectionUtils.isEmpty(categories)) {
            selectedBottommostId = categories.stream().map(FscSkuCategoryPO::getCategoryTreePath).collect(Collectors.toList());
        }
        retBo.setSelectedBottommostId(selectedBottommostId);
        return retBo;
    }

    private void deFilter(List<FscSkuCategoryBO> unSelected, List<FscSkuCategoryBO> selected, List<FscSkuCategoryPO> categories, Map<Long, FscUccGuideCatalogTreeMapBO> uccTreeMap) {
        HashMap<String, Object> selectedTreeMap = new HashMap<String, Object>(16);
        for (FscSkuCategoryPO categoryPo : categories) {
            LinkedList<String> categoryTreeList = new LinkedList<String>(Arrays.asList(categoryPo.getCategoryTreePath().split(",")));
            this.getTreeMap(selectedTreeMap, categoryTreeList);
        }
        this.traverseSelectedTreeMap(selected, selectedTreeMap, uccTreeMap);
        this.treeMapToList(unSelected, uccTreeMap);
    }

    private void getTreeMap(Map<String, Object> treeMap, LinkedList<String> categoryTreeList) {
        if (!categoryTreeList.isEmpty()) {
            HashMap<String, Object> childMap;
            String categoryId = categoryTreeList.removeFirst();
            if (categoryTreeList.isEmpty()) {
                treeMap.put(categoryId, categoryId);
                return;
            }
            try {
                childMap = (HashMap<String, Object>)treeMap.get(categoryId);
            }
            catch (Exception e) {
                childMap = new HashMap<String, Object>(1);
            }
            if (null == childMap) {
                childMap = new HashMap(1);
            }
            treeMap.put(categoryId, childMap);
            this.getTreeMap(childMap, categoryTreeList);
        }
    }

    private void traverseSelectedTreeMap(List<FscSkuCategoryBO> selected, Map<String, Object> selectedTreeMap, Map<Long, FscUccGuideCatalogTreeMapBO> uccTreeMap) {
        for (Map.Entry<String, Object> entry : selectedTreeMap.entrySet()) {
            Map childMap;
            Long categoryId = Long.valueOf(entry.getKey());
            FscUccGuideCatalogTreeMapBO catalogTreeMapBO = uccTreeMap.get(categoryId);
            if (null == catalogTreeMapBO) continue;
            FscSkuCategoryBO selectedBo = new FscSkuCategoryBO();
            BeanUtils.copyProperties((Object)catalogTreeMapBO, (Object)selectedBo);
            ArrayList<FscSkuCategoryBO> child = new ArrayList<FscSkuCategoryBO>();
            selectedBo.setChilds(child);
            selected.add(selectedBo);
            try {
                childMap = (Map)entry.getValue();
            }
            catch (Exception e) {
                Map uccChildMap = uccTreeMap.remove(categoryId).getChildMap();
                if (CollectionUtils.isEmpty((Map)uccChildMap)) continue;
                this.treeMapToList(child, uccChildMap);
                continue;
            }
            this.traverseSelectedTreeMap(child, childMap, catalogTreeMapBO.getChildMap());
        }
    }

    private void treeMapToList(List<FscSkuCategoryBO> target, Map<Long, FscUccGuideCatalogTreeMapBO> source) {
        for (Map.Entry<Long, FscUccGuideCatalogTreeMapBO> entry : source.entrySet()) {
            FscUccGuideCatalogTreeMapBO uccBo = entry.getValue();
            FscSkuCategoryBO categoryBo = new FscSkuCategoryBO();
            BeanUtils.copyProperties((Object)uccBo, (Object)categoryBo);
            ArrayList<FscSkuCategoryBO> childCategories = new ArrayList<FscSkuCategoryBO>();
            categoryBo.setChilds(childCategories);
            target.add(categoryBo);
            if (CollectionUtils.isEmpty((Map)uccBo.getChildMap())) continue;
            this.treeMapToList(childCategories, uccBo.getChildMap());
        }
    }
}

