/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.busibase.atom.api.FscOrderCancelAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderRelUpdateAbilityService;
import com.tydic.fsc.common.busi.api.FscComOrderApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderApprovalBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscComOrderApprovalBusiServiceImpl
implements FscComOrderApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderApprovalBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderCancelAtomService fscOrderCancelAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscUocOrderRelUpdateAbilityService fscUocOrderRelUpdateAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    public static final String PASS = "0";
    public static final Integer SERVICE_FEE_UOC = 2;
    public static final Integer SERVICE_FEE_UOC_STATE = 0;
    public static final String BUSI_NAME = "\u4e3b\u5355\u5ba1\u6279";
    public static final String BUSI_CODE = "1009";

    @Override
    public FscComOrderApprovalBusiRspBO dealOrderApproval(FscComOrderApprovalBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        if (finish.booleanValue()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            if (PASS.equals(auditResult)) {
                if (null != reqBO.getActualAmount() && BigDecimal.ZERO.compareTo(reqBO.getActualAmount()) == 0) {
                    paramMap.put("orderFinish", "1");
                } else {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                }
            } else {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
            }
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(reqBO.getOrderId());
            flowAtomReqBO.setCurStatus(reqBO.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setBusiCode(BUSI_CODE);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
            }
            if (!PASS.equals(auditResult)) {
                reqBO.setOrderState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
                this.dismissalProcess(reqBO);
            } else {
                this.updateMaxConfirmTime(reqBO);
            }
        }
        return new FscComOrderApprovalBusiRspBO();
    }

    private void updateMaxConfirmTime(FscComOrderApprovalBusiReqBO reqBO) {
        if (!FscConstants.OrderFlow.INVOICE.equals(reqBO.getFscOrder().getOrderFlow()) && !FscConstants.OrderFlow.PAY.equals(reqBO.getFscOrder().getOrderFlow())) {
            FscOrderPO fscOrder = new FscOrderPO();
            fscOrder.setFscOrderId(reqBO.getFscOrder().getFscOrderId());
            fscOrder.setCreditConfirmDueDate(DateUtils.getDate((Date)new Date(), (Integer)Convert.toInt((Object)reqBO.getFscOrder().getCreditConfirmDueDay(), (Integer)1)));
            this.fscOrderMapper.updateById(fscOrder);
        }
    }

    private void dismissalProcess(FscComOrderApprovalBusiReqBO reqBO) {
        if (FscConstants.OrderFlow.PAY.equals(reqBO.getOrderFlow())) {
            this.paymentRejectionProcess(reqBO);
        } else if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            this.serviceFeeRejectionProcess(reqBO);
            FscOrderCancelAtomReqBO cancelAtomReqBO = new FscOrderCancelAtomReqBO();
            cancelAtomReqBO.setOrderFlow(reqBO.getOrderFlow());
            cancelAtomReqBO.setOrderId(reqBO.getOrderId());
            cancelAtomReqBO.setOrderState(reqBO.getOrderState());
            FscOrderCancelAtomRspBO cancelAtomRspBO = this.fscOrderCancelAtomService.dealCancelStatus(cancelAtomReqBO);
            if (!"0000".equals(cancelAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193108", cancelAtomRspBO.getRespDesc());
            }
        }
    }

    private void serviceFeeRejectionProcess(FscComOrderApprovalBusiReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        set.setCreditAmount(BigDecimal.ZERO);
        set.setFscOrderId(reqBO.getOrderId());
        int i = this.fscOrderMapper.updateByOrderId(set);
        if (i != 1) {
            throw new FscBusinessException("193108", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
        }
    }

    private void paymentRejectionProcess(FscComOrderApprovalBusiReqBO reqBO) {
        FscOrderPayItemPO fscOrderPayItemPo = new FscOrderPayItemPO();
        fscOrderPayItemPo.setFscOrderId(reqBO.getOrderId());
        List fscOrderPayItemPos = this.fscOrderPayItemMapper.getList(fscOrderPayItemPo);
        for (FscOrderPayItemPO orderPayItemPo : fscOrderPayItemPos) {
            int i = this.fscShouldPayMapper.updatePayingAmt(orderPayItemPo.getShouldPayId(), orderPayItemPo.getPayAmount());
            if (i == 1) continue;
            throw new FscBusinessException("193108", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
        }
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscComOrderApprovalBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.PAY_APPLY_ORDER.equals(reqBO.getOrderFlow()) ? FscConstants.AuditObjType.PAY_APPLY_ORDER : FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL;
        String stepId = this.fscOrderMapper.selectStepId(reqBO.getOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(paramMap);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }
}

