/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComErpPayOffAbilityService;
import com.tydic.fsc.common.ability.bo.FscComErpPayOffAbilityReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderShouldPayItemPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.AesUtil;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.umc.general.ability.api.UmcCommonCheckPaymentPasswordAbilityService;
import com.tydic.umc.general.ability.bo.UmcCommonCheckPaymentPasswordAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcCommonCheckPaymentPasswordAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillAtomServiceImpl
implements FscPayBillAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillAtomServiceImpl.class);
    @Value(value="${fscPayNotifyUrl}")
    private String notifyUrl;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.req.way:1}")
    private String reqWay;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private UmcCommonCheckPaymentPasswordAbilityService umcCommonCheckPaymentPasswordAbilityService;
    @Autowired
    private FscComErpPayOffAbilityService fscComErpPayOffAbilityService;
    @Value(value="${login.originalKey:12345678901234561234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${MERCHANT_ORG_ID}")
    private Long merchantOrgId;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @Override
    public FscPayBillAtomRspBO dealPayBill(FscPayBillAtomReqBO atomReqBO) {
        FscOrderPO modelBy = this.getFscOrderPO(atomReqBO);
        FscPayBillAtomRspBO atomRspBO = new FscPayBillAtomRspBO();
        this.validStatsAndAmount(atomReqBO);
        FscOrderPO set = new FscOrderPO();
        if ("3".equals(atomReqBO.getPayType().toString())) {
            this.createPayOrder(atomReqBO);
            set.setPayTime(new Date());
            if (!atomReqBO.getPayConfirmFlag().booleanValue()) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
                FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setFscOrderIds(atomReqBO.getFscOrderIds());
                List pos = this.fscOrderPayItemMapper.getListForDealPaySuccess(fscOrderPayItemPO);
                for (FscOrderShouldPayItemPO po : pos) {
                    if (!FscConstants.ShouldPayType.PALATFORM_USE_PAY.equals(po.getShouldPayType()) && !FscConstants.ShouldPayType.DEAL_PAY.equals(po.getShouldPayType())) continue;
                    FscOrderPO orderPoSet = new FscOrderPO();
                    orderPoSet.setOrderType(atomReqBO.getIsAutoApplyInvoice());
                    FscOrderPO orderPoWhere = new FscOrderPO();
                    orderPoWhere.setFscOrderId(po.getObjectId());
                    int update = this.fscOrderMapper.updateBy(orderPoSet, orderPoWhere);
                    if (update < 1) {
                        throw new FscBusinessException("8888", "\u4e3b\u5355\u66f4\u65b0\u5931\u8d25");
                    }
                    this.invokeFscOrderStatusFlow(po.getObjectId(), paramMap, FscConstants.FscServiceOrderState.TO_PAY);
                }
                if (((FscOrderShouldPayItemPO)pos.get(0)).getShouldPayType().equals(FscConstants.ShouldPayType.PALATFORM_USE_PAY) || ((FscOrderShouldPayItemPO)pos.get(0)).getShouldPayType().equals(FscConstants.ShouldPayType.DEAL_PAY)) {
                    atomRspBO.setResultFscOrderIds(pos.stream().map(FscOrderShouldPayItemPO::getObjectId).collect(Collectors.toList()));
                }
            }
        } else if ("0".equals(atomReqBO.getPayType().toString())) {
            if (modelBy.getBusiCategory().equals(FscConstants.FscOrderBusiCategory.PAY)) {
                Long payOrderId = this.createPayOrder(atomReqBO);
                String url = this.invokePayProOrder(atomReqBO, payOrderId);
                atomRspBO.setUrl(url);
            } else if (modelBy.getBusiCategory().equals(FscConstants.FscOrderBusiCategory.REFUND)) {
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setShouldPayId(atomReqBO.getShouldPayId());
                FscShouldPayPO fscShouldPayMapperModelBy = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
                if (fscShouldPayMapperModelBy == null) {
                    throw new FscBusinessException("8888", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
                }
                FscShouldPayPO fscShouldPayPoOrder = new FscShouldPayPO();
                fscShouldPayPoOrder.setOrderId(fscShouldPayMapperModelBy.getOrderId());
                Long fscPayOrderIdByShouldPayId = this.fscShouldPayMapper.getFscPayOrderIdByShouldPayId(fscShouldPayPoOrder);
                if (fscPayOrderIdByShouldPayId == null) {
                    throw new FscBusinessException("8888", "\u67e5\u8be2\u4ed8\u6b3e\u65f6\u5916\u90e8\u8ba2\u5355\u6d41\u6c34\u4e3a\u7a7a");
                }
                Long payOrderId = this.createPayOrder(atomReqBO);
                PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
                payProRefundAbilityReqBo.setBusiCode(this.payBusiCode);
                payProRefundAbilityReqBo.setRefundOutOrderId(payOrderId.toString());
                payProRefundAbilityReqBo.setOriOutOrderId(fscPayOrderIdByShouldPayId.toString());
                payProRefundAbilityReqBo.setRefundFee(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01")) + "");
                PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
                if (!payProRefundAbilityRspBo.getRespCode().equals("0000")) {
                    throw new FscBusinessException("8888", "\u9000\u6b3e\u5931\u8d25");
                }
            }
        } else if ("2".equals(atomReqBO.getPayType().toString())) {
            this.createPayOrder(atomReqBO);
        } else if ("1".equals(atomReqBO.getPayType().toString())) {
            this.createPayOrder(atomReqBO);
        }
        set.setPayOperName(atomReqBO.getName());
        set.setPayOperId(atomReqBO.getUserName());
        if (!"0".equals(atomReqBO.getPayType().toString())) {
            set.setPayState(Integer.valueOf(2));
        }
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(atomReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        if (!CollectionUtils.isEmpty(atomReqBO.getFscAttachmentBOS())) {
            this.insertFscAttachment(atomReqBO);
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u652f\u4ed8\u8c03\u7528\u6210\u529f");
        atomRspBO.setBusiCategory(modelBy.getBusiCategory());
        return atomRspBO;
    }

    private void sendMq(Long fscOrderId, FscPayBillAtomReqBO reqBO) {
        FscComErpPayOffAbilityReqBo fscComErpPayOffAbilityReqBo = new FscComErpPayOffAbilityReqBo();
        fscComErpPayOffAbilityReqBo.setFscOrderId(fscOrderId);
        fscComErpPayOffAbilityReqBo.setUserId(reqBO.getUserId());
        fscComErpPayOffAbilityReqBo.setUserName(reqBO.getUserName());
        this.fscComErpPayOffAbilityService.dealErpPayOff(fscComErpPayOffAbilityReqBo);
    }

    private FscOrderPO getFscOrderPO(FscPayBillAtomReqBO atomReqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(atomReqBO.getFscOrderIds().get(0));
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(orderPO);
        if (modelBy == null) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (modelBy.getBusiCategory() == null) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u6536\u9000\u6b3e\u7c7b\u522b\u4fe1\u606f\u4e3a\u7a7a");
        }
        return modelBy;
    }

    private void dealAccountPeriod(FscPayBillAtomReqBO atomReqBO, FscOrderPO set) {
        log.debug("\u5bc6\u6587:{}", (Object)atomReqBO.getPassword());
        log.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
        String pwd = AesUtil.decryptStr((String)atomReqBO.getPassword(), (String)this.ORIGINAL_KEY);
        log.debug("\u660e\u6587:{}", (Object)pwd);
        if (StringUtils.isEmpty((Object)pwd)) {
            throw new ZTBusinessException("\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        }
        UmcCommonCheckPaymentPasswordAbilityReqBO umcCommonCheckPaymentPasswordAbilityReqBO = new UmcCommonCheckPaymentPasswordAbilityReqBO();
        umcCommonCheckPaymentPasswordAbilityReqBO.setOrgIdIn(atomReqBO.getPayerId());
        umcCommonCheckPaymentPasswordAbilityReqBO.setPaymentPassword(pwd);
        UmcCommonCheckPaymentPasswordAbilityRspBO umcCommonCheckPaymentPasswordAbilityRspBO = this.umcCommonCheckPaymentPasswordAbilityService.checkPaymentPassword(umcCommonCheckPaymentPasswordAbilityReqBO);
        if (!"0000".equals(umcCommonCheckPaymentPasswordAbilityRspBO.getRespCode())) {
            throw new FscBusinessException(umcCommonCheckPaymentPasswordAbilityRspBO.getRespCode(), umcCommonCheckPaymentPasswordAbilityRspBO.getRespDesc());
        }
        set.setPayTime(new Date());
    }

    private void dealPreDeposit(FscPayBillAtomReqBO atomReqBO, FscOrderPO set) {
        log.debug("\u5bc6\u6587:{}", (Object)atomReqBO.getPassword());
        log.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
        String pwd = AesUtil.decryptStr((String)atomReqBO.getPassword(), (String)this.ORIGINAL_KEY);
        log.debug("\u660e\u6587:{}", (Object)pwd);
        if (StringUtils.isEmpty((Object)pwd)) {
            throw new ZTBusinessException("\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        }
        UmcCommonCheckPaymentPasswordAbilityReqBO umcCommonCheckPaymentPasswordAbilityReqBO = new UmcCommonCheckPaymentPasswordAbilityReqBO();
        umcCommonCheckPaymentPasswordAbilityReqBO.setOrgIdIn(atomReqBO.getPayerId());
        umcCommonCheckPaymentPasswordAbilityReqBO.setPaymentPassword(pwd);
        UmcCommonCheckPaymentPasswordAbilityRspBO umcCommonCheckPaymentPasswordAbilityRspBO = this.umcCommonCheckPaymentPasswordAbilityService.checkPaymentPassword(umcCommonCheckPaymentPasswordAbilityReqBO);
        if (!"0000".equals(umcCommonCheckPaymentPasswordAbilityRspBO.getRespCode())) {
            throw new FscBusinessException(umcCommonCheckPaymentPasswordAbilityRspBO.getRespCode(), umcCommonCheckPaymentPasswordAbilityRspBO.getRespDesc());
        }
        set.setPayTime(new Date());
    }

    private void insertFscAttachment(FscPayBillAtomReqBO busiReqBO) {
        ArrayList<Long> fscOrderIds = this.fscOrderMapper.getPayOrderRelationFscOrder(busiReqBO.getFscOrderIds());
        if (CollectionUtils.isEmpty((Collection)fscOrderIds)) {
            fscOrderIds = new ArrayList<Long>();
        }
        fscOrderIds.addAll(busiReqBO.getFscOrderIds());
        ArrayList fscAttachmentPOS = new ArrayList();
        fscOrderIds.forEach(fscOrderId -> busiReqBO.getFscAttachmentBOS().forEach(fscAttachmentBO -> {
            FscAttachmentPO po = new FscAttachmentPO();
            po.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setAttachmentName(fscAttachmentBO.getAttachmentName());
            po.setAttachmentType(fscAttachmentBO.getAttachmentType());
            po.setAttachmentUrl(fscAttachmentBO.getAttachmentUrl());
            po.setObjType(FscConstants.FscAttachmentObjType.ORDER);
            po.setObjId(fscOrderId);
            po.setFscOrderId(fscOrderId);
            fscAttachmentPOS.add(po);
        }));
        this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
    }

    private Long createPayOrder(FscPayBillAtomReqBO busiReqBO) {
        Long payOrderId = Sequence.getInstance().nextId();
        FscPayOrderPO po = new FscPayOrderPO();
        po.setPayOrderId(payOrderId);
        po.setPayChannel(busiReqBO.getPayChannel());
        po.setPayAmount(busiReqBO.getTotalAmount());
        po.setCreateTime(new Date());
        po.setPayMethod(busiReqBO.getPayMethod());
        po.setPayStatus(FscConstants.PayOrderPayStatus.TO_PAY);
        this.fscPayOrderMapper.insert(po);
        ArrayList fscPayRelationPOS = new ArrayList();
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            FscPayRelationPO po1 = new FscPayRelationPO();
            po1.setId(Long.valueOf(Sequence.getInstance().nextId()));
            po1.setFscOrderId(fscOrderId);
            po1.setPayOrderId(payOrderId);
            fscPayRelationPOS.add(po1);
        });
        this.fscPayRelationMapper.insertBatch(fscPayRelationPOS);
        return payOrderId;
    }

    private void invokeFscOrderStatusFlow(FscPayBillAtomReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (busiReqBO.getPayConfirmFlag().booleanValue()) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        } else {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }

    private void invokeFscOrderStatusFlow(Long fscOrderId, Map<String, Object> paramMap, Integer curStatus) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(curStatus);
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private String invokePayProOrder(FscPayBillAtomReqBO busiReqBO, Long payOrderId) {
        FscMerchantPO reqPO = new FscMerchantPO();
        reqPO.setOrgId(this.merchantOrgId);
        reqPO.setExceptionFlag(Integer.valueOf(0));
        reqPO.setDelFlag(Integer.valueOf(0));
        FscMerchantPO rspPO = this.fscMerchantMapper.getModelBy(reqPO);
        if (null == rspPO) {
            throw new FscBusinessException("194202", "\u6536\u6b3e\u65b9\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
        payProOrderAbilityServiceReqBo.setBusiCode(this.payBusiCode);
        payProOrderAbilityServiceReqBo.setReqWay(this.reqWay);
        payProOrderAbilityServiceReqBo.setOutOrderId(payOrderId.toString());
        payProOrderAbilityServiceReqBo.setMerchantId(rspPO.getPayMerchantId());
        payProOrderAbilityServiceReqBo.setTotalFee(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01")) + "");
        payProOrderAbilityServiceReqBo.setDetailName(busiReqBO.getDetailName());
        payProOrderAbilityServiceReqBo.setRedirectUrl(busiReqBO.getRedirectUrl());
        payProOrderAbilityServiceReqBo.setNotifyUrl(this.notifyUrl);
        payProOrderAbilityServiceReqBo.setCreateIpAddress(busiReqBO.getIp());
        payProOrderAbilityServiceReqBo.setCreateOperId(busiReqBO.getUserId().toString());
        payProOrderAbilityServiceReqBo.setCreateOperIdName(busiReqBO.getName());
        JSONObject busiReqData = new JSONObject();
        busiReqData.put("payMethods", (Object)"20");
        payProOrderAbilityServiceReqBo.setBusiReqData(busiReqData.toJSONString());
        PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = this.payProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo);
        if (!"0000".equals(payProOrderAbilityServiceRspBo.getRspCode())) {
            throw new FscBusinessException("194202", payProOrderAbilityServiceRspBo.getRespDesc());
        }
        return payProOrderAbilityServiceRspBo.getUrl();
    }

    private void validStatsAndAmount(FscPayBillAtomReqBO busiReqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(busiReqBO.getFscOrderIds());
        List pos = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty((Collection)pos)) {
            throw new FscBusinessException("194202", "\u5f85\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList<Long> fscStatusError = new ArrayList<Long>();
        ArrayList<Long> existFscOrderIds = new ArrayList<Long>();
        BigDecimal totalAmount = new BigDecimal(0);
        HashSet<String> payChannel = new HashSet<String>();
        HashSet<String> payMethod = new HashSet<String>();
        HashSet<Integer> payType = new HashSet<Integer>();
        HashSet<Long> payerIds = new HashSet<Long>();
        HashSet<Long> payeeIds = new HashSet<Long>();
        for (FscOrderPO fscOrderPO1 : pos) {
            existFscOrderIds.add(fscOrderPO1.getFscOrderId());
            payChannel.add(fscOrderPO1.getPayChannel());
            payMethod.add(fscOrderPO1.getPayMethod());
            payerIds.add(fscOrderPO1.getPayerId());
            payeeIds.add(fscOrderPO1.getPayeeId());
            payType.add(fscOrderPO1.getPayType());
            if (!fscOrderPO1.getOrderState().equals(FscConstants.FscPayOrderState.TO_PAY)) {
                fscStatusError.add(fscOrderPO1.getFscOrderId());
            }
            totalAmount = totalAmount.add(fscOrderPO1.getTotalCharge());
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194202", "\u591a\u4e2a\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff01");
        }
        if (payChannel.size() > 1) {
            throw new FscBusinessException("194202", "\u591a\u4e2a\u4ed8\u6b3e\u5355\u652f\u4ed8\u6e20\u9053\u4e0d\u4e00\u81f4\uff01");
        }
        if (!StringUtils.isEmpty((Object)busiReqBO.getPayChannel()) && !payChannel.contains(busiReqBO.getPayChannel())) {
            throw new FscBusinessException("194202", "\u5165\u53c2\u652f\u4ed8\u6e20\u9053\u548c\u6570\u636e\u5e93\u4e0d\u4e00\u81f4\uff01");
        }
        if (payMethod.size() > 1) {
            throw new FscBusinessException("194202", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194202", "\u4ed8\u6b3e\u65b9\u4e0d\u4e00\u81f4\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194202", "\u6536\u6b3e\u65b9\u4e0d\u4e00\u81f4\uff01");
        }
        if (fscStatusError.size() > 0) {
            throw new FscBusinessException("194202", ((Object)fscStatusError).toString() + "\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\uff01");
        }
        if (existFscOrderIds.size() < busiReqBO.getFscOrderIds().size()) {
            busiReqBO.getFscOrderIds().removeAll(existFscOrderIds);
            throw new FscBusinessException("194202", busiReqBO.getFscOrderIds() + "\u4e0d\u5b58\u5728\uff01");
        }
        if (!busiReqBO.getOperType().equals(3)) {
            busiReqBO.setPayChannel(((FscOrderPO)pos.get(0)).getPayChannel());
            busiReqBO.setPayMethod(((FscOrderPO)pos.get(0)).getPayMethod());
            busiReqBO.setPayerId(((FscOrderPO)pos.get(0)).getPayerId());
            busiReqBO.setPayeeId(((FscOrderPO)pos.get(0)).getPayeeId());
            busiReqBO.setPayType(((FscOrderPO)pos.get(0)).getPayType());
        }
        busiReqBO.setTotalAmount(totalAmount);
    }
}

