/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayConfirmBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfirmBusiServiceImpl
implements FscPayConfirmBusiService {
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @Override
    public FscPayConfirmBusiRspBO dealPayConfirm(FscPayConfirmBusiReqBO busiReqBO) {
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(busiReqBO.getUserName());
        set.setPayConfirmName(busiReqBO.getName());
        set.setPayConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(busiReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        Map<String, Object> paramMap = this.invokeFscOrderStatusFlow(busiReqBO);
        if (busiReqBO.getPayFlag().booleanValue()) {
            FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
            fscDealPaySuccessAtomReqBO.setPayFscOrderId(busiReqBO.getFscOrderIds());
            fscDealPaySuccessAtomReqBO.setParamMap(paramMap);
            FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getResultFscOrderIds())) {
                resultFscOrderIds.addAll(atomRspBO.getResultFscOrderIds());
            }
        }
        resultFscOrderIds.addAll(busiReqBO.getFscOrderIds());
        FscPayConfirmBusiRspBO busiRspBO = new FscPayConfirmBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        return busiRspBO;
    }

    private Map<String, Object> invokeFscOrderStatusFlow(FscPayConfirmBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (busiReqBO.getPayFlag().booleanValue()) {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
        } else {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
        });
        return paramMap;
    }
}

