/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.DyUccMallValidatePurchaseNumAndStockService;
import com.tydic.commodity.mall.ability.bo.DyUccMallValidatePurchaseNumAndStockReqBo;
import com.tydic.commodity.mall.ability.bo.DyUccMallValidatePurchaseNumAndStockRspBo;
import com.tydic.commodity.mall.constants.UccMallConstants;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccOrderConfCommodityTypeRelMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccOrderConfCommodityTypeRelPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.DyUccMallValidatePurchaseNumAndStockService"})
public class DyUccMallValidatePurchaseNumAndStockServiceImpl
implements DyUccMallValidatePurchaseNumAndStockService {
    private static final Logger log = LoggerFactory.getLogger(DyUccMallValidatePurchaseNumAndStockServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccOrderConfCommodityTypeRelMapper uccOrderConfCommodityTypeRelMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;

    @PostMapping(value={"dealPrice"})
    public DyUccMallValidatePurchaseNumAndStockRspBo dealPrice(@RequestBody DyUccMallValidatePurchaseNumAndStockReqBo reqBo) {
        this.validate(reqBo);
        reqBo.getUccMallSkuPurchaseBos().forEach(e -> {
            block13: {
                BigDecimal multiple;
                UccSkuPo uccSkuPo = this.uccMallSkuMapper.qrySkuBySkuId(e.getSkuId());
                if (ObjectUtils.isEmpty((Object)uccSkuPo)) {
                    throw new BusinessException("1", "\u5355\u54c1\u3010" + e.getSkuId() + "\u3011\u4e0d\u5b58\u5728");
                }
                UccOrderConfCommodityTypeRelPo selectConfPo = new UccOrderConfCommodityTypeRelPo();
                selectConfPo.setCommodityTypeId(uccSkuPo.getCommodityTypeId());
                UccOrderConfCommodityTypeRelPo orderConfCommodityTypeRelPo = null;
                if (UccMallConstants.SkuSource.SELF.equals(uccSkuPo.getSkuSource())) {
                    orderConfCommodityTypeRelPo = this.uccOrderConfCommodityTypeRelMapper.selectByModel(selectConfPo);
                }
                if (UccMallConstants.SkuSource.SUP.equals(uccSkuPo.getSkuSource())) {
                    selectConfPo.setSkuSource(2);
                    orderConfCommodityTypeRelPo = this.uccOrderConfCommodityTypeRelMapper.selectByModel(selectConfPo);
                }
                if (ObjectUtils.isEmpty((Object)orderConfCommodityTypeRelPo)) {
                    throw new BusinessException("1", "\u5546\u54c1\u7c7b\u578b\u3010" + uccSkuPo.getCommodityTypeId() + "\u3011\u672a\u914d\u7f6e\u6570\u91cf\u9650\u5236\u89c4\u5219\uff01");
                }
                BigDecimal skuNum = MoneyUtils.yuanToHao(e.getNum().longValue());
                BigDecimal[] bigDecimals = skuNum.divideAndRemainder(multiple = MoneyUtils.yuanToHao(orderConfCommodityTypeRelPo.getMultiple()));
                if (bigDecimals[1].compareTo(BigDecimal.ZERO) != 0) {
                    throw new BusinessException("1", "\u4e0b\u5355\u6570\u91cf\u6709\u8bef\uff01");
                }
                if (UccMallConstants.ValidateStock.YES.equals(e.getValidateStock())) {
                    if (UccMallConstants.SkuSource.SELF.equals(uccSkuPo.getSkuSource()) && UccMallConstants.SpuCreateOption.COMMODITY_CLASS_MATERIAL.equals(uccSkuPo.getSkuClass())) {
                        if (!UccMallConstants.SkuMaterialFormEnum.CASH_COMMODITY.getFormId().equals(uccSkuPo.getSkuForm()) && UccMallConstants.SkuMaterialFormEnum.SAMPLE_CARD.getFormId().equals(uccSkuPo.getSkuForm())) {
                            // empty if block
                        }
                    } else {
                        try {
                            SmcsdkQryStockNumReqBO stockNumReqBO = new SmcsdkQryStockNumReqBO();
                            ArrayList<Long> skuId = new ArrayList<Long>();
                            skuId.add(e.getSkuId());
                            stockNumReqBO.setSkuIds(skuId);
                            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)stockNumReqBO));
                            SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(stockNumReqBO);
                            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
                            if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode())) {
                                Long stockNum = (Long)smcsdkQryStockNumRspBO.getSkuStockNumMap().get(e.getSkuId());
                                if (skuNum.compareTo(new BigDecimal(stockNum)) >= 0) {
                                    throw new BusinessException("1", "\u5355\u54c1\u3010" + e.getSkuId() + "\u3011\u5e93\u5b58\u4e0d\u8db3\uff01");
                                }
                                break block13;
                            }
                            throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u67e5\u8be2\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkQryStockNumRspBO.getRespDesc());
                        }
                        catch (Exception e1) {
                            log.error(e1.getMessage());
                            throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u4fe1\u606f\u5931\u8d25!" + e1.getMessage());
                        }
                    }
                }
            }
        });
        DyUccMallValidatePurchaseNumAndStockRspBo rspBo = new DyUccMallValidatePurchaseNumAndStockRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validate(DyUccMallValidatePurchaseNumAndStockReqBo reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo.getUccMallSkuPurchaseBos())) {
            throw new BusinessException("1", "\u53c2\u6570 uccMallSkuPurchaseBos \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

