/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallSkuSpecListBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuSpecPropValueListBo;
import com.tydic.commodity.mall.busi.api.UccMallLoadMaterialSpecBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallLoadMaterialSpecBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallLoadMaterialSpecBusiRspBO;
import com.tydic.commodity.mall.constants.UccMallConstants;
import com.tydic.commodity.mall.dao.UccMallErpSkuSpecMapper;
import com.tydic.commodity.mall.po.UccMallErpSkuSpecPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallLoadMaterialSpecBusiServiceImpl
implements UccMallLoadMaterialSpecBusiService {
    @Autowired
    private UccMallErpSkuSpecMapper uccMallErpSkuSpecMapper;

    @Override
    public UccMallLoadMaterialSpecBusiRspBO loadMaterialSpec(UccMallLoadMaterialSpecBusiReqBO reqBO) {
        UccMallErpSkuSpecPO uccMallErpSkuSpecPO = new UccMallErpSkuSpecPO();
        uccMallErpSkuSpecPO.setErpSpuCode(reqBO.getErpSpuCode());
        uccMallErpSkuSpecPO.setErpSkuStatus(UccMallConstants.ErpSkuStatus.HAVE_CREATE);
        List<UccMallErpSkuSpecPO> uccMallErpSkuSpecPOList = this.uccMallErpSkuSpecMapper.getListForSpec(uccMallErpSkuSpecPO);
        if (CollectionUtils.isEmpty(uccMallErpSkuSpecPOList)) {
            throw new ZTBusinessException("\u5546\u54c1\u7269\u6599\u5c5e\u6027\u52a0\u8f7d\u5931\u8d25-\u672a\u67e5\u8be2\u5230\u5c5e\u6027\u4fe1\u606f\uff01");
        }
        Map<Long, List<UccMallErpSkuSpecPO>> defIdSkuSpecMap = uccMallErpSkuSpecPOList.stream().collect(Collectors.groupingBy(po -> po.getCommodityPropDefId()));
        ArrayList<UccMallSkuSpecListBo> skuSpecDefList = new ArrayList<UccMallSkuSpecListBo>();
        for (Long key : defIdSkuSpecMap.keySet()) {
            UccMallSkuSpecListBo uccMallSkuSpecListBo = new UccMallSkuSpecListBo();
            uccMallSkuSpecListBo.setCommodityPropDefId(key);
            if (CollectionUtils.isEmpty((Collection)defIdSkuSpecMap.get(key))) continue;
            List skuSpecList = defIdSkuSpecMap.get(key).stream().map(po -> {
                UccMallSkuSpecPropValueListBo bo = new UccMallSkuSpecPropValueListBo();
                bo.setPropValueListId(po.getPropValueListId());
                bo.setPropValue(po.getPropValue());
                return bo;
            }).collect(Collectors.toList());
            uccMallSkuSpecListBo.setSkuSpecList(skuSpecList);
            uccMallSkuSpecListBo.setPropName(defIdSkuSpecMap.get(key).get(0).getPropName());
            skuSpecDefList.add(uccMallSkuSpecListBo);
        }
        UccMallLoadMaterialSpecBusiRspBO rspBO = new UccMallLoadMaterialSpecBusiRspBO();
        rspBO.setSkuSpecDefList(skuSpecDefList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u7269\u6599\u5c5e\u6027\u52a0\u8f7d\u6210\u529f");
        return rspBO;
    }
}

