/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallSkuFormListBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuSpecQryListBo;
import com.tydic.commodity.mall.busi.api.UccMallLoadSaleSpecBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallLoadSaleSpecBusiServiceReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallLoadSaleSpecBusiServiceRspBO;
import com.tydic.commodity.mall.dao.UccMallErpSkuSpecMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccMallErpSkuSpecPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallLoadSaleSpecBusiServiceImpl
implements UccMallLoadSaleSpecBusiService {
    @Autowired
    private UccMallErpSkuSpecMapper uccMallErpSkuSpecMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @Override
    public UccMallLoadSaleSpecBusiServiceRspBO loadSaleSpec(UccMallLoadSaleSpecBusiServiceReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getQryInfoList())) {
            throw new ZTBusinessException("\u5165\u53c2\u7269\u6599\u5c5e\u6027\u7b5b\u9009\u5217\u8868\u4e3a\u7a7a");
        }
        ArrayList erpSkuCodeList = new ArrayList();
        for (UccMallSkuSpecQryListBo qryListBo : reqBO.getQryInfoList()) {
            UccMallErpSkuSpecPO uccMallErpSkuSpecPO = new UccMallErpSkuSpecPO();
            uccMallErpSkuSpecPO.setCommodityPropDefId(qryListBo.getCommodityPropDefId());
            uccMallErpSkuSpecPO.setPropValueListId(qryListBo.getPropValueListId());
            List<UccMallErpSkuSpecPO> POList = this.uccMallErpSkuSpecMapper.getList(uccMallErpSkuSpecPO);
            List codeList = POList.stream().map(UccMallErpSkuSpecPO::getErpSkuCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(erpSkuCodeList)) {
                erpSkuCodeList.addAll(codeList);
                continue;
            }
            erpSkuCodeList.retainAll(codeList);
            if (!CollectionUtils.isEmpty(erpSkuCodeList)) continue;
            throw new ZTBusinessException("\u7269\u6599\u5c5e\u6027\u7b5b\u9009\uff0c\u65e0\u6cd5\u786e\u8ba4erp-sku");
        }
        if (erpSkuCodeList.size() > 1) {
            throw new ZTBusinessException("\u7269\u6599\u5c5e\u6027\u7b5b\u9009\uff0c\u65e0\u6cd5\u786e\u8ba4erp-sku");
        }
        String erpSkuCode = (String)erpSkuCodeList.get(0);
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setExtSkuId(erpSkuCode);
        uccSkuPo.setProductLevel(reqBO.getProductLevel());
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty(uccSkuPoList)) {
            throw new ZTBusinessException("\u5355\u54c1\u5546\u54c1\u5f62\u6001\u67e5\u8be2\u9519\u8bef\uff01");
        }
        List<UccMallSkuFormListBo> skuFormListBoList = uccSkuPoList.stream().map(po -> {
            UccMallSkuFormListBo bo = new UccMallSkuFormListBo();
            bo.setSkuId(po.getSkuId());
            bo.setSkuCode(po.getSkuCode());
            bo.setSkuForm(po.getSkuForm());
            return bo;
        }).collect(Collectors.toList());
        UccMallLoadSaleSpecBusiServiceRspBO rspBO = new UccMallLoadSaleSpecBusiServiceRspBO();
        rspBO.setSkuFormListBoList(skuFormListBoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u9500\u552e\u5c5e\u6027\u52a0\u8f7d\u6210\u529f\uff01");
        return rspBO;
    }
}

