/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.busi.api.UccMallCommdDetailsQryBusiService;
import com.tydic.commodity.mall.busi.api.UccMallOrderQrySkuDetailListBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisBO;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisRspBO;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCommodityMeasurePo;
import com.tydic.commodity.mall.po.UccCommodityPicPo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccMallSkuDetailInfoPO;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallOrderQrySkuDetailListBusiServiceImpl
implements UccMallOrderQrySkuDetailListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallOrderQrySkuDetailListBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallCommdDetailsQryBusiService uccMallCommdDetailsQryBusiService;
    @Autowired
    private UccMallCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccMallCommodityPicMapper uccMallCommodityPicMapper;

    @Override
    public UccMallOrderQrySkuDetailLisRspBO qryOrderSkuInfo(UccMallOrderQrySkuDetailLisReqBO reqBO) {
        ArrayList<UccMallSkuDetailInfoBO> orderSkuList;
        List<Long> skus;
        List<UccMallSkuDetailInfoPO> skuInfoDetailPOS;
        UccMallOrderQrySkuDetailLisRspBO rspBO = new UccMallOrderQrySkuDetailLisRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<UccCommodityMeasurePo> measurePos = this.uccCommodityMeasureMapper.queryAll();
        Map<Long, UccCommodityMeasurePo> measureMap = null;
        if (!CollectionUtils.isEmpty(measurePos)) {
            measureMap = measurePos.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo2 -> UccCommodityMeasurePo2));
        }
        if (!CollectionUtils.isEmpty(skuInfoDetailPOS = this.uccMallSkuMapper.qryOrderSkusInfoList(skus = reqBO.getSkuList().stream().map(UccMallOrderQrySkuDetailLisBO::getSkuId).collect(Collectors.toList())))) {
            List<UccCommodityPicPo> commodityPicPoList;
            Map<Long, BigDecimal> skuReqStock = reqBO.getSkuList().stream().collect(Collectors.toMap(UccMallOrderQrySkuDetailLisBO::getSkuId, UccMallOrderQrySkuDetailLisBO::getNum));
            orderSkuList = new ArrayList<UccMallSkuDetailInfoBO>();
            if (skuInfoDetailPOS.size() != skus.size()) {
                throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_EXIST.code(), "\u5355\u54c1\u6570\u636e" + UccMallConstantsEnums.SKU_NOT_ON_EXIST.message());
            }
            ArrayList<Long> notPicSpu = new ArrayList<Long>();
            for (UccMallSkuDetailInfoPO uccSkuInfoDetailPO : skuInfoDetailPOS) {
                UccMallSkuDetailInfoBO uccSkuInfoDetailBO = new UccMallSkuDetailInfoBO();
                BeanUtils.copyProperties((Object)uccSkuInfoDetailPO, (Object)uccSkuInfoDetailBO);
                if (!ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(uccSkuInfoDetailPO.getSkuStatus())) {
                    throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_SELFE.code(), uccSkuInfoDetailPO.getSkuName() + UccMallConstantsEnums.SKU_NOT_ON_SELFE.message());
                }
                if (StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getMaterialName())) {
                    uccSkuInfoDetailBO.setMaterialName(uccSkuInfoDetailPO.getOrgMaterialName());
                }
                if (uccSkuInfoDetailBO.getMeasureId() != null && !measureMap.isEmpty()) {
                    if (measureMap.containsKey(uccSkuInfoDetailPO.getMeasureId())) {
                        uccSkuInfoDetailBO.setDecimalLimit(measureMap.get(uccSkuInfoDetailBO.getMeasureId()).getDecimalLimit());
                    } else {
                        log.error("\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38->{}" + uccSkuInfoDetailBO.getMeasureId());
                    }
                }
                if (uccSkuInfoDetailPO.getMoq().compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) < 0) {
                    throw new BusinessException(UccMallConstantsEnums.SKU_MOQ_UNMET.code(), uccSkuInfoDetailPO.getSkuName() + UccMallConstantsEnums.SKU_MOQ_UNMET.message());
                }
                if (uccSkuInfoDetailPO.getSwitchOn() == 1 && !CollectionUtils.isEmpty(uccSkuInfoDetailPO.getLadderPricePOList())) {
                    for (UccLadderPricePO ladderprice : uccSkuInfoDetailPO.getLadderPricePOList()) {
                        if (MoneyUtils.haoToYuan(ladderprice.getStart()).compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) > 0 || ladderprice.getStop() != null && MoneyUtils.haoToYuan(ladderprice.getStop()).compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) <= 0) continue;
                        uccSkuInfoDetailBO.setSalePrice(ladderprice.getPrice());
                        uccSkuInfoDetailBO.setSkuPrice(new BigDecimal(ladderprice.getPrice()));
                    }
                }
                if (uccSkuInfoDetailPO.getWeight() != null) {
                    uccSkuInfoDetailBO.setFinalWeight(uccSkuInfoDetailPO.getWeight().multiply(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())));
                }
                orderSkuList.add(uccSkuInfoDetailBO);
                if (!StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) continue;
                notPicSpu.add(uccSkuInfoDetailBO.getCommodityId());
            }
            if (!CollectionUtils.isEmpty(notPicSpu) && !CollectionUtils.isEmpty(commodityPicPoList = this.uccMallCommodityPicMapper.queryBatchLesCloum(notPicSpu, null, 1))) {
                Map<Long, String> spuPicMap = commodityPicPoList.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
                for (UccMallSkuDetailInfoBO each : orderSkuList) {
                    if (!spuPicMap.containsKey(each.getCommodityId())) continue;
                    each.setSkuMainPic(spuPicMap.get(each.getCommodityId()));
                }
            }
        } else {
            throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_EXIST.code(), "\u5355\u54c1\u6570\u636e" + UccMallConstantsEnums.SKU_NOT_ON_EXIST.message());
        }
        rspBO.setOrderSkuList(orderSkuList);
        return rspBO;
    }
}

