/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallCommodityStockBO;
import com.tydic.commodity.mall.busi.api.UccMallQueryGoodsStockBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallQueryGoodsStockBusiServiceReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallQueryGoodsStockBusiServiceRspBO;
import com.tydic.commodity.mall.constants.UccMallConstants;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallQueryGoodsStockBusiServiceImpl
implements UccMallQueryGoodsStockBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQueryGoodsStockBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;

    @Override
    public UccMallQueryGoodsStockBusiServiceRspBO queryGoodsStock(UccMallQueryGoodsStockBusiServiceReqBO reqBO) {
        UccMallQueryGoodsStockBusiServiceRspBO rspBO = new UccMallQueryGoodsStockBusiServiceRspBO();
        ArrayList<UccMallCommodityStockBO> commodityStockBOList = new ArrayList<UccMallCommodityStockBO>();
        rspBO.setCommodityStockBOList(commodityStockBOList);
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.batchQrySku(reqBO.getSkuIdList(), null);
        if (CollectionUtils.isEmpty(uccSkuPoList)) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u67e5\u8be2\u5931\u8d25-\u6279\u91cf\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        Map<Integer, List<UccSkuPo>> grpSkuFormMap = uccSkuPoList.stream().collect(Collectors.groupingBy(po -> po.getSkuForm()));
        List<UccSkuPo> spotOrderList = grpSkuFormMap.get(UccMallConstants.MaterialSkuForm.SPOT_ORDER);
        if (!CollectionUtils.isEmpty(spotOrderList)) {
            Map stockMap;
            List spotOrderSkuIds = spotOrderList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            try {
                SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
                smcsdkQryStockNumReqBO.setSkuIds(spotOrderSkuIds);
                log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u67e5\u8be2\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkQryStockNumReqBO));
                SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
                if (!"0000".equals(smcsdkQryStockNumRspBO.getRespCode()) || CollectionUtils.isEmpty((Map)smcsdkQryStockNumRspBO.getSkuStockNumMap())) {
                    throw new ZTBusinessException(smcsdkQryStockNumRspBO.getRespDesc());
                }
                log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
                stockMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u5e93\u5b58\u67e5\u8be2\uff0c\u7b80\u7248\u5e93\u5b58\u8c03\u7528\u5f02\u5e38\uff01");
            }
            List spotOrderStockBOList = spotOrderList.stream().map(po -> {
                UccMallCommodityStockBO bo = new UccMallCommodityStockBO();
                bo.setSkuId(po.getSkuId());
                bo.setUnsaleNum((Long)stockMap.get(po.getSkuId()));
                return bo;
            }).collect(Collectors.toList());
            commodityStockBOList.addAll(spotOrderStockBOList);
        }
        return rspBO;
    }
}

