/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.mall.ability.bo.UccMallOrderColumBo;
import com.tydic.commodity.mall.ability.bo.UccMallSourceTypeBo;
import com.tydic.commodity.mall.busi.api.UccMallSearchEsSQLService;
import com.tydic.commodity.mall.busi.bo.UccMallCompareEsSQLReqBo;
import com.tydic.commodity.mall.busi.bo.UccMallCompareEsSQLRspBoUccMall;
import com.tydic.commodity.mall.busi.bo.UccMallFieldsSearchEsBo;
import com.tydic.commodity.mall.busi.bo.UccMallFieldsSearchExtEsBo;
import com.tydic.commodity.mall.busi.bo.UccMallQueryParamBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsSQLReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsSQLRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallSourceCatalogBo;
import com.tydic.commodity.mall.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.WeightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallSearchEsSQLServiceImpl
implements UccMallSearchEsSQLService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchEsSQLServiceImpl.class);
    @Value(value="${search_phrase}")
    private String searchPhrase;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${analyzer_tokens}")
    private Boolean analyzerTokens;

    /*
     * WARNING - void declaration
     */
    @Override
    public UccMallSearchEsSQLRspBO buildSQL(UccMallSearchEsSQLReqBO uccMallSearchEsSQLReqBO) {
        void var8_43;
        long[] skus;
        int i;
        UccMallSearchEsSQLRspBO searchBarEsSQLRspBO = new UccMallSearchEsSQLRspBO();
        searchBarEsSQLRspBO.setLevel(uccMallSearchEsSQLReqBO.getLevel());
        BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder inBoolQueryBuilder = QueryBuilders.boolQuery();
        if (uccMallSearchEsSQLReqBO.getSceneId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"scene_id", (Object)uccMallSearchEsSQLReqBO.getSceneId()));
        }
        if (uccMallSearchEsSQLReqBO.getSkuStatus() != null && uccMallSearchEsSQLReqBO.getSkuStatus().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", uccMallSearchEsSQLReqBO.getSkuStatus()));
        }
        if (uccMallSearchEsSQLReqBO.getQueryLocation() != null && uccMallSearchEsSQLReqBO.getQueryLocation() != 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)uccMallSearchEsSQLReqBO.getQueryLocation()));
        }
        if (uccMallSearchEsSQLReqBO.getSearchChannel() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"channel_id", (Object)uccMallSearchEsSQLReqBO.getSearchChannel()));
        }
        if (uccMallSearchEsSQLReqBO.getSupplierShopIds() != null && uccMallSearchEsSQLReqBO.getSupplierShopIds().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_shop_id", uccMallSearchEsSQLReqBO.getSupplierShopIds()));
        }
        if (uccMallSearchEsSQLReqBO.getSupplierId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)uccMallSearchEsSQLReqBO.getSupplierId()));
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"unuse_suppliershop_list", (Object)uccMallSearchEsSQLReqBO.getSupplierId()));
        }
        if (uccMallSearchEsSQLReqBO.getMerchantId() != null) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"unuse_suppliershop_list", (Object)uccMallSearchEsSQLReqBO.getMerchantId()));
        }
        if (uccMallSearchEsSQLReqBO.getBrandIds() != null && uccMallSearchEsSQLReqBO.getBrandIds().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"brand_id", uccMallSearchEsSQLReqBO.getBrandIds()));
        }
        if (uccMallSearchEsSQLReqBO.getVendorId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)uccMallSearchEsSQLReqBO.getVendorId()));
        }
        if (uccMallSearchEsSQLReqBO.getTypeId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)uccMallSearchEsSQLReqBO.getTypeId()));
        }
        if (StringUtils.isNotEmpty((String)uccMallSearchEsSQLReqBO.getTypeName())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_name", (String)uccMallSearchEsSQLReqBO.getTypeName()));
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getSourceAssort())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sourceAssort", uccMallSearchEsSQLReqBO.getSourceAssort()));
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getIgnoreSourceAssort())) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sourceAssort", uccMallSearchEsSQLReqBO.getIgnoreSourceAssort()));
        }
        if (uccMallSearchEsSQLReqBO.getCommdIds() != null && uccMallSearchEsSQLReqBO.getCommdIds().size() > 0) {
            long[] commd = new long[uccMallSearchEsSQLReqBO.getCommdIds().size()];
            for (i = 0; i < uccMallSearchEsSQLReqBO.getCommdIds().size(); ++i) {
                commd[i] = uccMallSearchEsSQLReqBO.getCommdIds().get(i);
            }
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (long[])commd));
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getExtSkuIds())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"ext_sku_id.keyword", uccMallSearchEsSQLReqBO.getExtSkuIds()));
        }
        if (uccMallSearchEsSQLReqBO.getSkuList() != null && uccMallSearchEsSQLReqBO.getSkuList().size() > 0) {
            skus = new long[uccMallSearchEsSQLReqBO.getSkuList().size()];
            for (i = 0; i < uccMallSearchEsSQLReqBO.getSkuList().size(); ++i) {
                skus[i] = uccMallSearchEsSQLReqBO.getSkuList().get(i);
            }
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
        }
        if (!StringUtils.isEmpty((String)uccMallSearchEsSQLReqBO.getSkuName())) {
            WildcardQueryBuilder queryBuilder1 = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + uccMallSearchEsSQLReqBO.getSkuName() + "*"));
            extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
        }
        if (uccMallSearchEsSQLReqBO.getIgnoreList() != null && uccMallSearchEsSQLReqBO.getIgnoreList().size() > 0) {
            skus = new long[uccMallSearchEsSQLReqBO.getIgnoreList().size()];
            for (i = 0; i < uccMallSearchEsSQLReqBO.getIgnoreList().size(); ++i) {
                skus[i] = uccMallSearchEsSQLReqBO.getIgnoreList().get(i);
            }
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
        }
        if (uccMallSearchEsSQLReqBO.getIgnoreAgrList() != null && uccMallSearchEsSQLReqBO.getIgnoreAgrList().size() > 0) {
            long[] agrs = new long[uccMallSearchEsSQLReqBO.getIgnoreAgrList().size()];
            for (i = 0; i < uccMallSearchEsSQLReqBO.getIgnoreAgrList().size(); ++i) {
                agrs[i] = uccMallSearchEsSQLReqBO.getIgnoreAgrList().get(i);
            }
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_id", (long[])agrs));
        }
        if (uccMallSearchEsSQLReqBO.getCategoryIds() != null && uccMallSearchEsSQLReqBO.getCategoryIds().size() > 0 && uccMallSearchEsSQLReqBO.getLevel() != null) {
            if (uccMallSearchEsSQLReqBO.getLevel() == 1) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", uccMallSearchEsSQLReqBO.getCategoryIds()));
            } else if (uccMallSearchEsSQLReqBO.getLevel() == 2) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", uccMallSearchEsSQLReqBO.getCategoryIds()));
            } else if (uccMallSearchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = uccMallSearchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", uccMallSearchEsSQLReqBO.getCategoryIds()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("UccMallSearchEsSQLServiceImpl \uff1a \u8d70\u67e5\u8be2\u8ff7\u7cca\u5339\u914d search_phrase\uff1a" + this.searchPhrase);
        }
        float minScore = 4.0f;
        if (!StringUtils.isEmpty((String)uccMallSearchEsSQLReqBO.getQueryStr())) {
            boolean isFunction;
            Object fields;
            void var8_22;
            FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)extBoolQueryBuilder);
            Iterator<UccMallSourceCatalogBo> obj = this.cacheClient.get("UCC_FIELDS_SEARCH");
            Object var8_20 = null;
            if (obj != null) {
                try {
                    Object parse = JSON.parse((String)obj.toString());
                    String jsonStr1 = JSONObject.toJSONString((Object)parse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    UccMallFieldsSearchEsBo uccMallFieldsSearchEsBo = (UccMallFieldsSearchEsBo)JSON.parseObject((String)jsonStr1, UccMallFieldsSearchEsBo.class);
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a " + JSONObject.toJSONString(obj));
                }
            }
            if (var8_22 != null) {
                minScore = var8_22.getMinScore().floatValue();
                fields = new HashedMap();
                HashedMap fieldsf = new HashedMap();
                if ((!this.analyzerTokens.booleanValue() || uccMallSearchEsSQLReqBO.getIsAnalyzer() != null) && uccMallSearchEsSQLReqBO.getIsAnalyzer().booleanValue()) {
                    fieldsf.put("sku_name", Float.valueOf(1.0f));
                    fieldsf.put("properties", Float.valueOf(1.0f));
                } else {
                    Map<Integer, List<UccMallFieldsSearchExtEsBo>> fieldsListMap = this.groupByfieldsType(var8_22.getFields());
                    if (!fieldsListMap.isEmpty()) {
                        for (Map.Entry<Integer, List<UccMallFieldsSearchExtEsBo>> entry : fieldsListMap.entrySet()) {
                            if (entry.getKey() == 3) {
                                fields = entry.getValue().stream().collect(Collectors.toMap(UccMallFieldsSearchExtEsBo::getFields, UccMallFieldsSearchExtEsBo::getBoot));
                            }
                            if (!uccMallSearchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$") || entry.getKey() != 1) continue;
                            for (UccMallFieldsSearchExtEsBo field : entry.getValue()) {
                                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field.getFields(), (Object)uccMallSearchEsSQLReqBO.getQueryStr()).boost(field.getBoot().floatValue()));
                            }
                        }
                    }
                    for (Map.Entry<Integer, List<UccMallFieldsSearchExtEsBo>> entry : fields.entrySet()) {
                        fieldsf.put(entry.getKey(), Float.valueOf(((BigDecimal)((Object)entry.getValue())).floatValue()));
                    }
                }
                if ("true".equals(this.searchPhrase)) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)uccMallSearchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fieldsf).type((Object)var8_22.getParseField()).tieBreaker(1.0f).type((Object)"phrase").slop(var8_22.getSlop().intValue()));
                } else {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)uccMallSearchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fieldsf).minimumShouldMatch(new StringBuffer(var8_22.getAnalysisModulus().toString()).append('%').toString()).type((Object)var8_22.getParseField()).analyzer(var8_22.getAnalyzer())).boost();
                }
            } else if ("true".equals(this.searchPhrase)) {
                String[] fileNames = new String[]{"ext_sku_id", "sku_name", "commodity_name", "brand_name", "supplier_name", "l2_category_name", "l3_category_name", "properties", "manufacturer", "figure", "model", "material_name", "l4mg_category_name"};
                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)uccMallSearchEsSQLReqBO.getQueryStr(), (String[])fileNames).type(MultiMatchQueryBuilder.Type.BEST_FIELDS).tieBreaker(1.0f).type((Object)"phrase").slop(20));
                if (uccMallSearchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$")) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"sku_id", (Object)uccMallSearchEsSQLReqBO.getQueryStr()));
                }
            } else {
                fields = new HashedMap();
                if ((!this.analyzerTokens.booleanValue() || uccMallSearchEsSQLReqBO.getIsAnalyzer() != null) && uccMallSearchEsSQLReqBO.getIsAnalyzer().booleanValue()) {
                    fields.put("sku_name", Float.valueOf(1.0f));
                    fields.put("commodity_name", Float.valueOf(1.0f));
                    fields.put("search_name", Float.valueOf(1.0f));
                    fields.put("l3_category_name", Float.valueOf(1.0f));
                    fields.put("l2_category_name", Float.valueOf(1.0f));
                    fields.put("l3_category_id", Float.valueOf(1.0f));
                    fields.put("l2_category_id", Float.valueOf(1.0f));
                } else {
                    fields.put("type_name", Float.valueOf(20.0f));
                    fields.put("brand_name", Float.valueOf(12.0f));
                    fields.put("supplier_name", Float.valueOf(10.0f));
                    fields.put("l3_category_name", Float.valueOf(10.0f));
                    fields.put("l2_category_name", Float.valueOf(7.0f));
                    fields.put("sku_name", Float.valueOf(5.0f));
                    fields.put("commodity_name", Float.valueOf(5.0f));
                    fields.put("ext_sku_id", Float.valueOf(1.0f));
                    fields.put("properties", Float.valueOf(1.0f));
                    fields.put("manufacturer", Float.valueOf(1.0f));
                    fields.put("figure", Float.valueOf(1.0f));
                    fields.put("model", Float.valueOf(1.0f));
                    fields.put("material_name", Float.valueOf(1.0f));
                    fields.put("l4mg_category_name", Float.valueOf(1.0f));
                }
                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)uccMallSearchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fields).minimumShouldMatch("95%").type(MultiMatchQueryBuilder.Type.MOST_FIELDS).analyzer("ik_smart")).boost();
                if (uccMallSearchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$")) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"sku_id", (Object)uccMallSearchEsSQLReqBO.getQueryStr())).boost(20.0f);
                }
            }
            extBoolQueryBuilder.must((QueryBuilder)inBoolQueryBuilder);
            boolean bl = this.analyzerTokens != false && uccMallSearchEsSQLReqBO.getIsAnalyzer() == null ? false : (isFunction = uccMallSearchEsSQLReqBO.getIsAnalyzer() != false && !CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getCategoryIds()));
            if (isFunction) {
                ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder> functionBuilder = new ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder>();
                int categoryIdSize = uccMallSearchEsSQLReqBO.getCategoryIds().size();
                for (int i2 = 0; i2 < categoryIdSize; ++i2) {
                    WeightBuilder weightBuilder = new WeightBuilder();
                    weightBuilder.setWeight((float)Math.pow(2.0, categoryIdSize - i2));
                    TermQueryBuilder termQuery = QueryBuilders.termQuery((String)"l3_category_id", (Object)uccMallSearchEsSQLReqBO.getCategoryIds().get(i2));
                    FunctionScoreQueryBuilder.FilterFunctionBuilder category = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)termQuery, (ScoreFunctionBuilder)weightBuilder);
                    functionBuilder.add(category);
                }
                functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)extBoolQueryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])functionBuilder.toArray(new FunctionScoreQueryBuilder.FilterFunctionBuilder[functionBuilder.size()]));
            }
            functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.SUM);
            functionScoreQueryBuilder.boostMode(CombineFunction.MULTIPLY);
            functionScoreQueryBuilder.maxBoost(minScore);
            if (!StringUtils.isEmpty((String)uccMallSearchEsSQLReqBO.getQueryStr())) {
                functionScoreQueryBuilder.setMinScore(minScore);
            }
            searchBarEsSQLRspBO.setFunctionScoreQueryBuilder(functionScoreQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getSearchSourceList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccMallSourceCatalogBo uccMallSourceCatalogBo : uccMallSearchEsSQLReqBO.getSearchSourceList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (uccMallSourceCatalogBo.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)uccMallSourceCatalogBo.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty(uccMallSourceCatalogBo.getCatalog())) {
                    if (uccMallSourceCatalogBo.getCatalogLevel() != null && uccMallSourceCatalogBo.getCatalogLevel() == 1) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", uccMallSourceCatalogBo.getCatalog()));
                    } else if (uccMallSourceCatalogBo.getCatalogLevel() != null && uccMallSourceCatalogBo.getCatalogLevel() == 2) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", uccMallSourceCatalogBo.getCatalog()));
                    } else {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", uccMallSourceCatalogBo.getCatalog()));
                    }
                }
                if (uccMallSourceCatalogBo.getVendorId() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)uccMallSourceCatalogBo.getVendorId()));
                }
                authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getSearchLevelList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccMallSourceCatalogBo uccMallSourceCatalogBo : uccMallSearchEsSQLReqBO.getSearchLevelList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (!CollectionUtils.isEmpty(uccMallSourceCatalogBo.getCatalog())) {
                    if (uccMallSourceCatalogBo.getCatalogLevel() != null && uccMallSourceCatalogBo.getCatalogLevel() == 1) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", uccMallSourceCatalogBo.getCatalog()));
                    } else if (uccMallSourceCatalogBo.getCatalogLevel() != null && uccMallSourceCatalogBo.getCatalogLevel() == 2) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", uccMallSourceCatalogBo.getCatalog()));
                    } else {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", uccMallSourceCatalogBo.getCatalog()));
                    }
                }
                authorityextBoolQueryBuilder.must((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getSearchTypeList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccMallSourceTypeBo uccMallSourceTypeBo : uccMallSearchEsSQLReqBO.getSearchTypeList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (uccMallSourceTypeBo.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)uccMallSourceTypeBo.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty((Collection)uccMallSourceTypeBo.getType())) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", (Collection)uccMallSourceTypeBo.getType()));
                }
                if (uccMallSourceTypeBo.getVendorId() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)uccMallSourceTypeBo.getVendorId()));
                }
                authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getSearchVendorList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccMallSourceTypeBo uccMallSourceTypeBo : uccMallSearchEsSQLReqBO.getSearchVendorList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (uccMallSourceTypeBo.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)uccMallSourceTypeBo.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty((Collection)uccMallSourceTypeBo.getType())) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", (Collection)uccMallSourceTypeBo.getType()));
                }
                if (uccMallSourceTypeBo.getVendorId() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)uccMallSourceTypeBo.getVendorId()));
                }
                authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getSearchIgnoreTypeList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccMallSourceTypeBo uccMallSourceTypeBo : uccMallSearchEsSQLReqBO.getSearchIgnoreTypeList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (uccMallSourceTypeBo.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)uccMallSourceTypeBo.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty((Collection)uccMallSourceTypeBo.getType())) {
                    authorityinBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", (Collection)uccMallSourceTypeBo.getType()));
                }
                if (uccMallSourceTypeBo.getVendorId() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)uccMallSourceTypeBo.getVendorId()));
                }
                authorityextBoolQueryBuilder.must((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (uccMallSearchEsSQLReqBO.getQueryParams() != null) {
            for (int i3 = 0; i3 < uccMallSearchEsSQLReqBO.getQueryParams().size(); ++i3) {
                int j;
                UccMallQueryParamBO uccMallQueryParamBO = uccMallSearchEsSQLReqBO.getQueryParams().get(i3);
                hiddenParamsForRsp.add(uccMallQueryParamBO.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(uccMallQueryParamBO.getFilterId())) {
                    for (j = 0; j < uccMallQueryParamBO.getFilterValues().size(); ++j) {
                        boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_name.keyword", (String)uccMallQueryParamBO.getFilterValues().get(j)));
                    }
                } else if ("brand_id_name".equals(uccMallQueryParamBO.getFilterId())) {
                    for (j = 0; j < uccMallQueryParamBO.getFilterValues().size(); ++j) {
                        boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_name.keyword", (String)uccMallQueryParamBO.getFilterValues().get(j)));
                    }
                } else if ("l3_category_id_name".equals(uccMallQueryParamBO.getFilterId())) {
                    for (j = 0; j < uccMallQueryParamBO.getFilterValues().size(); ++j) {
                        boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_name.keyword", (String)uccMallQueryParamBO.getFilterValues().get(j)));
                    }
                    if (this.analyzerTokens.booleanValue()) {
                        hiddenParamsForRsp.remove(uccMallQueryParamBO.getFilterId());
                    }
                } else if ("vendor_id_name".equals(uccMallQueryParamBO.getFilterId())) {
                    for (j = 0; j < uccMallQueryParamBO.getFilterValues().size(); ++j) {
                        boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"vendor_name.keyword", (String)uccMallQueryParamBO.getFilterValues().get(j)));
                    }
                } else {
                    for (j = 0; j < uccMallQueryParamBO.getFilterValues().size(); ++j) {
                        boolQueryBuilder2.should((QueryBuilder)QueryBuilders.matchQuery((String)"properties", (Object)uccMallQueryParamBO.getFilterValues().get(j)));
                    }
                }
                extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2);
            }
        }
        if (uccMallSearchEsSQLReqBO.getCategoryIds() != null && uccMallSearchEsSQLReqBO.getCategoryIds().size() > 0 && uccMallSearchEsSQLReqBO.getLevel() != null) {
            if (uccMallSearchEsSQLReqBO.getLevel() == 1) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", uccMallSearchEsSQLReqBO.getCategoryIds()));
            } else if (uccMallSearchEsSQLReqBO.getLevel() == 2) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", uccMallSearchEsSQLReqBO.getCategoryIds()));
            } else if (uccMallSearchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = uccMallSearchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                log.error("Sku location {}", (Object)queryLocation);
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", uccMallSearchEsSQLReqBO.getCategoryIds()));
            }
        }
        try {
            RangeQueryBuilder qb = null;
            if (null != uccMallSearchEsSQLReqBO.getMinSalesPrice()) {
                qb = uccMallSearchEsSQLReqBO.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)uccMallSearchEsSQLReqBO.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != uccMallSearchEsSQLReqBO.getMaxSalesPrice() && uccMallSearchEsSQLReqBO.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0 && null != qb) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)uccMallSearchEsSQLReqBO.getMaxSalesPrice()));
            }
            if (qb != null) {
                extBoolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (uccMallSearchEsSQLReqBO.getOrderType() != null && uccMallSearchEsSQLReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String string = "";
        if (uccMallSearchEsSQLReqBO.getOrderByColumn() != null) {
            if (uccMallSearchEsSQLReqBO.getOrderByColumn() == 1) {
                String string2 = "sold_number";
            } else if (uccMallSearchEsSQLReqBO.getOrderByColumn() == 2) {
                String string3 = "on_shelve_time";
            } else if (uccMallSearchEsSQLReqBO.getOrderByColumn() == 3) {
                String string4 = "sale_price";
            } else if (uccMallSearchEsSQLReqBO.getOrderByColumn() == 4) {
                String string5 = "discounts";
            } else if (uccMallSearchEsSQLReqBO.getOrderByColumn() == 5) {
                String string6 = "comment_number";
            } else if (uccMallSearchEsSQLReqBO.getOrderByColumn() == 7) {
                String string7 = "ecommerce_sale";
            } else if (uccMallSearchEsSQLReqBO.getOrderByColumn() == 6) {
                String string8 = "view_order";
            }
        }
        List<Object> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (!var8_43.isEmpty()) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)var8_43).order(orderType);
            fieldSortBuilders.add(sortQuery);
        }
        if (!CollectionUtils.isEmpty(uccMallSearchEsSQLReqBO.getOrderColum()) && uccMallSearchEsSQLReqBO.getOrderByColumn() == 0) {
            fieldSortBuilders = !org.apache.commons.collections.CollectionUtils.isEmpty(searchBarEsSQLRspBO.getSortQuery()) ? searchBarEsSQLRspBO.getSortQuery() : new ArrayList();
            for (UccMallOrderColumBo each : uccMallSearchEsSQLReqBO.getOrderColum()) {
                if (StringUtils.isEmpty((String)each.getOrderByColumn())) continue;
                orderType = SortOrder.DESC;
                if (each.getOrderType() != null && each.getOrderType() == 1) {
                    orderType = SortOrder.ASC;
                }
                fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)each.getOrderByColumn()).order(orderType));
            }
            searchBarEsSQLRspBO.setSortQuery(fieldSortBuilders);
        }
        searchBarEsSQLRspBO.setBoolQueryBuilder(extBoolQueryBuilder);
        searchBarEsSQLRspBO.setSortQuery(fieldSortBuilders);
        searchBarEsSQLRspBO.setHiddenParamsForRsp(hiddenParamsForRsp);
        searchBarEsSQLRspBO.setPageNo(uccMallSearchEsSQLReqBO.getPageNo());
        searchBarEsSQLRspBO.setPageSize(uccMallSearchEsSQLReqBO.getPageSize());
        return searchBarEsSQLRspBO;
    }

    @Override
    public UccMallCompareEsSQLRspBoUccMall compareSQL(UccMallCompareEsSQLReqBo reqBo) {
        UccMallCompareEsSQLRspBoUccMall uccMallCompareEsSQLRspBo = new UccMallCompareEsSQLRspBoUccMall();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)3));
        if (!StringUtils.isEmpty((String)reqBo.getUpc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"upc", (String)reqBo.getUpc()));
        }
        if (!StringUtils.isEmpty((String)reqBo.getMfgsku())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"mfgsku", (String)reqBo.getMfgsku()));
        }
        if (reqBo.getChannelId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"channel_id", (Object)reqBo.getChannelId()));
        }
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"sale_price").order(SortOrder.ASC);
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        fieldSortBuilders.add(sortQuery);
        uccMallCompareEsSQLRspBo.setBoolQueryBuilder(boolQueryBuilder);
        uccMallCompareEsSQLRspBo.setSortQuery(fieldSortBuilders);
        uccMallCompareEsSQLRspBo.setPageNo(1);
        return uccMallCompareEsSQLRspBo;
    }

    private Map<Integer, List<UccMallFieldsSearchExtEsBo>> groupByfieldsType(List<UccMallFieldsSearchExtEsBo> fields) {
        Object map = new HashedMap();
        if (CollectionUtils.isEmpty(fields)) {
            return map;
        }
        map = fields.stream().collect(Collectors.groupingBy(UccMallFieldsSearchExtEsBo::getFieldsType));
        return map;
    }
}

