/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.tydic.umc.security.jwt.UmcTokenState;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UmcJwt {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2ResourceServerProperties.Jwt.class);
    private static byte[] SECRET;
    @Value(value="${app.secret}")
    private String secret;
    private static final JWSHeader header;

    @PostConstruct
    public void init() {
        Assert.notNull((Object)this.secret, (String)"secret is null");
        logger.info("token\u89e3\u6790\u79d8\u94a5 secret ={}", (Object)this.secret);
        if (SECRET == null) {
            SECRET = this.secret.getBytes();
        }
    }

    public static void initSecret(String secret) {
        Assert.notNull((Object)secret, (String)"secret is null");
        SECRET = secret.getBytes();
    }

    public static String createToken(Map<String, Object> payload) {
        String tokenString = null;
        JWSObject jwsObject = new JWSObject(header, new Payload(new JSONObject(payload)));
        try {
            jwsObject.sign((JWSSigner)new MACSigner(SECRET));
            tokenString = jwsObject.serialize();
        }
        catch (JOSEException e) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
        }
        return tokenString;
    }

    public static Map<String, Object> validToken(String token, Long expTime) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (expTime == null) {
            expTime = 0L;
        }
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            Payload payload = jwsObject.getPayload();
            MACVerifier verifier = new MACVerifier(SECRET);
            if (jwsObject.verify((JWSVerifier)verifier)) {
                JSONObject jsonOBj = payload.toJSONObject();
                resultMap.put("state", UmcTokenState.VALID.toString());
                long curTime = System.currentTimeMillis();
                if (curTime > expTime) {
                    resultMap.clear();
                    resultMap.put("state", UmcTokenState.EXPIRED.toString());
                }
                resultMap.put("data", jsonOBj);
                if (jsonOBj != null && jsonOBj.get((Object)"appCode") != null) {
                    resultMap.put("appCode", jsonOBj.get((Object)"appCode"));
                }
            } else {
                resultMap.put("state", UmcTokenState.INVALID.toString());
            }
        }
        catch (Exception e) {
            resultMap.clear();
            resultMap.put("state", UmcTokenState.INVALID.toString());
            logger.error("", (Throwable)e);
        }
        return resultMap;
    }

    static {
        header = new JWSHeader(JWSAlgorithm.HS256, JOSEObjectType.JWT, null, null, null, null, null, null, null, null, null, null, null);
    }
}

