/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.CommonConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.SSLClient;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebTheOrderRemindBusiService;
import com.tydic.uoc.busibase.busi.bo.PebTheOrderRemindReqBO;
import com.tydic.uoc.busibase.busi.bo.PebTheOrderRemindRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pebTheOrderRemindBusiService")
public class PebTheOrderRemindBusiServiceImpl
implements PebTheOrderRemindBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebTheOrderRemindBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    @Override
    public PebTheOrderRemindRspBO dealPebTheOrderRemind(PebTheOrderRemindReqBO reqBO) {
        PebTheOrderRemindRspBO rspBO;
        String token = reqBO.getToken();
        if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MESSAGE)) {
            String requestJsonStr = this.initRequestMessageJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = null == reqBO.getTemplateId() || 0L == reqBO.getTemplateId() ? this.sendFrom(requestJsonStr, OrderPropertiesUtil.getProperty((String)"SEND_INNER_MESSAGE_URL"), token) : this.sendFrom(requestJsonStr, OrderPropertiesUtil.getProperty((String)"SEND_INNER_SYSMESSAGE_URL"), token);
        } else if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_EMIL)) {
            String requestJsonStr = this.initRequestEmailJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u90ae\u4ef6\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "NOTIFY_SEND_MAIL_URL", token);
        } else if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MOBILE)) {
            String requestJsonStr = this.initRequestMobileJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_ONLY_SMS_MESSAGE_URL", "");
        } else if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_WX)) {
            String requestJsonStr = this.initRequestWXJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_WX_MESSAGE_URL", "");
        } else {
            rspBO = new PebTheOrderRemindRspBO();
            rspBO.setRespCode("102003");
            rspBO.setRespDesc("\u672a\u77e5\u901a\u77e5\u7c7b\u578b");
        }
        return rspBO;
    }

    private PebTheOrderRemindRspBO sendFrom(String requestJsonStr, String url, String token) {
        PebTheOrderRemindRspBO rspBO = new PebTheOrderRemindRspBO();
        Map map = (Map)JSONObject.parseObject((String)requestJsonStr, Map.class);
        HashMap<String, String> param = new HashMap<String, String>(map.size());
        for (Map.Entry elem : map.entrySet()) {
            if (elem.getValue() == null) continue;
            param.put((String)elem.getKey(), elem.getValue().toString());
        }
        try {
            HashMap<String, String> header = null;
            if (token != null) {
                header = new HashMap<String, String>(1);
                header.put("auth-token", token);
            }
            String rsp = SSLClient.doPost((String)url, param, header);
            LOGGER.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a" + rsp);
            rspBO = this.resolveRsp(rsp);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("102003");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private PebTheOrderRemindRspBO doUrlPostRequest(String requestJsonStr, String url, String token) {
        PebTheOrderRemindRspBO rspBO = new PebTheOrderRemindRspBO();
        try {
            HttpRetBean httpRetBean;
            Header[] headers = HSNHttpHeader.getRequestHeaders((String)"json");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                Header[] header = new Header[headers.length + 1];
                System.arraycopy(headers, 0, header, 0, headers.length);
                header[headers.length] = new BasicHeader("auth-token", token);
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)url)), (Header[])header, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            } else {
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)url)), (Header[])headers, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            }
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)url) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new UocProBusinessException("102001", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("102003");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    public static void main(String[] args) throws Exception {
        PebTheOrderRemindBusiServiceImpl pebTheOrderRemindBusiService = new PebTheOrderRemindBusiServiceImpl();
        PebTheOrderRemindRspBO rspBO = pebTheOrderRemindBusiService.sendFrom("{\n\t\"to\": \"liaoxj @tydic.com \",\n\t\"content \": \"\u8ba2\u5355\u6210\u4ea4\u901a\u77e5 \",\n\n\t\"subject \": \"\u5c0a\u656c\u7684\u7528\u6237\u60a8\u597d\uff01 \u60a8\u5728\u5728\u7ebf\u4ea4\u6613\u5e73\u53f0\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u7ecf\u4e0b\u5355\u6210\u529f\uff0c \u8ba2\u5355\u7f16\u53f7 { < a href = 'http://www.xxxx.com.cn' > YGZK20200526954546 < /a>}\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002\"\n}", "http://10.105.29.22:31032/notifyApi/sendEMail", null);
        System.out.println(JSON.toJSONString((Object)((Object)rspBO)));
    }

    private String initRequestEmailJsonStr(PebTheOrderRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("to", (Object)reqBO.getEmail());
        jsonObject.put("content", (Object)reqBO.getText());
        jsonObject.put("subject", (Object)reqBO.getSubject());
        return jsonObject.toJSONString();
    }

    private String initRequestMobileJsonStr(PebTheOrderRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mobile", (Object)reqBO.getMobile());
        jsonObject.put("content", (Object)reqBO.getText());
        return jsonObject.toJSONString();
    }

    private String initRequestMessageJsonStr(PebTheOrderRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sendid", (Object)(ObjectUtil.isEmpty((Object)reqBO.getUserId()) ? reqBO.getReceiveId() : reqBO.getUserId()));
        jsonObject.put("recid", (Object)reqBO.getReceiveId());
        jsonObject.put("appid", (Object)OrderPropertiesUtil.getProperty((String)"APP_ID"));
        jsonObject.put("titel", (Object)("title:" + reqBO.getTitel()));
        jsonObject.put("text", (Object)reqBO.getText());
        jsonObject.put("token", (Object)reqBO.getToken());
        if (null != reqBO.getTemplateId() && reqBO.getTemplateId() != 0L) {
            jsonObject.put("templateId", (Object)reqBO.getTemplateId());
            jsonObject.put("templateParam", (Object)JSON.toJSONString(reqBO.getTemplateParam()));
        }
        return jsonObject.toJSONString();
    }

    private String initRequestWXJsonStr(PebTheOrderRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)reqBO.getOpenId());
        jsonObject.put("template_id", (Object)reqBO.getTemplateIdWX());
        LinkedHashMap<String, JSONObject> data = new LinkedHashMap<String, JSONObject>();
        JSONObject title = new JSONObject();
        title.put("value", (Object)reqBO.getTitel());
        data.put("first", title);
        JSONObject content = new JSONObject();
        content.put("value", (Object)reqBO.getText());
        data.put("keyword1", content);
        JSONObject time = new JSONObject();
        time.put("value", (Object)DateUtil.formatDateTime((Date)new Date()));
        data.put("keyword2", time);
        jsonObject.put("data", data);
        return jsonObject.toJSONString();
    }

    private PebTheOrderRemindRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        PebTheOrderRemindRspBO rspBO = new PebTheOrderRemindRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f!");
        return rspBO;
    }
}

