/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.desensitize.codec.tm;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.tydic.desensitize.codec.tm.SecretColumn;
import com.tydic.desensitize.codec.tm.SecretStrategy;
import java.io.IOException;
import java.util.Objects;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class SecretJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private SecretStrategy secretStrategy;

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        SecretColumn annotation = (SecretColumn)beanProperty.getAnnotation(SecretColumn.class);
        if (Objects.nonNull(annotation) && Objects.equals(String.class, beanProperty.getType().getRawClass())) {
            this.secretStrategy = annotation.strategy();
            return this;
        }
        return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
    }

    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (Objects.isNull((Object)this.secretStrategy)) {
            jsonGenerator.writeString(s);
        } else {
            try {
                String conditionValue;
                RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
                if (Objects.nonNull(requestAttributes) && Objects.equals(conditionValue = (String)requestAttributes.getAttribute("isDesensitized", 0), "1")) {
                    jsonGenerator.writeString(s);
                    return;
                }
            }
            catch (Exception e) {
                jsonGenerator.writeString(s);
            }
            jsonGenerator.writeString(this.secretStrategy.getDesensitizer().apply(s));
        }
    }
}

