/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.desensitize.codec.encypt.util;

import com.tydic.desensitize.codec.encypt.SensitiveField;
import com.tydic.desensitize.codec.encypt.util.AesUtil;
import java.lang.reflect.Field;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class DecryptImpl {
    public static <T> T decrypt(T result) throws IllegalAccessException {
        Field[] declaredFields;
        Class<?> resultClass = result.getClass();
        for (Field field : declaredFields = resultClass.getDeclaredFields()) {
            SensitiveField sensitiveField = field.getAnnotation(SensitiveField.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(result);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            try {
                if (value.startsWith("0X01_")) {
                    value = value.substring(5);
                    value = AesUtil.decrypt(value);
                }
                field.set(result, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

