/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.desensitize.codec.tm;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum SecretStrategy {
    USERNAME(str -> SecretStrategy.chineseName(str)),
    ID_CARD(str -> str.replaceAll("(\\d{4})\\d{10}(\\w{4})", "$1**********$2")),
    PHONE(str -> str.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2")),
    ADDRESS(str -> SecretStrategy.maskDetailedAddress(str));

    private final Function<String, String> desensitizer;

    private SecretStrategy(Function<String, String> desensitizer) {
        this.desensitizer = desensitizer;
    }

    public Function<String, String> getDesensitizer() {
        return this.desensitizer;
    }

    public static String maskDetailedAddress(String address) {
        String regex1 = "(?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a)(?<city>[^\u5e02]+\u5e02|.+\u81ea\u6cbb\u5dde)(?<county>[^\u533a]+\u533a|.+\u53bf)";
        String regex2 = "(?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a)(?<city>[^\u5e02]+\u5e02|.+\u81ea\u6cbb\u5dde)";
        String regex3 = "(?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a)(?<county>[^\u533a]+\u533a|.+\u53bf)";
        String regex4 = "(?<city>[^\u5e02]+\u5e02|.+\u81ea\u6cbb\u5dde)(?<county>[^\u533a]+\u533a|.+\u53bf)";
        String regex5 = "(?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a)";
        String regex6 = "(?<city>[^\u5e02]+\u5e02|.+\u81ea\u6cbb\u5dde)";
        String regex7 = "(?<county>[^\u533a]+\u533a|.+\u53bf)";
        String[] regex = new String[]{regex1, regex2, regex3, regex4, regex5, regex6, regex7};
        if (StringUtils.isEmpty((CharSequence)address)) {
            return "";
        }
        for (int i = 0; i <= 6; ++i) {
            Pattern pattern = Pattern.compile(regex[i]);
            Matcher matcher = pattern.matcher(address);
            if (!matcher.find()) continue;
            switch (i) {
                case 0: {
                    if (matcher.group("county").contains("\u5c0f\u533a")) {
                        return matcher.group("province") + matcher.group("city") + "****";
                    }
                    return matcher.group("province") + matcher.group("city") + matcher.group("county") + "****";
                }
                case 1: {
                    return matcher.group("province") + matcher.group("city") + "****";
                }
                case 2: {
                    if (matcher.group("county").contains("\u5c0f\u533a")) {
                        return matcher.group("province") + "****";
                    }
                    return matcher.group("province") + matcher.group("county") + "****";
                }
                case 3: {
                    if (matcher.group("county").contains("\u5c0f\u533a")) {
                        return matcher.group("city") + "****";
                    }
                    return matcher.group("city") + matcher.group("county") + "****";
                }
                case 4: {
                    return matcher.group("province") + "****";
                }
                case 5: {
                    return matcher.group("city") + "****";
                }
                case 6: {
                    if (matcher.group("county").contains("\u5c0f\u533a")) {
                        return "****";
                    }
                    return matcher.group("county") + "****";
                }
            }
        }
        return "****";
    }

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)1);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }
}

