/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.service.common;

import com.microsoft.schemas.vml.CTShape;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlObject;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    public static String uploadFile(MultipartFile multipartFile, String filePath) {
        try {
            File sourceFile = new File(filePath);
            if (!sourceFile.exists()) {
                sourceFile.mkdirs();
            }
            if (multipartFile.isEmpty()) {
                return "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e3a\u7a7a\uff01";
            }
            String fileName = multipartFile.getOriginalFilename();
            String path = filePath + File.separator + fileName;
            String absolutePath = new File(path).getAbsolutePath();
            File file = new File(absolutePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            multipartFile.transferTo(file);
            return absolutePath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "\u6210\u529f\uff01";
        }
    }

    public static String uploadFiles(MultipartFile[] multipartFiles, String filePath) {
        try {
            File sourceFile = new File(filePath);
            if (!sourceFile.exists()) {
                sourceFile.mkdirs();
            }
            if (multipartFiles.length > 0) {
                for (MultipartFile multipartFile : multipartFiles) {
                    if (multipartFile.isEmpty()) {
                        return "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e3a\u7a7a\uff01";
                    }
                    String fileName = multipartFile.getOriginalFilename();
                    String path = filePath + File.separator + fileName;
                    String absolutePath = new File(path).getAbsolutePath();
                    File file = new File(absolutePath);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    multipartFile.transferTo(file);
                }
                return "\u4e0a\u4f20\u6210\u529f\uff01";
            }
            return "\u4e0a\u4f20\u5931\u8d25\uff01";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "\u6210\u529f\uff01";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String fileUrl, String fileName, HttpServletResponse res) throws IOException {
        File file = new File(fileUrl + File.separator + fileName);
        boolean flag = FileUtils.fileIsExist(fileUrl, fileName);
        if (flag) {
            FileInputStream inputStream = null;
            OutputStream os = null;
            try {
                inputStream = new FileInputStream(file);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                ((InputStream)inputStream).close();
                byte[] data = outStream.toByteArray();
                res.reset();
                res.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
                res.setContentType("application/octet-stream");
                os = res.getOutputStream();
                os.write(data);
                os.flush();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                if (os != null) {
                    os.close();
                }
            }
        } else {
            throw new IOException("\u4e0b\u8f7d\u5931\u8d25\uff0c\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }

    public static boolean fileIsExist(String filePath, String fileName) {
        File fileSource = new File(filePath + File.separator + fileName);
        return fileSource.exists();
    }

    public static void copyFile(String sourcePath, String newPath) {
        try {
            BufferedInputStream bufferedInputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            FileInputStream input = null;
            FileOutputStream output = null;
            File fileSource = new File(sourcePath);
            File fileDest = new File(newPath);
            if (fileSource.exists() && fileSource.list() != null) {
                String[] list;
                if (!fileDest.exists()) {
                    fileDest.mkdirs();
                }
                for (String fileName : list = fileSource.list()) {
                    int length;
                    input = new FileInputStream(fileSource + File.separator + fileName);
                    bufferedInputStream = new BufferedInputStream(input);
                    output = new FileOutputStream(fileDest + File.separator + fileName);
                    bufferedOutputStream = new BufferedOutputStream(output);
                    byte[] bytes = new byte[2048];
                    while ((length = bufferedInputStream.read(bytes)) > 0) {
                        bufferedOutputStream.write(bytes, 0, length);
                    }
                    bufferedInputStream.close();
                    bufferedOutputStream.close();
                    ((InputStream)input).close();
                    ((OutputStream)output).close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteFileList(String sourcePath) {
        File file;
        String[] list;
        if (sourcePath != null && !"".equals(sourcePath) && (list = (file = new File(sourcePath)).list()) != null && list.length > 0) {
            for (String name : list) {
                File f = new File(sourcePath, name);
                f.delete();
            }
        }
    }

    public static void addWaterMark(String filePath, String sourceFileName, String test, String outFileUrl, String outFileName) {
        try {
            FileInputStream in = new FileInputStream(new File(filePath + File.separator + sourceFileName));
            FileOutputStream out = null;
            XWPFDocument document = new XWPFDocument((InputStream)in);
            XWPFHeaderFooterPolicy xFooter = new XWPFHeaderFooterPolicy(document);
            xFooter.createWatermark(test);
            XWPFHeader header = xFooter.getHeader(3);
            XWPFParagraph paragraph = header.getParagraphArray(0);
            XmlObject[] xmlObjects = paragraph.getCTP().getRArray(0).getPictArray(0).selectChildren(new QName("urn:schemas-microsoft-com:vml", "shape"));
            if (xmlObjects.length > 0) {
                CTShape ctshape = (CTShape)xmlObjects[0];
                ctshape.setFillcolor("#F08080");
                ctshape.setStyle(FileUtils.getWaterMarkStyle(ctshape.getStyle(), 40.0) + ";rotation:315");
            }
            out = new FileOutputStream(new File(outFileUrl + File.separator + outFileName));
            document.write((OutputStream)out);
            out.flush();
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getWaterMarkStyle(String styleStr, double height) {
        String[] strs;
        Pattern p = Pattern.compile(";");
        for (String str : strs = p.split(styleStr)) {
            if (!str.startsWith("height:")) continue;
            String heightStr = "height:" + height + "pt";
            styleStr = styleStr.replace(str, heightStr);
            break;
        }
        return styleStr;
    }
}

