/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class DictSystemFeignClientConfig {
    @Bean(value={"dictManageFeignEncoder"})
    public Encoder feignEncoderPageable(@Autowired ObjectMapper objectMapper) {
        SpringEncoder encoder = new SpringEncoder(() -> new HttpMessageConverters(this.getHttpMessageConverters(objectMapper)));
        return encoder;
    }

    @Bean(value={"dictManageFeignDecoder"})
    public Decoder feignDecoder(@Autowired ObjectMapper objectMapper) {
        return new SpringDecoder(() -> new HttpMessageConverters(this.getHttpMessageConverters(objectMapper)));
    }

    private List<HttpMessageConverter<?>> getHttpMessageConverters(ObjectMapper objectMapper) {
        ArrayList converters = new ArrayList();
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setObjectMapper(objectMapper);
        converters.add((HttpMessageConverter<?>)mappingJackson2HttpMessageConverter);
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setDefaultCharset(StandardCharsets.UTF_8);
        converters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        return converters;
    }
}

