package com.tydic.dict.system.client;

import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.client.config.DictSystemFeignClientConfig;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoAddReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoDelReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoEditReqBO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author zhouyi
 * @date 2024/9/24
 **/
@FeignClient(value = "dict-manage", configuration = DictSystemFeignClientConfig.class)
@RequestMapping("/manage/api/audit-todo")
public interface DictAuditTaskTodoClient {

    @PostMapping("/add")
    DictResult<String> add(@RequestBody DictAuditTaskTodoAddReqBO reqBO);

    @PostMapping("/edit")
    DictResult<String> edit(@RequestBody DictAuditTaskTodoEditReqBO reqBO);

    @PostMapping("/delete")
    DictResult<String> delete(@RequestBody DictAuditTaskTodoDelReqBO reqBO);
}
