package com.tydic.dict.system.client;

import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.client.config.DictSystemFeignClientConfig;
import com.tydic.dict.system.service.bo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

@FeignClient(value = "dict-manage", configuration = DictSystemFeignClientConfig.class)
@RequestMapping("/manage/api/dictionary")
public interface DictDictionaryClient {


    @PostMapping("/searchByModuleNameAndDicDir")
    DictResult<List<DictDictionaryRspBO>> searchByModuleNameAndDicDir(@Validated @RequestBody DictDictionaryQryByModuNameAndDicDirReqBO reqBO);

    @PostMapping("/searchByDicKey")
    DictResult<DictDictionaryRspBO> searchByDicKey(@Validated @RequestBody DictDictionaryQryByDicKeyReqBO reqBO);

    @PostMapping("/batchSearchByDicKey")
    DictResult<Map<String, String>> batchSearchByDicKey(@RequestBody DictDictionaryBatchQryByDicKeyReqBO reqBO);

    @PostMapping("/add")
    DictResult<String> add(@Validated @RequestBody DictDictionaryAddReqBO reqBO);

    @PostMapping("/update")
    DictResult<String> update(@Validated @RequestBody DictDictionaryUpdateReqBO reqBO);

    @PostMapping("/delete")
    DictResult<String> delete(@RequestBody DictDictionaryDelReqBO reqBO);

}
