package com.tydic.dict.system.client;

import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.client.config.DictSystemFeignClientConfig;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoAddReqBO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(value = "dict-manage", configuration = DictSystemFeignClientConfig.class)
@RequestMapping("/manage/api/message-center")
public interface DictMessageCenterClient {

    @PostMapping("/add")
    DictResult<String> add(@Validated @RequestBody DictMessageCenterInfoAddReqBO reqBO);

}
