package com.tydic.dict.system.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class DictSystemFeignClientConfig {

    @Bean("dictManageFeignEncoder")
    public Encoder feignEncoderPageable(@Autowired ObjectMapper objectMapper) {
        Encoder encoder = new SpringEncoder(() -> new HttpMessageConverters(getHttpMessageConverters(objectMapper)));
        return encoder;
    }

    @Bean("dictManageFeignDecoder")
    public Decoder feignDecoder(@Autowired ObjectMapper objectMapper) {
        return new SpringDecoder(() -> new HttpMessageConverters(getHttpMessageConverters(objectMapper)));
    }

    private List<HttpMessageConverter<?>> getHttpMessageConverters(ObjectMapper objectMapper) {
        List<HttpMessageConverter<?>> converters = new ArrayList<>();

        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setObjectMapper(objectMapper);
        converters.add(mappingJackson2HttpMessageConverter);

        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setDefaultCharset(StandardCharsets.UTF_8);
        converters.add(stringHttpMessageConverter);
        return converters;
    }

}
