package com.tydic.dict.repository;

import com.tydic.dict.model.student.DemoStudentDo;
import com.tydic.dict.model.student.qrybo.DemoStudentQryBo;
import com.tydic.dict.model.student.sub.DemoCourseRelation;

import java.util.List;

/**
 * 描述：
 *
 * @author: gujb
 * @date: 2022-09-20 14:52:28
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DemoStudentRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: demoStudentQryBo
     * @return: DemoStudentQryBo
     * @author: gujb
     * @date: 2022-09-20 14:52:28
     */
    DemoStudentDo queryDemoStudentSingle(DemoStudentQryBo demoStudentQryBo);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: demoStudentReqBO
     * @return: DemoStudentRspBO
     * @author: gujb
     * @date: 2022-09-20 14:52:28
     */

    List<DemoStudentDo> queryDemoStudentList(DemoStudentQryBo demoStudentQryBo);

    /**
     * 描述:选课
     *
     * @throws
     * @param: demoTeacherQryBo
     * @return: DemoTeacherQryBo
     * @author: gujb
     * @date: 2022-09-20 14:52:28
     */
    DemoCourseRelation selectCourse(DemoStudentQryBo demoStudentQryBo);
}

