/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.PageReadListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.bo.BaseReqBO;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictMessageTemplateMapper;
import com.tydic.dict.system.repository.po.DictBasePO;
import com.tydic.dict.system.repository.po.DictMessageTemplatePO;
import com.tydic.dict.system.repository.service.update.DictMessageTemplateUpdateService;
import com.tydic.dict.system.repository.util.ValidationUtil;
import com.tydic.dict.system.service.bo.DictMessageTemplateErrorRspBO;
import com.tydic.dict.system.service.bo.DictMessageTemplateReqBO;
import com.tydic.dict.system.service.common.ExcelUtil;
import freemarker.template.Configuration;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DictMessageTemplateUpdateServiceImpl
extends ServiceImpl<DictMessageTemplateMapper, DictMessageTemplatePO>
implements DictMessageTemplateUpdateService {
    private static final Logger log = LoggerFactory.getLogger(DictMessageTemplateUpdateServiceImpl.class);
    @Autowired
    private DictMessageTemplateMapper dictMessageTemplateMapper;
    @Autowired
    private Configuration freemarkerConfig;
    @Autowired
    ExcelUtil excelUtil;
    private static final int BATCH_SIZE = 100;
    private static int ROW_NUM = 1;
    private static final String BASE_PATH = "dict-manage-infrastructure/src/main/resources/messageTemplate";
    private static final String ERROR_MESSAGE_BASE_PATH = "dict-manage-infrastructure/src/main/resources/messageTemplate/errorMessage.xlsx";
    private static final String MESSAGE_TEMPLATE_FILENAME = "messageTemplate.xlsx";

    @Override
    public int add(DictMessageTemplateReqBO req) {
        List templatePOList = this.dictMessageTemplateMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictBasePO::getDeleted, (Object)false)).eq(DictMessageTemplatePO::getCode, (Object)req.getCode())).or()).eq(DictMessageTemplatePO::getName, (Object)req.getName()));
        if (CollectionUtil.isNotEmpty((Collection)templatePOList)) {
            return -1;
        }
        DictMessageTemplatePO messageTemplatePO = (DictMessageTemplatePO)BeanUtil.toBean((Object)req, DictMessageTemplatePO.class);
        if (ObjectUtil.isEmpty((Object)messageTemplatePO.getTitle())) {
            messageTemplatePO.setTitle(messageTemplatePO.getName());
        }
        messageTemplatePO.setUpdatedBy("admin");
        messageTemplatePO.setCreatedBy("admin");
        return this.dictMessageTemplateMapper.insert(messageTemplatePO);
    }

    @Override
    public int updateMessageTemplate(DictMessageTemplateReqBO req) {
        if (req.getId() != null) {
            List templatePOList = this.dictMessageTemplateMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(DictMessageTemplatePO::getId, (Object)req.getId())).eq(DictBasePO::getDeleted, (Object)false)).and(innerWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)innerWrapper.eq(DictMessageTemplatePO::getCode, (Object)req.getCode())).or()).eq(DictMessageTemplatePO::getName, (Object)req.getName());
            }));
            if (CollectionUtil.isNotEmpty((Collection)templatePOList)) {
                return -1;
            }
            DictMessageTemplatePO po = (DictMessageTemplatePO)this.dictMessageTemplateMapper.selectById(req.getId());
            po.setUpdatedTime(new Date());
            po.setUpdatedBy("admin");
            BeanUtil.copyProperties((Object)req, (Object)po);
            return this.dictMessageTemplateMapper.update(po, (Wrapper)Wrappers.lambdaUpdate().eq(DictMessageTemplatePO::getId, (Object)req.getId()));
        }
        return 0;
    }

    private String convertTemplateSyntax(String template) {
        Pattern pattern = Pattern.compile("\\{([^{}]+)\\}");
        Matcher matcher = pattern.matcher(template);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String content = matcher.group(1);
            matcher.appendReplacement(result, "\\$\\{" + content + "\\}");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String evaluateExpressions(String input) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        Pattern pattern = Pattern.compile("\\d+\\s*[-+*/]\\s*\\d+");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String expression = matcher.group();
            try {
                Object evalResult = engine.eval(expression);
                matcher.appendReplacement(result, evalResult.toString());
            }
            catch (Exception e) {
                matcher.appendReplacement(result, matcher.group());
                log.error("\u8ba1\u7b97\u8868\u8fbe\u5f0f\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @Override
    public DictResult<String> uploadMessageTemplate(MultipartFile file, BaseReqBO req) {
        if (file == null) {
            return DictResult.error(null, (String)"\u5185\u5bb9\u4e3a\u7a7a");
        }
        HashMap errorMap = new HashMap();
        ArrayList errorList = new ArrayList();
        try {
            this.excelUtil.readExcel(file.getInputStream(), DictMessageTemplatePO.class, (ReadListener)new PageReadListener(dataList -> {
                for (DictMessageTemplatePO po : dataList) {
                    String error = ValidationUtil.validateDictMessageTemplate(po);
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{error})) continue;
                    errorMap.put(po.getCode(), error);
                }
                errorMap.forEach((k, v) -> {
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{v})) {
                        String error = "\u6570\u636e\u6821\u9a8c\u5931\u8d25";
                        errorList.add(error);
                    }
                });
                if (errorList.isEmpty()) {
                    this.saveBatch((List<DictMessageTemplatePO>)dataList, req);
                }
                this.generateErrorReport((List<DictMessageTemplatePO>)dataList, errorMap, errorList);
            }));
            if (errorList.size() > 0) {
                return DictResult.error(null, (String)("\u5bfc\u5165\u5931\u8d25\uff0c\u5171\u6709 " + errorList.size() + " \u6761\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002, "));
            }
            return DictResult.success((Object)"\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6d88\u606f\u6a21\u7248\u5931\u8d25: {}", (Object)e.getMessage());
            return DictResult.error(null, (String)"\u5bfc\u5165\u5931\u8d25");
        }
    }

    public void saveBatch(List<DictMessageTemplatePO> dataList, BaseReqBO req) {
        ArrayList<DictMessageTemplatePO> batchList = new ArrayList<DictMessageTemplatePO>();
        batchList.addAll(dataList);
        if (batchList.size() >= 100) {
            batchList.forEach(po -> {
                po.setUpdatedBy("admin");
                po.setCreatedBy("admin");
            });
            this.saveBatch(batchList, req);
            batchList.clear();
        }
        if (!batchList.isEmpty()) {
            this.saveBatch(batchList, req);
        }
    }

    public void generateErrorReport(List<DictMessageTemplatePO> dataList, HashMap<String, String> errorMap, List<String> errorList) {
        ArrayList errorRspBOList = new ArrayList();
        List<String> excludeColumns = Arrays.asList("id");
        dataList.forEach(po -> {
            DictMessageTemplateErrorRspBO errorRspBO = new DictMessageTemplateErrorRspBO();
            BeanUtil.copyProperties((Object)po, (Object)errorRspBO);
            String errorMessage = (String)errorMap.get(po.getCode());
            errorRspBO.setErrorMessage(errorMessage);
            errorRspBOList.add(errorRspBO);
        });
        try {
            String fileName = URLEncoder.encode("\u9519\u8bef\u62a5\u544a", "UTF-8").replaceAll("\\+", "%20");
            ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)Files.newOutputStream(Paths.get(ERROR_MESSAGE_BASE_PATH, new String[0]), new OpenOption[0]), DictMessageTemplateErrorRspBO.class).sheet(fileName).excludeColumnFieldNames(excludeColumns)).doWrite(errorRspBOList);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u9519\u8bef\u62a5\u544a\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }
}

