/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictPage;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictAnnouncementMapper;
import com.tydic.dict.system.repository.po.DictAnnouncementPo;
import com.tydic.dict.system.repository.po.DictBasePO;
import com.tydic.dict.system.repository.service.search.DictAnnouncementSearchService;
import com.tydic.dict.system.service.bo.DictAnnouncementPageReqBo;
import com.tydic.dict.system.service.bo.DictAnnouncementRspBo;
import com.tydic.dict.system.service.constants.HomeConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class DictAnnouncementSearchServiceImpl
extends ServiceImpl<DictAnnouncementMapper, DictAnnouncementPo>
implements DictAnnouncementSearchService {
    @Autowired
    private DictAnnouncementMapper dictAnnouncementMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String ANNOUNCEMENT_CACHE_KEY = "announcement_list";

    @Override
    public DictResult<DictAnnouncementRspBo> detail(Long id) {
        if (id == null) {
            return DictResult.error(null, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DictAnnouncementPo po = (DictAnnouncementPo)this.dictAnnouncementMapper.selectById(id);
        if (po == null) {
            return DictResult.error(null, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        return DictResult.success((Object)BeanUtil.copyProperties((Object)po, DictAnnouncementRspBo.class));
    }

    @Override
    public DictResult<DictPage<DictAnnouncementRspBo>> queryByCondition(DictAnnouncementPageReqBo req) {
        Page page = (Page)this.dictAnnouncementMapper.selectPage((IPage)new Page((long)req.getPageNo(), (long)req.getPageSize()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(StringUtils.isNotBlank((CharSequence)req.getTitle()), DictAnnouncementPo::getTitle, (Object)req.getTitle())).eq(ObjectUtil.isNotEmpty((Object)req.getType()), DictAnnouncementPo::getType, (Object)req.getType())).eq(ObjectUtil.isNotEmpty((Object)req.getStatus()), DictAnnouncementPo::getStatus, (Object)req.getStatus())).between(ObjectUtil.isNotEmpty((Object)req.getBeginTime()) && ObjectUtil.isNotEmpty((Object)req.getFinishTime()), DictBasePO::getCreatedTime, (Object)req.getBeginTime(), (Object)req.getFinishTime())).orderByDesc(DictBasePO::getCreatedTime));
        if (page == null) {
            return DictResult.error(null, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        ArrayList rspBoList = new ArrayList();
        page.getRecords().forEach(po -> {
            DictAnnouncementRspBo rspBo = (DictAnnouncementRspBo)BeanUtil.copyProperties((Object)po, DictAnnouncementRspBo.class);
            rspBoList.add(rspBo);
        });
        DictPage dictPage = DictPage.newInstance((int)req.getPageNo(), (int)req.getPageSize(), rspBoList, (long)page.getTotal());
        return DictResult.success((Object)dictPage);
    }

    @Override
    public DictResult<List<DictAnnouncementRspBo>> selectList() {
        List poList = this.dictAnnouncementMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictAnnouncementPo::getStatus, (Object)HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)).orderByDesc(DictAnnouncementPo::getTop)).orderByDesc(DictAnnouncementPo::getPublishTime));
        if (CollectionUtil.isEmpty((Collection)poList)) {
            return DictResult.error(null, (String)"\u6682\u65e0\u516c\u544a");
        }
        Date currentDate = new Date();
        for (DictAnnouncementPo po2 : poList) {
            if (po2.getStartTime() == null || po2.getEndTime() == null) continue;
            if (currentDate.after(po2.getStartTime()) && currentDate.before(po2.getEndTime())) {
                po2.setTop(HomeConstant.ANNOUNCEMENT_TOP);
                continue;
            }
            po2.setTop(HomeConstant.ANNOUNCEMENT_NO_TOP);
            po2.setStartTime(null);
            po2.setEndTime(null);
            this.dictAnnouncementMapper.updateById(po2);
        }
        poList = poList.stream().sorted(Comparator.comparing(DictAnnouncementPo::getTop, Comparator.nullsFirst(Comparator.reverseOrder())).thenComparing(DictAnnouncementPo::getPublishTime, Comparator.nullsFirst(Comparator.reverseOrder()))).collect(Collectors.toList());
        List rspBoList = poList.stream().map(po -> (DictAnnouncementRspBo)BeanUtil.copyProperties((Object)po, DictAnnouncementRspBo.class)).collect(Collectors.toList());
        return DictResult.success(rspBoList);
    }

    @Override
    public DictResult<DictPage<DictAnnouncementRspBo>> queryAnnouncementPage(DictAnnouncementPageReqBo req) {
        Page page = (Page)this.dictAnnouncementMapper.selectPage((IPage)new Page((long)req.getPageNo(), (long)req.getPageSize()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictAnnouncementPo::getStatus, (Object)HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)).like(StringUtils.isNotBlank((CharSequence)req.getTitle()), DictAnnouncementPo::getTitle, (Object)req.getTitle())).eq(ObjectUtil.isNotEmpty((Object)req.getType()), DictAnnouncementPo::getType, (Object)req.getType())).between(ObjectUtil.isNotEmpty((Object)req.getBeginTime()) && ObjectUtil.isNotEmpty((Object)req.getFinishTime()), DictAnnouncementPo::getPublishTime, (Object)req.getBeginTime(), (Object)req.getFinishTime())).orderByDesc(DictAnnouncementPo::getTop)).orderByDesc(DictAnnouncementPo::getPublishTime));
        if (page == null) {
            return DictResult.error(null, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        ArrayList rspBoList = new ArrayList();
        page.getRecords().forEach(po -> {
            DictAnnouncementRspBo rspBo = (DictAnnouncementRspBo)BeanUtil.copyProperties((Object)po, DictAnnouncementRspBo.class);
            rspBoList.add(rspBo);
        });
        DictPage dictPage = DictPage.newInstance((int)req.getPageNo(), (int)req.getPageSize(), rspBoList, (long)page.getTotal());
        return DictResult.success((Object)dictPage);
    }
}

