/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.authority.common.rsp.DictPage;
import com.tydic.dict.system.repository.dao.DictMessageCenterInfoMapper;
import com.tydic.dict.system.repository.service.search.DictMessageCenterInfoSearchService;
import com.tydic.dict.system.service.bo.DictCommonDelExportReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoDetailReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoListReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictMessageCenterInfoSearchServiceImpl
implements DictMessageCenterInfoSearchService {
    @Autowired
    private DictMessageCenterInfoMapper dictMessageCenterInfoMapper;

    @Override
    public DictPage<DictMessageCenterInfoRspBO> list(DictMessageCenterInfoListReqBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMessageContent())) {
            reqBO.setMessageContent("%" + reqBO.getMessageContent() + "%");
        }
        String startTime = null;
        if (Objects.nonNull(reqBO.getCreateTimeStart())) {
            startTime = DateUtil.formatDateTime((Date)DateUtil.beginOfDay((Date)reqBO.getCreateTimeStart()));
        }
        String endTime = null;
        if (Objects.nonNull(reqBO.getCreateTimeEnd())) {
            endTime = DateUtil.formatDateTime((Date)DateUtil.beginOfDay((Date)reqBO.getCreateTimeEnd()));
        }
        Page<DictMessageCenterInfoRspBO> pageData = this.dictMessageCenterInfoMapper.selectByCondition(reqBO, startTime, endTime, (Page<DictMessageCenterInfoRspBO>)new Page((long)reqBO.getPageNo(), (long)reqBO.getPageSize()));
        return DictPage.newInstance((int)reqBO.getPageNo(), (int)reqBO.getPageSize(), (List)pageData.getRecords(), (long)pageData.getTotal());
    }

    @Override
    public DictMessageCenterInfoRspBO detail(DictMessageCenterInfoDetailReqBO reqBO) {
        DictMessageCenterInfoRspBO rspBO = null;
        if (Objects.nonNull(reqBO.getId())) {
            rspBO = this.dictMessageCenterInfoMapper.detail(reqBO.getId());
        }
        return rspBO;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void batchRead(DictCommonDelExportReqBO reqBO) {
        List<Long> ids = reqBO.getIds();
        if (CollectionUtils.isNotEmpty((Collection)ids) && CollectionUtils.isNotEmpty(ids = ids.stream().distinct().collect(Collectors.toList()))) {
            this.dictMessageCenterInfoMapper.batchRead(ids);
        }
    }
}

